/*
 * Decompiled with CFR 0.152.
 */
package cs3410;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class Joystick
extends ManagedComponent {
    public static final ComponentFactory factory = new Factory();
    static final BitWidth RESOLUTION = BitWidth.create((int)3);
    private MyListener myListener = new MyListener();
    static final int P_X = 0;
    static final int P_Y = 1;
    int jx;
    int jy;
    static /* synthetic */ Class class$0;

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    private Joystick(Location loc, AttributeSet attrs) {
        super(loc, attrs, 2);
        this.setEnd(0, loc.translate(0, -10), RESOLUTION, 2);
        this.setEnd(1, loc.translate(0, 0), RESOLUTION, 2);
    }

    public Object getFeature(Object key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.cburch.logisim.tools.Pokable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return key == clazz ? this.myListener : super.getFeature(key);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    public void propagate(CircuitState circuitState) {
        circuitState.setValue(this.loc(0), Value.createKnown((BitWidth)RESOLUTION, (int)this.jx), (Component)this, 5);
        circuitState.setValue(this.loc(1), Value.createKnown((BitWidth)RESOLUTION, (int)this.jy), (Component)this, 5);
    }

    public void draw(ComponentDrawContext context) {
        this.drawJoystick(context, context.getGraphics(), 0, 0);
    }

    public void drawJoystick(ComponentDrawContext context, Graphics g, int x, int y) {
        Bounds bds = this.getBounds();
        g.drawRoundRect(bds.getX(), bds.getY(), 30, 30, 6, 6);
        g.drawRoundRect(bds.getX() + 2, bds.getY() + 2, 26, 26, 4, 4);
        if (context != null) {
            context.drawPin((Component)this, 0);
        }
        if (context != null) {
            context.drawPin((Component)this, 1);
        }
        int cx = bds.getX() + 15;
        int cy = bds.getY() + 15;
        g.setColor(Color.WHITE);
        g.fillOval(cx - 5, cy - 5, 10, 10);
        g.setColor(Color.BLACK);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(4.0f, 1, 1));
        }
        g.drawLine(cx, cy, cx + x, cy + y);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke());
        }
        g.fillOval(cx + x - 5, cy + y - 5, 10, 10);
        g.setColor(new Color(0x880000));
        g.fillOval(cx + x - 4, cy + y - 4, 8, 8);
        g.setColor(new Color(0xBB4444));
        g.fillOval(cx + x - 3, cy + y - 3, 5, 5);
        g.setColor(new Color(0xFF8888));
        g.fillOval(cx + x - 2, cy + y - 2, 3, 3);
        g.setColor(Color.BLACK);
    }

    /* synthetic */ Joystick(Location location, AttributeSet attributeSet, Joystick joystick) {
        this(location, attributeSet);
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "Joystick";
        }

        public String getDisplayName() {
            return "Joystick";
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new Joystick(loc, attrs, null);
        }

        public Bounds getOffsetBounds(AttributeSet arg0) {
            return Bounds.create((int)-30, (int)-20, (int)30, (int)30);
        }
    }

    private class MyListener
    implements Pokable {
        private MyListener() {
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            return new PokeCaret(event.getCircuitState());
        }
    }

    private class PokeCaret
    extends AbstractCaret {
        CircuitState circuitState;
        int px;
        int py;

        PokeCaret(CircuitState circuitState) {
            this.circuitState = circuitState;
        }

        public void draw(Graphics g) {
            Joystick.this.drawJoystick(null, g, this.px, this.py);
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void stopEditing() {
        }

        public void cancelEditing() {
        }

        public void mousePressed(MouseEvent e) {
            this.move(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
            this.move(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
            this.set(0, 0);
        }

        private void move(int mx, int my) {
            Bounds bds = Joystick.this.getBounds();
            this.set(mx - bds.getX() - 15, my - bds.getY() - 15);
        }

        private void set(int mx, int my) {
            this.px = mx < -14 ? -14 : (mx > 13 ? 13 : mx);
            this.py = my < -14 ? -14 : (my > 13 ? 13 : my);
            Joystick.this.jx = (this.px + 14) / 4 - 3;
            Joystick.this.jy = (this.py + 14) / 4 - 3;
            Joystick.this.propagate(this.circuitState);
        }
    }
}

