/*
 * Decompiled with CFR 0.152.
 */
package cs316;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Pin;
import com.cburch.logisim.circuit.PinFactory;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.circuit.SimulatorEvent;
import com.cburch.logisim.circuit.SimulatorListener;
import com.cburch.logisim.circuit.Subcircuit;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.gui.log.Loggable;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Tool;
import cs316.TesterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class Tester {
    static PinFactory pin_factory = PinFactory.instance;

    private static Circuit getCircuit(Project proj, String name) {
        Object result = null;
        Iterator it = proj.getLogisimFile().getTools().iterator();
        while (it.hasNext()) {
            Circuit circ;
            ComponentFactory comp;
            Tool t = (Tool)it.next();
            if (!(t instanceof AddTool) || !((comp = ((AddTool)t).getFactory()) instanceof Circuit) || !(circ = (Circuit)comp).getName().equals(name)) continue;
            return circ;
        }
        throw new TesterException("Circuit " + name + " not found.");
    }

    private static Component getComponent(Circuit circ, String name) {
        Iterator it = circ.getNonWires().iterator();
        while (it.hasNext()) {
            ManagedComponent c = (ManagedComponent)it.next();
            if (!(c instanceof Subcircuit ? name.equals(((Subcircuit)c).getSubcircuit().getName()) : name.equals(c.getAttributeSet().getValue(Pin.label_attr)))) continue;
            return c;
        }
        throw new TesterException("Component " + name + " not found.");
    }

    private static Pin getPin(int x, int y, boolean output, int width) {
        AttributeSet attrs = pin_factory.createAttributeSet();
        attrs.setValue(Pin.type_attr, (Object)new Boolean(output));
        attrs.setValue(Pin.width_attr, (Object)BitWidth.create((int)width));
        if (output) {
            attrs.setValue(Pin.facing_attr, (Object)Direction.WEST);
        }
        return (Pin)pin_factory.createComponent(Location.create((int)x, (int)y), attrs);
    }

    private static Wire getWire(int x1, int y1, int x2, int y2) {
        return Wire.create((Location)Location.create((int)x1, (int)y1), (Location)Location.create((int)x2, (int)y2));
    }

    private static CompData getSubcircuitData(Subcircuit circ) {
        ArrayList<PinData> pins = new ArrayList<PinData>();
        Iterator it = circ.getSubcircuit().getNonWires().iterator();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            if (!(c instanceof Pin)) continue;
            pins.add(new PinData((Pin)c));
        }
        Collections.sort(pins);
        CompData ret = new CompData();
        ret.circ = circ;
        ret.pins = pins;
        Tester.recomputeBounds(ret);
        return ret;
    }

    private static Location getSubcircuitPinLocation(CompData data, String name) {
        Iterator it = data.pins.iterator();
        while (it.hasNext()) {
            PinData pd = (PinData)it.next();
            if (!name.equalsIgnoreCase(pd.pin.getLabel())) continue;
            Location loc = data.circ.getLocation();
            Location base = loc.translate(Direction.EAST, data.bounds.getX(), data.bounds.getY());
            return base.translate(Direction.EAST, pd.offset.getX(), pd.offset.getY());
        }
        throw new TesterException("Pin " + name + " not found.");
    }

    private static void recomputeBounds(CompData data) {
        int y;
        int x;
        ArrayList pins = data.pins;
        int[] n = new int[4];
        int east = Direction.EAST.hashCode();
        int west = Direction.WEST.hashCode();
        int north = Direction.NORTH.hashCode();
        int south = Direction.SOUTH.hashCode();
        Iterator it = pins.iterator();
        while (it.hasNext()) {
            int di;
            PinData pd = (PinData)it.next();
            int n2 = di = pd.pin.getDirection().hashCode();
            n[n2] = n[n2] + 1;
        }
        int[] start = new int[4];
        int ht = Tester.computeAxis(start, n, east, west);
        int wid = Tester.computeAxis(start, n, north, south);
        if (n[west] > 0) {
            x = wid;
            y = start[west];
        } else if (n[south] > 0) {
            x = start[south];
            y = 0;
        } else if (n[east] > 0) {
            x = 0;
            y = start[east];
        } else if (n[north] > 0) {
            x = start[north];
            y = ht;
        } else {
            x = 0;
            y = 0;
        }
        data.bounds = Bounds.create((int)(-x), (int)(-y), (int)wid, (int)ht);
        Arrays.fill(n, 0);
        Iterator it2 = pins.iterator();
        while (it2.hasNext()) {
            PinData pd = (PinData)it2.next();
            int di = pd.pin.getDirection().hashCode();
            if (di == east) {
                pd.offset = Location.create((int)0, (int)(start[east] + n[di]));
            } else if (di == west) {
                pd.offset = Location.create((int)wid, (int)(start[west] + n[di]));
            } else if (di == north) {
                pd.offset = Location.create((int)(start[north] + n[di]), (int)ht);
            } else if (di == south) {
                pd.offset = Location.create((int)(start[south] + n[di]), (int)0);
            }
            int n3 = di;
            n[n3] = n[n3] + 10;
        }
    }

    private static int computeAxis(int[] start, int[] n, int i, int j) {
        int maxOffs;
        int dim;
        int others = n[0] + n[1] + n[2] + n[3] - n[i] - n[j];
        int max = Math.max(n[i], n[j]);
        switch (max) {
            case 0: {
                dim = 30;
                maxOffs = others == 0 ? 15 : 10;
                break;
            }
            case 1: {
                dim = 30;
                maxOffs = others == 0 ? 15 : 10;
                break;
            }
            case 2: {
                dim = 30;
                maxOffs = 10;
                break;
            }
            default: {
                if (others == 0) {
                    dim = 10 * max;
                    maxOffs = 5;
                    break;
                }
                dim = 10 * max + 10;
                maxOffs = 10;
            }
        }
        start[i] = maxOffs + 10 * ((max - n[i]) / 2);
        start[j] = maxOffs + 10 * ((max - n[j]) / 2);
        return dim;
    }

    private static void connectWireThroughX(Circuit circ, Location a, int x, Location b) {
        circ.add((Component)Tester.getWire(a.getX(), a.getY(), x, a.getY()));
        circ.add((Component)Tester.getWire(x, a.getY(), x, b.getY()));
        circ.add((Component)Tester.getWire(x, b.getY(), b.getX(), b.getY()));
    }

    private static void testHW1(File solution, File submission, boolean runSimulation) throws Exception {
        Project soln_proj = ProjectActions.doOpen(null, (File)solution);
        Circuit tester = Tester.getCircuit(soln_proj, "Tester");
        tester.setName("CS316.Tester");
        Component soln_comp = Tester.getComponent(tester, "ALU");
        Location soln_loc = soln_comp.getLocation();
        Project subm_proj = ProjectActions.doOpen(null, (File)submission);
        Circuit subm_circ = Tester.getCircuit(subm_proj, "ALU");
        Circuit adapter = new Circuit("CS316.Adapter");
        Pin pin_A = Tester.getPin(100, 100, false, 32);
        Pin pin_B = Tester.getPin(100, 200, false, 32);
        Pin pin_Sa = Tester.getPin(100, 300, false, 5);
        Pin pin_Op = Tester.getPin(100, 400, false, 4);
        Pin pin_C = Tester.getPin(500, 100, true, 32);
        Pin pin_O = Tester.getPin(500, 200, true, 1);
        adapter.add((Component)pin_A);
        adapter.add((Component)pin_B);
        adapter.add((Component)pin_Sa);
        adapter.add((Component)pin_Op);
        adapter.add((Component)pin_C);
        adapter.add((Component)pin_O);
        Subcircuit subm_comp = (Subcircuit)subm_circ.createComponent(Location.create((int)300, (int)500), subm_circ.createAttributeSet());
        CompData data = Tester.getSubcircuitData(subm_comp);
        adapter.add((Component)subm_comp);
        Tester.connectWireThroughX(adapter, pin_A.getLocation(), 200, Tester.getSubcircuitPinLocation(data, "A"));
        Tester.connectWireThroughX(adapter, pin_B.getLocation(), 210, Tester.getSubcircuitPinLocation(data, "B"));
        Tester.connectWireThroughX(adapter, pin_Sa.getLocation(), 220, Tester.getSubcircuitPinLocation(data, "Sa"));
        Tester.connectWireThroughX(adapter, pin_Op.getLocation(), 230, Tester.getSubcircuitPinLocation(data, "Op"));
        Tester.connectWireThroughX(adapter, pin_C.getLocation(), 400, Tester.getSubcircuitPinLocation(data, "C"));
        Tester.connectWireThroughX(adapter, pin_O.getLocation(), 410, Tester.getSubcircuitPinLocation(data, "O"));
        tester.remove(soln_comp);
        tester.add(adapter.createComponent(soln_loc, adapter.createAttributeSet()));
        subm_proj.doAction(LogisimFileActions.addCircuit((Circuit)adapter));
        subm_proj.doAction(LogisimFileActions.addCircuit((Circuit)tester));
        subm_proj.setCurrentCircuit(tester);
        soln_proj.getFrame().dispose();
        if (runSimulation) {
            CheckHW1 checkHW1 = new CheckHW1(subm_proj, tester, 255);
        }
    }

    public static void usage() {
        System.out.println("Usage:\n\nttjava cs316.Tester <command> <solution.circ> <submission.circ>");
        System.out.println("Commands:\n\thw1,hw1run  - Prepare HW1 test circuit (and optionally, run it)");
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            Tester.usage();
        }
        File sol = new File(args[1]);
        File sub = new File(args[2]);
        if (!sol.exists()) {
            System.out.println(String.valueOf(args[1]) + " does not exist.");
            System.exit(-1);
        }
        if (!sub.exists()) {
            System.out.println(String.valueOf(args[2]) + " does not exist.");
            System.exit(-1);
        }
        try {
            if (args[0].equals("hw1run")) {
                Tester.testHW1(sol, sub, true);
            } else if (args[0].equals("hw1")) {
                Tester.testHW1(sol, sub, false);
            } else {
                Tester.usage();
            }
        }
        catch (TesterException e) {
            e.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private static class CheckHW1
    implements SimulatorListener {
        Simulator sim;
        Project proj;
        CircuitState state;
        ArrayList components = new ArrayList();
        Circuit tester;
        boolean started = false;
        boolean high = false;
        int numTicks;

        CheckHW1(Project subm_proj, Circuit tester, int ticks) {
            this.proj = subm_proj;
            this.tester = tester;
            this.sim = this.proj.getSimulator();
            this.state = this.proj.getCircuitState();
            this.numTicks = ticks;
            StringBuffer s = new StringBuffer();
            this.components.add(new Format(Tester.getComponent(tester, "Count"), true, false));
            s.append("#  ");
            this.components.add(new Format(Tester.getComponent(tester, "Input A"), true, false));
            this.components.add(new Format(Tester.getComponent(tester, "Input B"), true, false));
            this.components.add(new Format(Tester.getComponent(tester, "Input Sa"), true, false));
            this.components.add(new Format(Tester.getComponent(tester, "Input Op"), false, false));
            s.append("A        ");
            s.append("B        ");
            s.append("Sa ");
            s.append("Op   ");
            this.components.add(new Format(Tester.getComponent(tester, "Expect C"), true, false));
            this.components.add(new Format(Tester.getComponent(tester, "Expect O"), false, false));
            s.append("[expct C ");
            s.append("O]");
            this.components.add(new Format(Tester.getComponent(tester, "Output C"), true, false));
            this.components.add(new Format(Tester.getComponent(tester, "Output O"), false, false));
            s.append("[reslt C ");
            s.append("O]");
            this.components.add(new Format(Tester.getComponent(tester, "C Different"), true, true));
            this.components.add(new Format(Tester.getComponent(tester, "O Different"), false, true));
            s.append("[diff? C ");
            s.append("O]");
            System.out.println(s);
            this.sim.requestReset();
            this.sim.setTickFrequency(1000);
            this.sim.addSimulatorListener((SimulatorListener)this);
            this.started = true;
            this.sim.setIsTicking(true);
        }

        public void propagationCompleted(SimulatorEvent e) {
            if (!this.started) {
                return;
            }
            boolean bl = this.high = !this.high;
            if (this.high) {
                return;
            }
            StringBuffer s = new StringBuffer();
            boolean yell = false;
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                Format f = (Format)i.next();
                Value v = f.component.getLogValue(this.state, null);
                if (f.yellNZ && v.toIntValue() != 0) {
                    yell = true;
                }
                if (f.hex) {
                    s.append(v.toHexString());
                } else {
                    s.append(v.toString());
                }
                s.append(" ");
            }
            if (yell) {
                s.append("*");
            } else {
                s.append(" ");
            }
            System.out.println(s);
            --this.numTicks;
            if (this.numTicks < 0) {
                this.sim.setIsTicking(false);
                System.exit(0);
            }
        }

        public void tickCompleted(SimulatorEvent e) {
        }

        public void simulatorStateChanged(SimulatorEvent e) {
        }

        private static class Format {
            Loggable component;
            boolean hex;
            boolean yellNZ;

            Format(Component component, boolean hex, boolean yellNZ) {
                this.component = (Loggable)component;
                this.hex = hex;
                this.yellNZ = yellNZ;
            }
        }
    }

    private static class CompData {
        Subcircuit circ;
        ArrayList pins;
        Bounds bounds;

        private CompData() {
        }
    }

    private static class PinData
    implements Comparable {
        Pin pin;
        Location offset;

        PinData(Pin p) {
            this.pin = p;
        }

        public int compareTo(Object other_raw) {
            int py1;
            int px1;
            int py0;
            int px0;
            PinData other = (PinData)other_raw;
            Direction d0 = this.pin.getDirection();
            Location p0 = this.pin.getLocation();
            if (d0 == Direction.EAST || d0 == Direction.WEST) {
                px0 = p0.getX();
                py0 = p0.getY();
            } else {
                py0 = p0.getX();
                px0 = p0.getY();
            }
            Location p1 = other.pin.getLocation();
            Direction d1 = other.pin.getDirection();
            if (d1 == Direction.EAST || d1 == Direction.WEST) {
                px1 = p1.getX();
                py1 = p1.getY();
            } else {
                py1 = p1.getX();
                px1 = p1.getY();
            }
            if (py0 != py1) {
                return py0 - py1;
            }
            return px0 - px1;
        }
    }
}

