/*
 * Decompiled with CFR 0.152.
 */
package cs316;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.util.GraphicsUtil;
import cs316.MipsALUFactory;
import java.awt.Graphics;

public class MipsALU
extends ManagedComponent {
    private static final BitWidth BITWIDTH_32 = BitWidth.create((int)32);
    private static final BitWidth BITWIDTH_4 = BitWidth.create((int)4);
    private static final BitWidth BITWIDTH_5 = BitWidth.create((int)5);

    public MipsALU(Location loc, AttributeSet attrs) {
        super(loc, attrs, 5);
        this.setEnd(0, loc.translate(-30, -30), BITWIDTH_32, 1);
        this.setEnd(1, loc.translate(-30, 30), BITWIDTH_32, 1);
        this.setEnd(2, loc.translate(-10, 40), BITWIDTH_4, 1);
        this.setEnd(3, loc.translate(10, 30), BITWIDTH_5, 1);
        this.setEnd(4, loc.translate(30, 0), BITWIDTH_32, 2);
    }

    public ComponentFactory getFactory() {
        return MipsALUFactory.instance;
    }

    public void propagate(CircuitState state) {
        int A = state.getValue(this.getEndLocation(0)).toIntValue();
        int B = state.getValue(this.getEndLocation(1)).toIntValue();
        int op = state.getValue(this.getEndLocation(2)).toIntValue();
        int shift = state.getValue(this.getEndLocation(3)).toIntValue();
        int ans = 0;
        switch (op) {
            case 0: 
            case 1: {
                ans = B << shift;
                break;
            }
            case 2: 
            case 3: {
                ans = A + B;
                break;
            }
            case 4: {
                ans = B >>> shift;
                break;
            }
            case 5: {
                ans = B >> shift;
                break;
            }
            case 6: 
            case 7: {
                ans = A - B;
                break;
            }
            case 8: 
            case 9: {
                ans = A & B;
                break;
            }
            case 10: 
            case 11: {
                ans = A | B;
                break;
            }
            case 12: 
            case 13: {
                ans = A ^ B;
                break;
            }
            case 14: 
            case 15: {
                ans = ~(A | B);
            }
        }
        Value out = Value.createKnown((BitWidth)BITWIDTH_32, (int)ans);
        state.setValue(this.getEndLocation(4), out, (Component)this, 4);
    }

    static void drawALU(Graphics g, Bounds bds) {
        int wid = bds.getWidth();
        int ht = bds.getHeight();
        int x0 = bds.getX();
        int x1 = x0 + wid;
        int y0 = bds.getY();
        int y1 = y0 + ht;
        int[] xp = new int[]{x0, x1, x1, x0, x0, x0 + 20, x0};
        int[] yp = new int[]{y0, y0 + 30, y1 - 30, y1, y1 - 40, y1 - 50, y1 - 60};
        GraphicsUtil.switchToWidth((Graphics)g, (int)2);
        g.drawPolygon(xp, yp, 7);
    }

    public void draw(ComponentDrawContext context) {
        MipsALU.drawALU(context.getGraphics(), this.getBounds());
        context.drawPin((Component)this, 0, "A", Direction.EAST);
        context.drawPin((Component)this, 1, "B", Direction.EAST);
        context.drawPin((Component)this, 2, "OP", Direction.SOUTH);
        context.drawPin((Component)this, 3, "SA", Direction.SOUTH);
        context.drawPin((Component)this, 4, "O", Direction.WEST);
    }
}

