/*
 * Decompiled with CFR 0.152.
 */
package cs316;

import java.util.Arrays;

class MemContentsSub {
    private MemContentsSub() {
    }

    static ContentsInterface createContents(int size, int bits) {
        if (bits <= 8) {
            return new ByteContents(size);
        }
        if (bits <= 16) {
            return new ShortContents(size);
        }
        return new IntContents(size);
    }

    private static class ByteContents
    extends ContentsInterface {
        private byte[] data;

        public ByteContents(int size) {
            this.data = new byte[size];
        }

        public Object clone() {
            ByteContents ret = (ByteContents)super.clone();
            ret.data = new byte[this.data.length];
            System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
            return ret;
        }

        int getLength() {
            return this.data.length;
        }

        int get(int addr) {
            return addr >= 0 && addr < this.data.length ? this.data[addr] : 0;
        }

        void set(int addr, int value) {
            byte oldValue;
            if (addr >= 0 && addr < this.data.length && value != (oldValue = this.data[addr])) {
                this.data[addr] = (byte)value;
            }
        }

        void clear() {
            Arrays.fill(this.data, (byte)0);
        }

        void load(int start, int[] values, int mask) {
            int n = Math.min(values.length, this.data.length - start);
            int i = 0;
            while (i < n) {
                this.data[start + i] = (byte)(values[i] & mask);
                ++i;
            }
        }
    }

    static abstract class ContentsInterface
    implements Cloneable {
        ContentsInterface() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return this;
            }
        }

        abstract int getLength();

        abstract int get(int var1);

        abstract void set(int var1, int var2);

        abstract void clear();

        abstract void load(int var1, int[] var2, int var3);

        boolean matches(int[] values, int start, int mask) {
            int i = 0;
            while (i < values.length) {
                if (this.get(start + i) != (values[i] & mask)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        int[] get(int start, int len) {
            int[] ret = new int[len];
            int i = 0;
            while (i < ret.length) {
                ret[i] = this.get(start + i);
                ++i;
            }
            return ret;
        }

        boolean isClear() {
            int i = 0;
            int n = this.getLength();
            while (i < n) {
                if (this.get(i) != 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class IntContents
    extends ContentsInterface {
        private int[] data;

        public IntContents(int size) {
            this.data = new int[size];
        }

        public Object clone() {
            IntContents ret = (IntContents)super.clone();
            ret.data = new int[this.data.length];
            System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
            return ret;
        }

        int getLength() {
            return this.data.length;
        }

        int get(int addr) {
            return addr >= 0 && addr < this.data.length ? this.data[addr] : 0;
        }

        void set(int addr, int value) {
            int oldValue;
            if (addr >= 0 && addr < this.data.length && value != (oldValue = this.data[addr])) {
                this.data[addr] = value;
            }
        }

        void clear() {
            Arrays.fill(this.data, 0);
        }

        void load(int start, int[] values, int mask) {
            int n = Math.min(values.length, this.data.length - start);
            int i = 0;
            while (i < n) {
                this.data[i] = values[i] & mask;
                ++i;
            }
        }
    }

    private static class ShortContents
    extends ContentsInterface {
        private short[] data;

        public ShortContents(int size) {
            this.data = new short[size];
        }

        public Object clone() {
            ShortContents ret = (ShortContents)super.clone();
            ret.data = new short[this.data.length];
            System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
            return ret;
        }

        int getLength() {
            return this.data.length;
        }

        int get(int addr) {
            return addr >= 0 && addr < this.data.length ? this.data[addr] : 0;
        }

        void set(int addr, int value) {
            short oldValue;
            if (addr >= 0 && addr < this.data.length && value != (oldValue = this.data[addr])) {
                this.data[addr] = (short)value;
            }
        }

        void clear() {
            Arrays.fill(this.data, (short)0);
        }

        void load(int start, int[] values, int mask) {
            int n = Math.min(values.length, this.data.length - start);
            int i = 0;
            while (i < n) {
                this.data[start + i] = (short)(values[i] & mask);
                ++i;
            }
        }
    }
}

