/*
 * Decompiled with CFR 0.152.
 */
package cs316;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.tools.Pokable;
import com.cburch.logisim.tools.ToolTipMaker;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import cs316.MemMenu;
import cs316.MemState;
import cs316.Strings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JPopupMenu;

abstract class Mem
extends ManagedComponent
implements AttributeListener,
Pokable,
MenuExtender,
ToolTipMaker {
    public static final Attribute ADDR_ATTR = Attributes.forBitWidth((String)"addrWidth", (StringGetter)Strings.getter("ramAddrWidthAttr"), (int)2, (int)24);
    public static final Attribute DATA_ATTR = Attributes.forBitWidth((String)"dataWidth", (StringGetter)Strings.getter("ramDataWidthAttr"));
    static final Bounds OFFSET_BOUNDS = Bounds.create((int)-140, (int)-40, (int)140, (int)80);
    static final int DATA = 0;
    static final int ADDR = 1;
    static final int CS = 2;
    static final int DELAY = 10;
    private File currentImageFile = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    Mem(Location loc, AttributeSet attrs, int numInputs) {
        super(loc, attrs, numInputs);
        attrs.addAttributeListener((AttributeListener)this);
        this.setPins();
    }

    void setPins() {
        Location loc = this.getLocation();
        BitWidth addrBits = (BitWidth)this.getAttributeSet().getValue(ADDR_ATTR);
        BitWidth dataBits = (BitWidth)this.getAttributeSet().getValue(DATA_ATTR);
        this.setEnd(0, loc, dataBits, 3);
        this.setEnd(1, loc.translate(-140, 0), addrBits, 1);
        this.setEnd(2, loc.translate(-90, 40), BitWidth.ONE, 1);
    }

    public abstract ComponentFactory getFactory();

    public abstract void propagate(CircuitState var1);

    public void attributeListChanged(AttributeEvent e) {
    }

    public void attributeValueChanged(AttributeEvent e) {
        Attribute attr = e.getAttribute();
        if (attr == ADDR_ATTR || attr == DATA_ATTR) {
            this.setPins();
        }
    }

    public void draw(ComponentDrawContext context) {
        Graphics g = context.getGraphics();
        Bounds bds = this.getBounds();
        context.drawBounds((Component)this);
        if (context.getShowState()) {
            MemState state = this.getState(context.getCircuitState());
            state.paint(context.getGraphics(), bds.getX(), bds.getY());
        } else {
            BitWidth addr = (BitWidth)this.getAttributeSet().getValue(ADDR_ATTR);
            int addrBits = addr.getWidth();
            int bytes = 1 << addrBits;
            String label = addrBits >= 30 ? StringUtil.format((String)Strings.get("ramGigabyteLabel"), (String)("" + (bytes >>> 30))) : (addrBits >= 20 ? StringUtil.format((String)Strings.get("ramMegabyteLabel"), (String)("" + (bytes >> 20))) : (addrBits >= 10 ? StringUtil.format((String)Strings.get("ramKilobyteLabel"), (String)("" + (bytes >> 10))) : StringUtil.format((String)Strings.get("ramByteLabel"), (String)("" + bytes))));
            GraphicsUtil.drawCenteredText((Graphics)g, (String)label, (int)(bds.getX() + bds.getWidth() / 2), (int)(bds.getY() + bds.getHeight() / 2));
        }
        context.drawPin((Component)this, 0, Strings.get("ramDataLabel"), Direction.WEST);
        context.drawPin((Component)this, 1, Strings.get("ramAddrLabel"), Direction.EAST);
        g.setColor(Color.GRAY);
        context.drawPin((Component)this, 2, Strings.get("ramCSLabel"), Direction.SOUTH);
    }

    public Object getFeature(Object key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.cburch.logisim.tools.Pokable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.cburch.logisim.tools.MenuExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return this;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.cburch.logisim.tools.ToolTipMaker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz3) {
            return this;
        }
        return super.getFeature(key);
    }

    public Caret getPokeCaret(ComponentUserEvent event) {
        Bounds bds = this.getBounds();
        CircuitState circState = event.getCircuitState();
        MemState state = this.getState(circState);
        long addr = state.getAddressAt(event.getX() - bds.getX(), event.getY() - bds.getY());
        if (addr < 0L) {
            return new AddrCaret(state, circState);
        }
        state.setCursor(addr);
        return new PokeCaret(state, circState);
    }

    public void configureMenu(JPopupMenu menu, Project proj) {
        menu.addSeparator();
        MemMenu compMenu = new MemMenu(proj, this);
        compMenu.appendTo(menu);
    }

    public abstract String getToolTip(ComponentUserEvent var1);

    File getCurrentImage() {
        return this.currentImageFile;
    }

    void setCurrentImage(File value) {
        this.currentImageFile = value;
    }

    abstract MemState getState(CircuitState var1);

    abstract HexFrame getHexFrame(Project var1, CircuitState var2);

    private class AddrCaret
    extends AbstractCaret {
        CircuitState circState;
        MemState state;

        AddrCaret(MemState state, CircuitState circState) {
            this.state = state;
            this.circState = circState;
            this.setBounds(state.getBounds(-1L, Mem.this.getBounds()));
        }

        public void draw(Graphics g) {
            Bounds bds = this.getBounds(g);
            g.setColor(Color.RED);
            g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            g.setColor(Color.BLACK);
        }

        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            int val = Character.digit(e.getKeyChar(), 16);
            if (val >= 0) {
                long newScroll = this.state.getScroll() * 16L + (long)val & this.state.getLastAddress();
                this.state.setScroll(newScroll);
            } else if (c == ' ') {
                this.state.setScroll(this.state.getScroll() + (long)((this.state.getRows() - 1) * this.state.getColumns()));
            } else if (c == '\r' || c == '\n') {
                this.state.setScroll(this.state.getScroll() + (long)this.state.getColumns());
            } else if (c == '\b' || c == '\u007f') {
                this.state.setScroll(this.state.getScroll() - (long)this.state.getColumns());
            }
        }
    }

    class MemListener
    implements HexModelListener {
        MemListener() {
        }

        public void metainfoChanged(HexModel source) {
        }

        public void bytesChanged(HexModel source, long start, long numBytes, int[] values) {
            Mem.this.fireComponentInvalidated(new ComponentEvent((Component)Mem.this));
        }
    }

    private class PokeCaret
    extends AbstractCaret {
        CircuitState circState;
        MemState state;
        int initValue;
        int curValue;

        PokeCaret(MemState state, CircuitState circState) {
            this.state = state;
            this.circState = circState;
            this.computeBounds();
            this.curValue = this.initValue = state.getContents().get(state.getCursor());
        }

        private void computeBounds() {
            this.setBounds(this.state.getBounds(this.state.getCursor(), Mem.this.getBounds()));
        }

        public void draw(Graphics g) {
            Bounds bds = this.getBounds(g);
            g.setColor(Color.RED);
            g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            g.setColor(Color.BLACK);
        }

        public void stopEditing() {
            this.state.setCursor(-1L);
        }

        public void cancelEditing() {
            this.state.getContents().set(this.state.getCursor(), this.initValue);
            this.state.setCursor(-1L);
        }

        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            int val = Character.digit(e.getKeyChar(), 16);
            if (val >= 0) {
                this.curValue = this.curValue * 16 + val;
                this.state.getContents().set(this.state.getCursor(), this.curValue);
                Mem.this.propagate(this.circState);
            } else if (c == ' ' || c == '\t') {
                this.moveTo(this.state.getCursor() + 1L);
            } else if (c == '\r' || c == '\n') {
                this.moveTo(this.state.getCursor() + (long)this.state.getColumns());
            } else if (c == '\b' || c == '\u007f') {
                this.moveTo(this.state.getCursor() - 1L);
            }
        }

        private void moveTo(long addr) {
            if (this.state.isValidAddr(addr)) {
                this.state.setCursor(addr);
                this.state.scrollToShow(addr);
                this.curValue = this.initValue = this.state.getContents().get(addr);
                this.computeBounds();
            }
        }
    }
}

