/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.incr;

import com.cburch.incr.CounterState;
import com.cburch.incr.SimpleCounterFactory;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Graphics;

class SimpleCounter
extends ManagedComponent {
    private static final BitWidth BIT_WIDTH = BitWidth.create((int)8);

    SimpleCounter(Location loc, AttributeSet attrs) {
        super(loc, attrs, 2);
        this.setEnd(0, loc.translate(-30, 0), BitWidth.ONE, 1);
        this.setEnd(1, loc, BIT_WIDTH, 2);
    }

    public ComponentFactory getFactory() {
        return SimpleCounterFactory.instance;
    }

    public void propagate(CircuitState circuitState) {
        CounterState state = this.getCounterState(circuitState);
        Value clk = circuitState.getValue(this.getEndLocation(0));
        if (state.getLastClock() == null || state.getLastClock() == Value.FALSE && clk == Value.TRUE) {
            Value newValue = Value.createKnown((BitWidth)BIT_WIDTH, (int)(state.getValue().toIntValue() + 1));
            circuitState.setValue(this.getEndLocation(1), newValue, (Component)this, 9);
            state.setValue(newValue);
        }
        state.setLastClock(clk);
    }

    public void draw(ComponentDrawContext context) {
        context.drawRectangle((Component)this);
        context.drawClock((Component)this, 0, Direction.EAST);
        context.drawPin((Component)this, 1);
        if (context.getShowState()) {
            CounterState state = this.getCounterState(context.getCircuitState());
            Bounds bds = this.getBounds();
            GraphicsUtil.drawCenteredText((Graphics)context.getGraphics(), (String)StringUtil.toHexString((int)BIT_WIDTH.getWidth(), (int)state.getValue().toIntValue()), (int)(bds.getX() + bds.getWidth() / 2), (int)(bds.getY() + bds.getHeight() / 2));
        }
    }

    protected CounterState getCounterState(CircuitState circuitState) {
        CounterState state = (CounterState)circuitState.getData((Component)this);
        if (state == null) {
            state = new CounterState(null, Value.createKnown((BitWidth)BIT_WIDTH, (int)-1));
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }
}

