/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.incr;

import com.cburch.incr.CounterState;
import com.cburch.incr.SimpleCounter;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.tools.AbstractCaret;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.Pokable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;

class Counter
extends SimpleCounter {
    public static final ComponentFactory factory = new Factory();
    static final Attribute WIDTH_ATTRIBUTE = Attributes.forBitWidth((String)"Bit Width", (int)1, (int)12);
    static final BitWidth WIDTH_DEFAULT = BitWidth.create((int)8);
    private MyListener myListener = new MyListener();
    static /* synthetic */ Class class$0;

    private Counter(Location loc, AttributeSet attrs) {
        super(loc, attrs);
        attrs.addAttributeListener((AttributeListener)this.myListener);
        this.computeEnds();
    }

    private void computeEnds() {
        Location loc = this.getLocation();
        BitWidth width = (BitWidth)this.getAttributeSet().getValue(WIDTH_ATTRIBUTE);
        this.setEnd(0, loc.translate(-30, 0), BitWidth.ONE, 1);
        this.setEnd(1, loc, width, 2);
    }

    public Object getFeature(Object key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.cburch.logisim.tools.Pokable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this.myListener;
        }
        return super.getFeature(key);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    /* synthetic */ Counter(Location location, AttributeSet attributeSet, Counter counter) {
        this(location, attributeSet);
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "Counter";
        }

        public String getDisplayName() {
            return "Counter";
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new Counter(loc, attrs, null);
        }

        public Bounds getOffsetBounds(AttributeSet arg0) {
            return Bounds.create((int)-30, (int)-15, (int)30, (int)30);
        }

        public AttributeSet createAttributeSet() {
            return AttributeSets.fixedSet((Attribute)WIDTH_ATTRIBUTE, (Object)WIDTH_DEFAULT);
        }
    }

    private class MyListener
    implements AttributeListener,
    Pokable {
        private MyListener() {
        }

        public void attributeListChanged(AttributeEvent e) {
        }

        public void attributeValueChanged(AttributeEvent e) {
            if (e.getAttribute() == WIDTH_ATTRIBUTE) {
                Counter.this.computeEnds();
            }
        }

        public Caret getPokeCaret(ComponentUserEvent event) {
            return new PokeCaret(event.getCircuitState());
        }
    }

    private class PokeCaret
    extends AbstractCaret {
        CircuitState circuitState;
        Value initValue;

        PokeCaret(CircuitState circuitState) {
            this.circuitState = circuitState;
            CounterState initial = Counter.this.getCounterState(circuitState);
            this.initValue = initial.getValue();
            this.setBounds(Counter.this.getBounds());
        }

        public void draw(Graphics g) {
            Bounds bds = Counter.this.getBounds();
            BitWidth width = (BitWidth)Counter.this.getAttributeSet().getValue(WIDTH_ATTRIBUTE);
            int len = (width.getWidth() + 3) / 4;
            g.setColor(Color.RED);
            int wid = 7 * len + 2;
            int ht = 16;
            g.drawRect(bds.getX() + (bds.getWidth() - wid) / 2, bds.getY() + (bds.getHeight() - ht) / 2, wid, ht);
            g.setColor(Color.BLACK);
        }

        public void keyTyped(KeyEvent e) {
            int val = Character.digit(e.getKeyChar(), 16);
            if (val < 0) {
                return;
            }
            BitWidth width = (BitWidth)Counter.this.getAttributeSet().getValue(WIDTH_ATTRIBUTE);
            CounterState state = Counter.this.getCounterState(this.circuitState);
            Value newValue = Value.createKnown((BitWidth)width, (int)(state.getValue().toIntValue() * 16 + val & width.getMask()));
            state.setValue(newValue);
            this.circuitState.setValue(Counter.this.getEndLocation(1), newValue, (Component)Counter.this, 1);
        }

        public void stopEditing() {
        }

        public void cancelEditing() {
            Counter.this.getCounterState(this.circuitState).setValue(this.initValue);
        }
    }
}

