#include <stdio.h>
#include <stdlib.h>
#include "main.h"

/* Return the 4-byte value of memory at the address specified as an
 * argument.  The _mem_read_word function will perform the reading for
 * you from the simulated memory; add code to manage your statistics.
 */
unsigned int mem_read_word(unsigned int addr) {
  cache_read(addr);
  return _mem_read_word(addr);
}

/* Return the 2-byte value of memory at the address specified as an
 * argument.  The _mem_read_half function will perform the reading for
 * you from the simulated memory; add code to manage your statistics.
 */
unsigned short mem_read_half(unsigned int addr) {
  cache_read(addr);
  return _mem_read_half(addr);
}

/* Return the 1-byte value of memory at the address specified as an
 * argument.  The _mem_read_byte function will perform the reading for
 * you from the simulated memory; add code to manage your statistics.
 */
unsigned char mem_read_byte(unsigned int addr) {
  cache_read(addr);
  return _mem_read_byte(addr);
}

/* Write the given 4-byte value to the address specified by the first
 * argument.  The _mem_write_word function will perform the writing for
 * you to the simulated memory (remember the write-through cache policy);
 * add code to manage your statistics.
 */
void mem_write_word(unsigned int addr, unsigned int value) {
  cache_write(addr);
  _mem_write_word(addr, value);
}

/* Write the given 2-byte value to the address specified by the first
 * argument.  The _mem_write_half function will perform the writing for
 * you to the simulated memory (remember the write-through cache policy);
 * add code to manage your statistics.
 */
void mem_write_half(unsigned int addr, unsigned short value) {
  cache_write(addr);
  _mem_write_half(addr, value);
}

/* Write the given 1-byte value to the address specified by the first
 * argument.  The _mem_write_byte function will perform the writing for
 * you to the simulated memory (remember the write-through cache policy);
 * add code to manage your statistics.
 */
void mem_write_byte(unsigned int addr, unsigned char value) {
  cache_write(addr);
  _mem_write_byte(addr, value);
}
