#ifndef MAIN_H
#define MAIN_H

//#define READELF_DEBUG

#define TRUE 1
#define FALSE 0

// Globals (declared in main.c)
extern int opt_disassemble;
extern int opt_printstack;
extern int opt_dumpreg;
void dump_cache();

// Prototypes for readelf.c
unsigned short gethalf(void *q);
unsigned int getfull(void *q);
void readelf(char* filename);

// Memory region structure
struct mem_region {
  unsigned int addr;
  unsigned int size;
  void * ptr;
};
#define MAX_MEM_REGIONS 16

// Machine state and registers
extern unsigned int R[32]; /* CPU registers */
extern unsigned int CpCond[4], CCR[4][32], CPR[4][32];
extern float FGR[16];      /* FPU registers */
extern double *FPR;
extern int *FWR;

// Globals in mem.c
extern struct mem_region * memory_region[];
extern unsigned int entry_point;
extern unsigned int stack_start;

// Functions in cache.c
void initialize_cache(unsigned int associativity, unsigned int size, unsigned int blocksize);
void free_cache(void);
int probe_cache(unsigned int set, unsigned int age);
void cache_read(unsigned int addr);
void cache_write(unsigned int addr);
unsigned int cache_hits();
unsigned int cache_misses();
unsigned int cache_reads();
unsigned int cache_writes();
float cache_read_hit_rate();

// Functions in memcache.c
unsigned int mem_read_word(unsigned int addr);
unsigned short mem_read_half(unsigned int addr);
unsigned char mem_read_byte(unsigned int addr);
void mem_write_word(unsigned int addr, unsigned int value);
void mem_write_half(unsigned int addr, unsigned short value);
void mem_write_byte(unsigned int addr, unsigned char value);

// Functions in mem.c
void* sim_to_real_addr(unsigned int addr);
unsigned int _mem_read_word(unsigned int addr);
unsigned short _mem_read_half(unsigned int addr);
unsigned char _mem_read_byte(unsigned int addr);
void _mem_write_word(unsigned int addr, unsigned int value);
void _mem_write_half(unsigned int addr, unsigned short value);
void _mem_write_byte(unsigned int addr, unsigned char value);
void debug_print_regions(void);
void initialize_memory(void);
void create_stack(void);
void print_registers(void);
void print_stack(void);

// Functions in syscalls.c
void dosyscall(void);

// Enumerations for registers
enum {
  REG_0,  REG_AT, REG_V0, REG_V1, REG_A0, REG_A1, REG_A2, REG_A3,
  REG_T0, REG_T1, REG_T2, REG_T3, REG_T4, REG_T5, REG_T6, REG_T7,
  REG_S0, REG_S1, REG_S2, REG_S3, REG_S4, REG_S5, REG_S6, REG_S7,
  REG_T8, REG_T9, REG_K0, REG_K1, REG_GP, REG_SP, REG_S8, REG_RA
};

#define STACK_SIZE (1024*1024*4)

// Prototype for run.c
void run(void);

// Prototype for print.c
void print(unsigned int* text, int num_instructions, unsigned int start_addr);

#endif
