using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace WebServiceDemos
{
	/// <summary>
	/// Summary description for RepeaterDemo.
	/// </summary>
	public class RepeaterDemo : System.Web.UI.Page
	{
		protected Repeater MyRepeater;
		protected Label Message;

		private void Page_Load(object sender, System.EventArgs e)
		{
			Trace.Write("Page_Load");
			
			if (!this.IsPostBack)
			{
				string[] items = {"alpha", "beta", "gamma"};
				MyRepeater.DataSource= items;
				MyRepeater.DataBind();
			}
		}

		protected void DoItemDataBound(object sender, RepeaterItemEventArgs e)
		{
			Trace.Write("DoItemDataBound");
			RepeaterItem item = e.Item;
			DropDownList l = (DropDownList) item.FindControl("MyDropDownList");
			
			int[] indices = {1,2,3,4,5};
			l.DataSource = indices;
			l.DataBind();
		}

		protected void DoItemChangedEvent(object sender, EventArgs e)
		{
			Trace.Write("DoItemChangedEvent");

			// the sender could be the CheckBox or the DropDownList,
			// but either way, the NamingContainer is the RepeaterItem
			RepeaterItem item = (RepeaterItem) ((Control) sender).NamingContainer;

			Label l = (Label) item.FindControl("ItemName");
			CheckBox cb = (CheckBox) item.FindControl("MyCheckBox");
			DropDownList ddl = (DropDownList) item.FindControl("MyDropDownList");

			Message.Text = "Item " + l.Text + " changed! " +
				(cb.Checked ? "checked," : "not checked,") +
				" index " + ddl.SelectedIndex.ToString() + " selected";
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
