using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using GoogleService;

namespace WebServiceDemos
{
	/// <summary>
	/// Summary description for GoogleResults.
	/// </summary>
	public class GoogleResults : System.Web.UI.Page
	{
		protected Label BannerLabel;
		protected Repeater ResultsRepeater;

		private static string MyGoogleKey = "ve4QJSFQFHKThGoiisKzAlDZk85hTsWE";
		
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Prepare the proxy class:
			//    1) wsdl.exe /l:CS /n:GoogleService /out:GoogleService.cs GoogleSearch.wsdl
			//       (ignore warnings)
			//    2) Add GoogleSearch.cs to the project
			//    3) Add Reference: System.Web.Services
			//    4) Expose certain fields as propertes for use in Data Binding

			string product = Request.QueryString.Get("product");
			BannerLabel.Text = "Results for " + product;

			GoogleSearchService google = new GoogleSearchService();
			GoogleSearchResult result = 
				google.doGoogleSearch(MyGoogleKey, product, 0, 10, 
									  false, "", false, "", "", "");

			ResultsRepeater.DataSource = result.resultElements;
			ResultsRepeater.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
