using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace Lecture4Demos
{
	/// <summary>
	/// Summary description for Controls.
	/// </summary>
	public class Debug : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Label apples;
		protected System.Web.UI.WebControls.Label oranges;
		protected System.Web.UI.WebControls.Label broccoli;
		protected System.Web.UI.WebControls.Panel Fruit;
		protected System.Web.UI.WebControls.Label carrots;
		protected System.Web.UI.WebControls.Panel Vegetables;
		protected System.Web.UI.WebControls.Button Button1;
		protected System.Web.UI.WebControls.Button Button2;
		protected Label Message;

		private void Page_Load(object sender, System.EventArgs e)
		{
			this.Trace.Write("Here I am in Page Load!");
		}

		protected void DoFixBroccoli(object sender, EventArgs e)
		{
			Control Broccoli = this.FindControl("Broccoli");

			if (Broccoli.Parent.ID == "Fruit")
			{
				// remove Broccoli from Fruit
				Broccoli.Parent.Controls.Remove(Broccoli);
				
				// add it to the veggies panel
				Panel Veggies = (Panel) this.FindControl("Vegetables");
				Veggies.Controls.Add(Broccoli);

				// leave a note...
				Label note = new Label();
				note.Text = "Not Broccoli!";
				this.FindControl("Fruit").Controls.Add(note);
			}
		}

		protected void DoSeeControlTree(object sender, EventArgs e)
		{
			Message.Text = "";
			WalkControlTree(this, 0);
		}

		public void WalkControlTree(Control c, int indent)
		{
			Message.Text += new String(' ', indent);
			Message.Text += "ID=" + c.UniqueID + ", ";
			Message.Text += "Type=" + c.GetType().Name + "\n";

			if (c.HasControls())
			{
				foreach (Control child in c.Controls)
				{
					WalkControlTree(child, indent + 2);
				}
			}
		}
		
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
