using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

namespace Lecture4Demos
{
	/// <summary>
	/// Summary description for DataBind.
	/// </summary>
	public class DataBind : System.Web.UI.Page
	{
		protected Label MyLabel;
		protected DropDownList MyDropDownList;
		protected Repeater MyRepeater;
		protected DataGrid MySimpleDataGrid;
		protected DataGrid MyCustomDataGrid;

		// the data source
		protected string lotteryNumber;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// *************************************************
			// Simple DataBind
			Random r = new Random();
			lotteryNumber = r.Next(200).ToString();
			this.DataBind();    // you must trigger the DataBind event

			// *************************************************
			// DropDownList
			string [] A = {"one", "two", "three", "four"};
			MyDropDownList.DataSource = A;
			MyDropDownList.DataBind();

			// *************************************************
			// Repeater
			Hashtable t = new Hashtable();
			t["one"] = 1;
			t["two"] = 2;
			MyRepeater.DataSource = t;
			MyRepeater.DataBind();

			// *************************************************
			// Simple/Custom DataGrid

			// get Fobs data for Data source
			SqlConnection myConnection = 
				new SqlConnection("Data Source=localhost;" +
				"Integrated Security=SSPI;" +
				"Initial Catalog=fobs");
			myConnection.Open();
					
			SqlCommand myCommand = 
				new SqlCommand("SELECT pid, name,price FROM products", myConnection);

			SqlDataReader myReader = myCommand.ExecuteReader();
			
			MySimpleDataGrid.DataSource = myReader;
			MySimpleDataGrid.DataBind();

			MyCustomDataGrid.DataSource = myReader;
			MyCustomDataGrid.DataBind();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
