using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Data.SqlClient;

namespace FobsUnlimited
{
	/// <summary>
	/// Summary description for shop.
	/// </summary>
	public class shop : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DataGrid MyDataGrid;
		public Label    InfoLabel;
		protected System.Web.UI.WebControls.Repeater CartRepeater;
		protected System.Web.UI.WebControls.Label CartTotalLabel;
		protected System.Web.UI.WebControls.Button Button1;

		public ShoppingCart Cart;

		private void Page_Load(object sender, System.EventArgs e)
		{	
			Cart = (ShoppingCart) Session["ShoppingCart"];
			
			// query the DB for product data
			SqlConnection myConnection = 
				new SqlConnection("Data Source=localhost;" +
				"Integrated Security=SSPI;" +
				"Initial Catalog=fobs");
			myConnection.Open();
					
			SqlCommand myCommand = 
				new SqlCommand("SELECT pid, name,price FROM products", myConnection);

			SqlDataReader myReader = myCommand.ExecuteReader();
			
			MyDataGrid.DataSource = myReader;
			MyDataGrid.DataBind();

			myConnection.Close();

			UpdateCart();
		}

		public void UpdateCart()
		{
			CartRepeater.DataSource = Cart.Values;
			CartRepeater.DataBind();
			CartTotalLabel.Text = Cart.Total.ToString();
		}
	
		public void ClearCart(Object sender, EventArgs e)
		{
			Cart.Clear();
			UpdateCart();
		}

		public void AddToCart(Object sender, DataGridCommandEventArgs e) 
		{
			// the info about this event is contained in the event args e
			
			// specifically, e.Item is the DataGridItem, i.e., the row
			// that triggered te event
			
			TableCell productCell = e.Item.Cells[0];
			TableCell priceCell = e.Item.Cells[1];

			string product = productCell.Text;
			int price = Convert.ToInt32(priceCell.Text);

			Cart.Add(product, price);
			UpdateCart();
		}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
