using System;
using System.Collections;

namespace FobsUnlimited
{
	public class CartItem
	{
		private int quantity;
		private int unitPrice;
		private string productName;

		public CartItem(string name, int price)
		{
			productName = name;
			quantity = 1;
			unitPrice = price;
		}

		public string ProductName 
		{
			get { return productName; }
		}

		public int Quantity 
		{
			get { return quantity; }
		}

		public int SubTotal
		{
			get { return quantity * unitPrice; }
		}

		public void Increment()
		{
			quantity++;
		}
	}

	public class ShoppingCart 
	{
		private Hashtable cart = new Hashtable();

		public void Add(string product, int price)
		{
			if (! cart.Contains(product)) 
				cart.Add(product, new CartItem(product, price));
			else
				((CartItem) cart[product]).Increment();
		}

		public void Clear()
		{
			cart.Clear();
		}

		public ICollection Values
		{
			get { return cart.Values; }
		}

		public int Total
		{	
			get	
			{
				int total = 0;
				IEnumerator items = cart.Values.GetEnumerator();
				while (items.MoveNext())
				{
					total += ((CartItem) items.Current).SubTotal;
				}
				return total;
			}	
		}	
	}
}
