clear  
close all
clc


%% Also an image example...
I = imread('EmpireState.jpg'); %Photo credit: Unsplash
I = double(I(:,:,1));



imagesc(I); colormap gray; axis square; axis off;
title('Original','FontSize',36)
%% Compress image
tic; [Ui, Si, Vi] = svd(I); toc

%%
k = 1;
I2 = Ui(:,1:k)*Si(1:k,1:k)*Vi(:,1:k)';

figure;
imagesc(I2); colormap gray; axis square; axis off;
title('Compressed','FontSize',36)



%% Generate some data points...
rng(3220)
d = 2;
n = 1000;

% set up a random rotation and use a covariance that is not I
Q = orth(randn(d,d));
S = diag([1 10]);
C = Q*S*Q';

% generate random data points
A = mvnrnd(zeros(n,d),C)' + 10*[1 0; 0 -1]*ones(d,n);

% center the data points
A = A - diag(mean(A,2))*ones(d,n);


%% plotting...
figure;
scatter(A(1,:),A(2,:))
hold on;
axis equal
set(gca,'FontSize',24)
axis([-20 20 -20 20])

%% Data analyis...

[U, S, V] = svd(A,'econ');

plot(max(diag(S))*[-1*U(1,1) U(1,1)],max(diag(S))*[-1*U(2,1) U(2,1)],'LineWidth',3)