%% demo for Gradient descent
clear
close all

% first, cook up some interesting functions

% f = @(x,y) ((cos(2*pi*y)+1).^2).*((cos(2*pi*x)+1).^2).*(x-y.^2).^2;
% g1 = @(x,y) (- 2*y^2 + 2*x)*(cos(2*pi*x) + 1)^2*(cos(2*pi*y) + 1)^2 - 4*pi*sin(2*pi*x)*(- y^2 + x)^2*(cos(2*pi*x) + 1)*(cos(2*pi*y) + 1)^2;
% g2 = @(x,y) - 4*y*(- y^2 + x)*(cos(2*pi*x) + 1)^2*(cos(2*pi*y) + 1)^2 - 4*pi*sin(2*pi*y)*(- y^2 + x)^2*(cos(2*pi*x) + 1)^2*(cos(2*pi*y) + 1);

% f = @(x,y) (x-y.^2).^2;
% g1 = @(x,y) - 2*y^2 + 2*x;
% g2 = @(x,y) -4*y*(- y^2 + x);


% f = @(x,y) .001*x.^2 + y.^2;
% g1 = @(x,y) .002*x;
% g2 = @(x,y) 2.*y;


f = @(x,y) ((cos(2*pi*y)).^2)+((cos(2*pi*x)).^2)+(x-y.^2).^2;
g1 = @(x,y) - 2*y^2 + 2*x - 4*pi*cos(2*x*pi)*sin(2*x*pi);
g2 = @(x,y) - 4*y*(- y^2 + x) - 4*pi*cos(2*pi*y)*sin(2*pi*y);


x = linspace(-1.5,1.5,500);
[X, Y] = meshgrid(x,x);
Z = f(X,Y);

contour(X,Y,Z,50)
hold on
%%
line_search = 1;
% gradient with no line search

if ~line_search
    xk = zeros(2,100);
    xk(:,1) = [-1; 1];
    step = .1;
    for k = 1:(size(xk,2)-1)
        gk = [g1(xk(1,k),xk(2,k)); g2(xk(1,k),xk(2,k))];
        pk = -1*gk;
        xk(:,k+1) = xk(:,k) + step*pk;
        plot(xk(1,k:k+1),xk(2,k:k+1),'-pk','LineWidth',3)
        pause
    end
else

% gradient with line search

    xk = zeros(2,100);
    xk(:,1) = [-1; .5];
    c1 = 1e-3;
    rho = .5;
    for k = 1:(size(xk,2)-1)
        gk = [g1(xk(1,k),xk(2,k)); g2(xk(1,k),xk(2,k))];
        pk = -1*gk;
        alpha = 1;
        for l = 1:100
            pt = xk(:,k) + alpha*pk;
            if f(pt(1),pt(2)) < f(xk(1,k),xk(2,k)) + c1*alpha*(gk'*pk)
                break;
            else
                alpha = alpha*rho;
            end
        end
        -1*gk
        alpha
        xk(:,k+1) = xk(:,k) + alpha*pk;
        plot(xk(1,k:k+1),xk(2,k:k+1),'-pk','LineWidth',3)
        pause
    end
end
