/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs316;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

class Video
extends ManagedComponent {
    public static final ComponentFactory factory = new Factory();
    static final BitWidth SEVEN = BitWidth.create((int)7);
    static final BitWidth BPP = BitWidth.create((int)16);
    static final int P_CLK = 0;
    static final int P_WE = 1;
    static final int P_X = 2;
    static final int P_Y = 3;
    static final int P_DATA = 4;
    static final int P_RST = 5;

    private Video(Location loc, AttributeSet attrs) {
        super(loc, attrs, 6);
        this.setEnd(0, this.getLocation().translate(-220, 130), BitWidth.ONE, 1);
        this.setEnd(1, this.getLocation().translate(-200, 130), BitWidth.ONE, 1);
        this.setEnd(2, this.getLocation().translate(-140, 130), SEVEN, 1);
        this.setEnd(3, this.getLocation().translate(-130, 130), SEVEN, 1);
        this.setEnd(4, this.getLocation().translate(-120, 130), BPP, 1);
        this.setEnd(5, this.getLocation().translate(-240, 130), BitWidth.ONE, 1);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    public void propagate(CircuitState circuitState) {
        Graphics g;
        State state = this.getState(circuitState);
        int x = this.addr(circuitState, 2);
        int y = this.addr(circuitState, 3);
        int color = this.addr(circuitState, 4);
        state.last_x = x;
        state.last_y = y;
        state.color = color;
        if (state.tick(this.val(circuitState, 0)) && this.val(circuitState, 1) == Value.TRUE) {
            g = state.img.getGraphics();
            g.setColor(new Color(state.img.getColorModel().getRGB(color)));
            g.fillRect(x * 2, y * 2, 2, 2);
        }
        if (this.val(circuitState, 5) == Value.TRUE) {
            g = state.img.getGraphics();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 256, 256);
        }
    }

    public void draw(ComponentDrawContext context) {
        Location loc = this.getLocation();
        int size = this.getBounds().getWidth();
        State s = this.getState(context.getCircuitState());
        this.drawVideo(context, loc.getX(), loc.getY(), s);
    }

    static void drawVideoIcon(ComponentDrawContext context, int x, int y) {
        Graphics g = context.getGraphics();
        g.setColor(Color.BLACK);
        g.drawRoundRect(x + 0, y + 0, 15, 15, 3, 3);
        g.setColor(Color.BLUE);
        g.fillRect(x + 3, y + 3, 10, 10);
        g.setColor(Color.BLACK);
    }

    boolean blink() {
        long now = System.currentTimeMillis();
        return now / 1000L % 2L == 0L;
    }

    void drawVideo(ComponentDrawContext context, int x, int y, State state) {
        Graphics g = context.getGraphics();
        g.drawRoundRect(x -= 270, y -= 140, 269, 269, 6, 6);
        for (int i = 1; i <= 5; ++i) {
            context.drawPin((Component)this, i);
        }
        g.drawRect(x + 6, y + 6, 257, 257);
        context.drawClock((Component)this, 0, Direction.NORTH);
        g.drawImage(state.img, x + 7, y + 7, null);
        if (this.blink()) {
            g.setColor(new Color(state.img.getColorModel().getRGB(state.color)));
            g.fillRect(x + 7 + state.last_x * 2, y + 7 + state.last_y * 2, 2, 2);
        }
    }

    private State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData((Component)this);
        if (state == null) {
            state = new State(new BufferedImage(256, 256, 9));
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    private class State
    implements ComponentState,
    Cloneable {
        public Value lastClock = null;
        public BufferedImage img;
        public int last_x;
        public int last_y;
        public int color;

        State(BufferedImage img) {
            this.img = img;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean tick(Value clk) {
            boolean rising = this.lastClock == null || this.lastClock == Value.FALSE && clk == Value.TRUE;
            this.lastClock = clk;
            return rising;
        }
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "LCD Video";
        }

        public String getDisplayName() {
            return "LCD Video";
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new Video(loc, attrs);
        }

        public Bounds getOffsetBounds(AttributeSet attrs) {
            return Bounds.create((int)-270, (int)-140, (int)270, (int)270);
        }

        public void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
            Video.drawVideoIcon(context, x, y);
        }
    }
}

