/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cs316;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import java.awt.Color;
import java.awt.Graphics;

class LCD
extends ManagedComponent {
    public static final ComponentFactory factory = new Factory();
    static final BitWidth FIVE = BitWidth.create((int)5);
    static final BitWidth EIGHT = BitWidth.create((int)8);
    static final int P_CLK = 0;
    static final int P_WE = 1;
    static final int P_A = 2;
    static final int P_D = 3;
    static final int P_RST = 4;

    private LCD(Location loc, AttributeSet attrs) {
        super(loc, attrs, 5);
        this.setEnd(0, this.getLocation().translate(-220, 10), BitWidth.ONE, 1);
        this.setEnd(1, this.getLocation().translate(-200, 10), BitWidth.ONE, 1);
        this.setEnd(2, this.getLocation().translate(-140, 10), FIVE, 1);
        this.setEnd(3, this.getLocation().translate(-120, 10), EIGHT, 1);
        this.setEnd(4, this.getLocation().translate(-240, 10), BitWidth.ONE, 1);
    }

    public ComponentFactory getFactory() {
        return factory;
    }

    Location loc(int pin) {
        return this.getEndLocation(pin);
    }

    Value val(CircuitState s, int pin) {
        return s.getValue(this.loc(pin));
    }

    int addr(CircuitState s, int pin) {
        return this.val(s, pin).toIntValue();
    }

    public void propagate(CircuitState circuitState) {
        State state = this.getState(circuitState);
        int a = this.addr(circuitState, 2);
        if (a >= 0) {
            state.last_a = a;
        }
        if (state.tick(this.val(circuitState, 0)) && this.val(circuitState, 1) == Value.TRUE) {
            int c = this.addr(circuitState, 3);
            state.c[a % state.c.length] = c >= 33 && c <= 127 ? (int)c : 32;
        }
        if (this.val(circuitState, 4) == Value.TRUE) {
            for (int i = 0; i < state.c.length; ++i) {
                state.c[i] = 32;
            }
        }
    }

    public void draw(ComponentDrawContext context) {
        Location loc = this.getLocation();
        int size = this.getBounds().getWidth();
        State s = this.getState(context.getCircuitState());
        this.drawLCD(context, loc.getX(), loc.getY(), s);
    }

    static void drawLCDIcon(ComponentDrawContext context, int x, int y) {
        Graphics g = context.getGraphics();
        g.setColor(Color.BLACK);
        g.drawRect(x + 0, y + 2, 15, 9);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(x + 3, y + 5, 10, 5);
        g.setColor(Color.BLACK);
    }

    void drawLCD(ComponentDrawContext context, int x, int y, State state) {
        String s;
        Graphics g = context.getGraphics();
        g.drawRect(x -= 330, y -= 20, 329, 29);
        context.drawClock((Component)this, 0, Direction.NORTH);
        for (int i = 1; i <= 4; ++i) {
            context.drawPin((Component)this, i);
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(x + 3, y + 2, 324, 22);
        g.setColor(Color.DARK_GRAY);
        g.drawRect(x + 5 + state.last_a * 10, y + 3, 10, 19);
        g.setColor(Color.BLACK);
        try {
            s = new String(state.c, "UTF-8");
        }
        catch (Exception e) {
            s = "ENCODING ERROR";
        }
        int n = state.c.length;
        if (n > s.length()) {
            n = s.length();
        }
        for (int i = 0; i < n; ++i) {
            g.drawString(s.substring(i, i + 1), x + 6 + i * 10, y + 18);
        }
    }

    private State getState(CircuitState circuitState) {
        State state = (State)circuitState.getData((Component)this);
        if (state == null) {
            state = new State(32);
            circuitState.setData((Component)this, (Object)state);
        }
        return state;
    }

    private class State
    implements ComponentState,
    Cloneable {
        public Value lastClock = null;
        public byte[] c;
        public int last_a;

        State(int len) {
            this.c = new byte[len];
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i] = 32;
            }
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean tick(Value clk) {
            boolean rising = this.lastClock == null || this.lastClock == Value.FALSE && clk == Value.TRUE;
            this.lastClock = clk;
            return rising;
        }
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
        }

        public String getName() {
            return "LCD Banner";
        }

        public String getDisplayName() {
            return "LCD Banner";
        }

        public Component createComponent(Location loc, AttributeSet attrs) {
            return new LCD(loc, attrs);
        }

        public Bounds getOffsetBounds(AttributeSet attrs) {
            return Bounds.create((int)-330, (int)-20, (int)330, (int)30);
        }

        public void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
            LCD.drawLCDIcon(context, x, y);
        }
    }
}

