/*
 * Decompiled with CFR 0.152.
 */
package cs316;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.comp.ComponentState;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import cs316.MemContents;
import java.awt.Color;
import java.awt.Graphics;

class MemState
implements ComponentState,
Cloneable,
HexModelListener {
    private static final int ROWS = 4;
    private static final int TABLE_WIDTH12 = 80;
    private static final int TABLE_WIDTH32 = 65;
    private static final int ENTRY_HEIGHT = 15;
    private static final int ENTRY_XOFFS12 = 40;
    private static final int ENTRY_XOFFS32 = 60;
    private static final int ENTRY_YOFFS = 5;
    private static final int ADDR_WIDTH_PER_CHAR = 10;
    private MemContents contents;
    private int columns;
    private long curScroll = 0L;
    private long cursorLoc = -1L;
    private long curAddr = -1L;

    MemState(MemContents contents) {
        this.contents = contents;
        this.setBits(contents.getLogLength(), contents.getWidth());
        contents.addHexModelListener(this);
    }

    public Object clone() {
        try {
            MemState ret = (MemState)super.clone();
            ret.contents = (MemContents)this.contents.clone();
            ret.contents.addHexModelListener(ret);
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void setBits(int addrBits, int dataBits) {
        long maxScroll;
        if (this.contents == null) {
            this.contents = MemContents.create(addrBits, dataBits);
        } else {
            this.contents.setDimensions(addrBits, dataBits);
        }
        this.columns = addrBits <= 12 ? (dataBits <= 8 ? (dataBits <= 4 ? 8 : 4) : (dataBits <= 16 ? 2 : 1)) : (dataBits <= 8 ? 2 : 1);
        long newLast = this.contents.getLastOffset();
        if (this.cursorLoc > newLast) {
            this.cursorLoc = newLast;
        }
        if (this.curAddr - newLast > 0L) {
            this.curAddr = -1L;
        }
        if (this.curScroll > (maxScroll = Math.max(0L, newLast + 1L - (long)(3 * this.columns)))) {
            this.curScroll = maxScroll;
        }
    }

    public MemContents getContents() {
        return this.contents;
    }

    int getAddrBits() {
        return this.contents.getLogLength();
    }

    int getDataBits() {
        return this.contents.getWidth();
    }

    long getLastAddress() {
        return (1L << this.contents.getLogLength()) - 1L;
    }

    boolean isValidAddr(long addr) {
        int addrBits = this.contents.getLogLength();
        return addr >>> addrBits == 0L;
    }

    int getRows() {
        return 4;
    }

    int getColumns() {
        return this.columns;
    }

    long getCursor() {
        return this.cursorLoc;
    }

    long getCurrent() {
        return this.curAddr;
    }

    long getScroll() {
        return this.curScroll;
    }

    void setCursor(long value) {
        this.cursorLoc = this.isValidAddr(value) ? value : -1L;
    }

    void setCurrent(long value) {
        this.curAddr = this.isValidAddr(value) ? value : -1L;
    }

    void scrollToShow(long addr) {
        if (this.isValidAddr(addr)) {
            long curTop = this.curScroll / (long)this.columns * (long)this.columns;
            if ((addr = addr / (long)this.columns * (long)this.columns) < curTop) {
                this.curScroll = addr;
            } else if (addr >= curTop + (long)(4 * this.columns)) {
                this.curScroll = addr - (long)(3 * this.columns);
                if (this.curScroll < 0L) {
                    this.curScroll = 0L;
                }
            }
        }
    }

    void setScroll(long addr) {
        long maxAddr = this.getLastAddress() - (long)(4 * this.columns);
        if (addr > maxAddr) {
            addr = maxAddr;
        }
        if (addr < 0L) {
            addr = 0L;
        }
        this.curScroll = addr;
    }

    public long getAddressAt(int x, int y) {
        int boxW;
        int addrBits = this.getAddrBits();
        int boxX = addrBits <= 12 ? 40 : 60;
        int n = boxW = addrBits <= 12 ? 80 : 65;
        if (x < boxX || x >= boxX + boxW || y <= 5 || y >= 65) {
            return -1L;
        }
        int row = (y - 5) / 15;
        int col = (x - boxX) / (boxW / this.columns);
        long ret = this.curScroll / (long)this.columns * (long)this.columns + (long)(this.columns * row) + (long)col;
        return this.isValidAddr(ret) ? ret : this.getLastAddress();
    }

    public Bounds getBounds(long addr, Bounds bds) {
        int boxW;
        int addrBits = this.getAddrBits();
        int boxX = bds.getX() + (addrBits <= 12 ? 40 : 60);
        int n = boxW = addrBits <= 12 ? 80 : 65;
        if (addr < 0L) {
            int addrLen = (this.contents.getWidth() + 3) / 4;
            int width = 10 * addrLen;
            return Bounds.create((int)(boxX - width), (int)(bds.getY() + 5), (int)width, (int)15);
        }
        int bdsX = this.addrToX(bds, addr);
        int bdsY = this.addrToY(bds, addr);
        return Bounds.create((int)bdsX, (int)bdsY, (int)(boxW / this.columns), (int)15);
    }

    public void paint(Graphics g, int leftX, int topY) {
        int addrBits = this.getAddrBits();
        int dataBits = this.contents.getWidth();
        int boxX = leftX + (addrBits <= 12 ? 40 : 60);
        int boxY = topY + 5;
        int boxW = addrBits <= 12 ? 80 : 65;
        int boxH = 60;
        GraphicsUtil.switchToWidth((Graphics)g, (int)1);
        g.drawRect(boxX, boxY, boxW, boxH);
        int entryWidth = boxW / this.columns;
        for (int row = 0; row < 4; ++row) {
            long addr = this.curScroll / (long)this.columns * (long)this.columns + (long)(this.columns * row);
            int x = boxX;
            int y = boxY + 15 * row;
            int yoffs = 12;
            if (this.isValidAddr(addr)) {
                g.setColor(Color.GRAY);
                GraphicsUtil.drawText((Graphics)g, (String)StringUtil.toHexString((int)this.getAddrBits(), (int)((int)addr)), (int)(x - 2), (int)(y + yoffs), (int)1, (int)1);
            }
            g.setColor(Color.BLACK);
            for (int col = 0; col < this.columns && this.isValidAddr(addr); ++col) {
                int val = this.contents.get(addr);
                if (addr == this.curAddr) {
                    g.fillRect(x, y, entryWidth, 15);
                    g.setColor(Color.WHITE);
                    GraphicsUtil.drawText((Graphics)g, (String)StringUtil.toHexString((int)dataBits, (int)val), (int)(x + entryWidth / 2), (int)(y + yoffs), (int)0, (int)1);
                    g.setColor(Color.BLACK);
                } else {
                    GraphicsUtil.drawText((Graphics)g, (String)StringUtil.toHexString((int)dataBits, (int)val), (int)(x + entryWidth / 2), (int)(y + yoffs), (int)0, (int)1);
                }
                ++addr;
                x += entryWidth;
            }
        }
    }

    private int addrToX(Bounds bds, long addr) {
        int addrBits = this.getAddrBits();
        int boxX = bds.getX() + (addrBits <= 12 ? 40 : 60);
        int boxW = addrBits <= 12 ? 80 : 65;
        long row = addr / (long)this.columns;
        long topRow = this.curScroll / (long)this.columns;
        if (row < topRow || row >= topRow + 4L) {
            return -1;
        }
        int col = (int)(addr - row * (long)this.columns);
        if (col < 0 || col >= this.columns) {
            return -1;
        }
        return boxX + boxW * col / this.columns;
    }

    private int addrToY(Bounds bds, long addr) {
        long row = addr / (long)this.columns;
        long topRow = this.curScroll / (long)this.columns;
        if (row < topRow || row >= topRow + 4L) {
            return -1;
        }
        return (int)((long)(bds.getY() + 5) + 15L * (row - topRow));
    }

    public void metainfoChanged(HexModel source) {
        this.setBits(this.contents.getLogLength(), this.contents.getWidth());
    }

    public void bytesChanged(HexModel source, long start, long numBytes, int[] oldValues) {
    }
}

