/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.incr;

import com.cburch.incr.IncrementerFactory;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;

class Incrementer
extends ManagedComponent {
    static final Attribute WIDTH_ATTRIBUTE = Attributes.forBitWidth((String)"Bit Width");
    static final BitWidth WIDTH_DEFAULT = BitWidth.create((int)8);
    private MyListener myListener = new MyListener();

    Incrementer(Location loc, AttributeSet attrs) {
        super(loc, attrs, 2);
        attrs.addAttributeListener((AttributeListener)this.myListener);
        this.computeEnds();
    }

    private void computeEnds() {
        Location loc = this.getLocation();
        BitWidth width = (BitWidth)this.getAttributeSet().getValue(WIDTH_ATTRIBUTE);
        this.setEnd(0, loc.translate(-30, 0), width, 1);
        this.setEnd(1, loc, width, 2);
    }

    public ComponentFactory getFactory() {
        return IncrementerFactory.instance;
    }

    public void propagate(CircuitState circuitState) {
        Value in = circuitState.getValue(this.getEndLocation(0));
        Value out = in.isFullyDefined() ? Value.createKnown((BitWidth)in.getBitWidth(), (int)(in.toIntValue() + 1)) : (in.isErrorValue() ? Value.createError((BitWidth)in.getBitWidth()) : Value.createUnknown((BitWidth)in.getBitWidth()));
        circuitState.setValue(this.getEndLocation(1), out, (Component)this, in.getBitWidth().getWidth() + 1);
    }

    public void draw(ComponentDrawContext context) {
        context.drawRectangle((Component)this, "+1");
        context.drawPins((Component)this);
    }

    private class MyListener
    implements AttributeListener {
        private MyListener() {
        }

        public void attributeListChanged(AttributeEvent e) {
        }

        public void attributeValueChanged(AttributeEvent e) {
            if (e.getAttribute() == WIDTH_ATTRIBUTE) {
                Incrementer.this.computeEnds();
            }
        }
    }
}

