/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.incr;

import com.cburch.incr.ByteIncrementerFactory;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ManagedComponent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;

class ByteIncrementer
extends ManagedComponent {
    private static final BitWidth BIT_WIDTH = BitWidth.create((int)8);

    ByteIncrementer(Location loc, AttributeSet attrs) {
        super(loc, attrs, 2);
        this.setEnd(0, loc.translate(-30, 0), BIT_WIDTH, 1);
        this.setEnd(1, loc, BIT_WIDTH, 2);
    }

    public ComponentFactory getFactory() {
        return ByteIncrementerFactory.instance;
    }

    public void propagate(CircuitState circuitState) {
        Value in = circuitState.getValue(this.getEndLocation(0));
        Value out = in.isFullyDefined() ? Value.createKnown((BitWidth)BIT_WIDTH, (int)(in.toIntValue() + 1)) : (in.isErrorValue() ? Value.createError((BitWidth)BIT_WIDTH) : Value.createUnknown((BitWidth)BIT_WIDTH));
        circuitState.setValue(this.getEndLocation(1), out, (Component)this, 9);
    }

    public void draw(ComponentDrawContext context) {
        context.drawRectangle((Component)this, "+1");
        context.drawPins((Component)this);
    }
}

