#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t need_value = PTHREAD_COND_INITIALIZER;
pthread_cond_t value_ready = PTHREAD_COND_INITIALIZER;

int have_value;
int value;

void* thread_body(void* args) {
  // Consumer.
  while (1) {
    pthread_mutex_lock(&mutex);

    if (!have_value) {
      // Signal producer that we're waiting for a value.
      pthread_cond_signal(&need_value);

      // Block until signalled by producer.
      pthread_cond_wait(&value_ready, &mutex);
    }
    printf("Consumed value %3d.\n", value);
    have_value = 0;

    pthread_mutex_unlock(&mutex);
  }
}

void main() {
  // Start consumer thread.
  pthread_t thread_id;
  pthread_create(&thread_id, NULL, thread_body, NULL);

  // Producer.
  int next_value = random() % 1000;
  while (1) {
    pthread_mutex_lock(&mutex);

    if (have_value) {
      // Signal consumer that a value is ready.
      pthread_cond_signal(&value_ready);

      // Block until signalled by consumer.
      pthread_cond_wait(&need_value, &mutex);
    }
    have_value = 1;
    value = next_value;
    next_value = random() % 1000;
    printf("Produced value %3d.\n", value);

    pthread_mutex_unlock(&mutex);
  }
}

