#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

int have_value;
int value;

void* thread_body(void* args) {
  // Consumer.
  while (1) {
    pthread_mutex_lock(&mutex);
    if (have_value) {
      printf("Consumed value %3d.\n", value);
      have_value = 0;
    }
    pthread_mutex_unlock(&mutex);
  }
}

void main() {
  // Start consumer thread.
  pthread_t thread_id;
  pthread_create(&thread_id, NULL, thread_body, NULL);

  // Producer.
  int next_value = random() % 1000;
  while (1) {
    pthread_mutex_lock(&mutex);
    if (!have_value) {
      have_value = 1;
      value = next_value;
      next_value = random() % 1000;
      printf("Produced value %3d.\n", value);
    }
    pthread_mutex_unlock(&mutex);
  }
}

