#include <pthread.h>
#include <sched.h>
#include <stdlib.h>
#include <stdio.h>

int have_value;
int value;

void* thread_body(void* args) {
  // Consumer.
  while (1) {
    if (have_value) {
      have_value = 0;
      sched_yield();
      printf("Consumed value %3d.\n", value);
    }
  }
}

void main() {
  // Start consumer thread.
  pthread_t thread_id;
  pthread_create(&thread_id, NULL, thread_body, NULL);

  have_value = 0;

  // Producer.
  int next_value = random() % 1000;
  while (1) {
    if (!have_value) {
      have_value = 1;
      value = next_value;
      next_value = random() % 1000;
      printf("Produced value %3d.\n", value);
    }
  }
}

