/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2.layout;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.layout.Layout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GridLayout
extends Layout {
    protected Map<String, Entry> entries = new HashMap<String, Entry>();
    protected int gWidth;
    protected int gHeight;

    public GridLayout() {
        this.gWidth = 1;
        this.gHeight = 1;
    }

    public GridLayout(JsonValue data) {
        this.gWidth = data.getInt("width", 1);
        this.gHeight = data.getInt("height", 1);
    }

    @Override
    public void dispose() {
        this.entries.clear();
    }

    @Override
    public boolean add(String key, JsonValue data) {
        String horz = data.getString("x_anchor", "center");
        String vert = data.getString("y_anchor", "middle");
        Layout.Anchor anchor = this.getAnchor(horz, vert);
        int x = data.getInt("x_index", 0);
        int y = data.getInt("y_index", 0);
        return this.addPosition(key, x, y, anchor);
    }

    public boolean addPosition(String key, int x, int y, Layout.Anchor anchor) {
        if (this.entries.containsKey(key)) {
            return false;
        }
        Entry entry = new Entry(x, y, anchor);
        this.entries.put(key, entry);
        return true;
    }

    @Override
    public boolean remove(String key) {
        return this.entries.remove(key) != null;
    }

    @Override
    public void layout(SceneNode node) {
        List<SceneNode> kids = node.getChildren();
        Rectangle bounds = node.getLayoutBounds();
        Vector2 grid = new Vector2(bounds.width / (float)this.gWidth, bounds.height / (float)this.gHeight);
        for (SceneNode child : kids) {
            Entry entry = this.entries.get(child.getName());
            if (entry == null) continue;
            Rectangle cell = new Rectangle((float)entry.x * grid.x + bounds.x, (float)entry.y * grid.y + bounds.y, grid.x, grid.y);
            this.reanchor(child, entry.anchor);
            this.placeNode(child, entry.anchor, cell, ZERO);
        }
    }

    public Vector2 getGridSize() {
        return this.getGridSize(new Vector2());
    }

    public Vector2 getGridSize(Vector2 size) {
        return size.set((float)this.gWidth, (float)this.gHeight);
    }

    public void setGridSize(Vector2 size) {
        this.setGridSize((int)size.x, (int)size.y);
    }

    public void setGridSize(int width, int height) {
        if (this.validate(width, height)) {
            this.gWidth = width;
            this.gHeight = height;
        }
    }

    private boolean validate(int width, int height) {
        for (Entry layoutEntry : this.entries.values()) {
            int x = layoutEntry.x;
            int y = layoutEntry.y;
            if (x < width && y < height) continue;
            assert (false) : "Grid location (" + x + "," + y + ") is invalidated by new grid size (" + width + "," + height + ")";
            return false;
        }
        return true;
    }

    protected static class Entry {
        public int x;
        public int y;
        public Layout.Anchor anchor;

        Entry() {
        }

        Entry(int x, int y, Layout.Anchor anchor) {
            this.x = x;
            this.y = y;
            this.anchor = anchor;
        }
    }
}

