/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2.layout;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.layout.Layout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnchoredLayout
extends Layout {
    private final Vector2 vectorCache = new Vector2();
    protected Map<String, Entry> entries = new HashMap<String, Entry>();

    public AnchoredLayout() {
    }

    public AnchoredLayout(JsonValue data) {
    }

    @Override
    public void dispose() {
        this.entries.clear();
    }

    @Override
    public boolean add(String key, JsonValue data) {
        String horz = data.getString("x_anchor", "center");
        String vert = data.getString("y_anchor", "middle");
        Layout.Anchor anchor = this.getAnchor(horz, vert);
        float xOffset = data.getFloat("x_offset", 0.0f);
        float yOffset = data.getFloat("y_offset", 0.0f);
        this.vectorCache.set(xOffset, yOffset);
        boolean absolute = data.getBoolean("absolute", false);
        return absolute ? this.addAbsolute(key, anchor, this.vectorCache) : this.addRelative(key, anchor, this.vectorCache);
    }

    public boolean addAbsolute(String key, Layout.Anchor anchor, Vector2 offset) {
        if (this.entries.containsKey(key)) {
            return false;
        }
        Entry entry = new Entry();
        entry.anchor = anchor;
        entry.xOffset = offset.x;
        entry.yOffset = offset.y;
        entry.absolute = true;
        this.entries.put(key, entry);
        return true;
    }

    public boolean addRelative(String key, Layout.Anchor anchor, Vector2 offset) {
        if (this.entries.containsKey(key)) {
            return false;
        }
        Entry entry = new Entry();
        entry.anchor = anchor;
        entry.xOffset = offset.x;
        entry.yOffset = offset.y;
        entry.absolute = false;
        this.entries.put(key, entry);
        return true;
    }

    @Override
    public boolean remove(String key) {
        return this.entries.remove(key) != null;
    }

    @Override
    public void layout(SceneNode node) {
        List<SceneNode> children = node.getChildren();
        Rectangle bounds = node.getLayoutBounds();
        for (SceneNode child : children) {
            Entry entry = this.entries.get(child.getName());
            if (entry == null) continue;
            float xOffset = entry.absolute ? entry.xOffset : entry.xOffset * bounds.width;
            float yOffset = entry.absolute ? entry.yOffset : entry.yOffset * bounds.height;
            Vector2 offset = new Vector2(xOffset, yOffset);
            this.placeNode(child, entry.anchor, bounds, offset);
        }
    }

    protected static class Entry {
        public float xOffset = 0.0f;
        public float yOffset = 0.0f;
        public Layout.Anchor anchor = Layout.Anchor.CENTER;
        public boolean absolute = false;
    }
}

