/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.TextAlign;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.scene2.Label;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class TextField
extends Label {
    final int CURSOR_WIDTH = 3;
    final int CURSOR_PERIOD = 25;
    final int DELETE_DELAY = 500;
    Timer timer = new Timer(true);
    protected Rectangle cursor = new Rectangle();
    protected int cursorBlink = 0;
    protected int cursorIndex = 0;
    protected boolean showCursor = true;
    protected float cursorWidth = 3.0f;
    protected Color cursorColor = Color.BLACK;
    protected boolean active = false;
    protected boolean focused = false;
    protected boolean mouse = true;
    protected ArrayList<Listener> typeListeners = new ArrayList();
    protected ArrayList<Listener> exitListeners = new ArrayList();
    protected ArrayList<Listener> enterListeners = new ArrayList();
    protected boolean altDown;
    protected boolean metaDown;
    protected boolean shiftDown;
    protected int keyCount = 0;
    TimerTask leftTask = new TimerTask(){

        @Override
        public void run() {
            TextField.this.leftArrow();
        }
    };
    TimerTask rightTask = new TimerTask(){

        @Override
        public void run() {
            TextField.this.rightArrow();
        }
    };
    TimerTask upTask = new TimerTask(){

        @Override
        public void run() {
            TextField.this.upArrow();
        }
    };
    TimerTask downTask = new TimerTask(){

        @Override
        public void run() {
            TextField.this.downArrow();
        }
    };
    private float widthCache;

    @Override
    public void dispose() {
        if (this.active) {
            this.deactivate(true);
        }
        this.typeListeners.clear();
        this.exitListeners.clear();
        this.enterListeners.clear();
        this.timer.cancel();
        super.dispose();
    }

    public TextField() {
        this.classname = "TextField";
    }

    public TextField(Vector2 size) {
        super(size);
        this.classname = "TextField";
    }

    public TextField(float width, float height) {
        this(new Vector2(width, height));
    }

    public TextField(Rectangle rect) {
        super(rect);
        this.classname = "TextField";
    }

    public TextField(float x, float y, float width, float height) {
        this(new Rectangle(x, y, width, height));
    }

    public TextField(String text, BitmapFont font) {
        super(text, font);
        this.classname = "TextField";
    }

    public TextField(float x, float y, String text, BitmapFont font) {
        super(x, y, text, font);
        this.classname = "TextField";
    }

    public TextField(Vector2 size, String text, BitmapFont font) {
        super(size, text, font);
        this.classname = "TextField";
    }

    public TextField(Rectangle rect, String text, BitmapFont font) {
        super(rect, text, font);
        this.classname = "TextField";
    }

    public TextField(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        this.showCursor = data.getBoolean("cursor", false);
        this.cursorWidth = data.getFloat("cursorwidth", 3.0f);
        if (data.has("cursorcolor")) {
            JsonValue col = data.get("cursorcolor");
            if (col.isString()) {
                try {
                    this.cursorColor.set(Color.valueOf((String)col.asString()));
                }
                catch (IllegalStateException e) {
                    this.cursorColor.set(Color.WHITE);
                }
            } else {
                assert (col.size >= 4) : "'color' must be a four element number array";
                try {
                    this.cursorColor.r = (float)col.get(0).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.cursorColor.r = 0.0f;
                }
                try {
                    this.cursorColor.g = (float)col.get(1).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.cursorColor.g = 0.0f;
                }
                try {
                    this.cursorColor.b = (float)col.get(2).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.cursorColor.b = 0.0f;
                }
                try {
                    this.cursorColor.a = (float)col.get(3).asInt() / 255.0f;
                }
                catch (IllegalStateException e) {
                    this.cursorColor.a = 0.0f;
                }
            }
        }
    }

    public final Listener getTypeListener(int idx) {
        Listener item;
        try {
            item = this.typeListeners.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            item = null;
        }
        return item;
    }

    public ArrayList<Listener> getTypeListeners() {
        return this.typeListeners;
    }

    public void addTypeListener(Listener listener) {
        this.typeListeners.add(listener);
    }

    public boolean removeTypeListener(int idx) {
        Listener item;
        try {
            item = this.typeListeners.remove(idx);
        }
        catch (IndexOutOfBoundsException e) {
            item = null;
        }
        return item != null;
    }

    public void clearTypeListeners() {
        this.typeListeners.clear();
    }

    public final Listener getExitListener(int idx) {
        Listener item;
        try {
            item = this.exitListeners.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            item = null;
        }
        return item;
    }

    public ArrayList<Listener> getExitListeners() {
        return this.exitListeners;
    }

    public void addExitListener(Listener listener) {
        this.exitListeners.add(listener);
    }

    public boolean removeExitListener(int idx) {
        Listener item;
        try {
            item = this.exitListeners.remove(idx);
        }
        catch (IndexOutOfBoundsException e) {
            item = null;
        }
        return item != null;
    }

    public void clearExitListeners() {
        this.exitListeners.clear();
    }

    public final Listener getEnterListener(int idx) {
        Listener item;
        try {
            item = this.enterListeners.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            item = null;
        }
        return item;
    }

    public ArrayList<Listener> getEnterListeners() {
        return this.enterListeners;
    }

    public void addEnterListener(Listener listener) {
        this.enterListeners.add(listener);
    }

    public boolean removeEnterListener(int idx) {
        Listener item;
        try {
            item = this.enterListeners.remove(idx);
        }
        catch (IndexOutOfBoundsException e) {
            item = null;
        }
        return item != null;
    }

    public void clearEnterListeners() {
        this.enterListeners.clear();
    }

    @Override
    public void setText(String text, boolean resize) {
        super.setText(text, resize);
        this.cursorIndex = text.length();
        this.updateCursor();
    }

    public boolean activate() {
        if (this.active) {
            return false;
        }
        this.active = true;
        this.timer = new Timer(true);
        return true;
    }

    public boolean deactivate(boolean dispose) {
        if (!this.active) {
            return false;
        }
        ++this.keyCount;
        boolean success = true;
        if (this.focused && !dispose) {
            success = this.releaseFocus();
        }
        this.timer.cancel();
        this.active = false;
        return success;
    }

    public boolean requestFocus() {
        if (!this.active || this.focused) {
            return false;
        }
        this.altDown = false;
        this.metaDown = false;
        this.shiftDown = false;
        ++this.keyCount;
        this.focused = true;
        this.cursorBlink = 0;
        this.cursorIndex = this.layout.getText().length();
        this.updateCursor();
        this.invokeListeners(ListenerType.ENTER);
        return true;
    }

    public boolean releaseFocus() {
        if (!this.focused) {
            return false;
        }
        this.invokeListeners(ListenerType.EXIT);
        this.focused = false;
        return true;
    }

    @Override
    public void draw(SpriteBatch batch, Affine2 transform, Color tint) {
        super.draw(batch, transform, tint);
        if (this.focused && this.showCursor) {
            --this.cursorBlink;
            if (this.cursorBlink < 0) {
                batch.setTexture(Texture2D.getBlank());
                batch.setColor(this.cursorColor);
                batch.fill(this.cursor, transform);
            }
            if (this.cursorBlink == -25) {
                this.cursorBlink = 25;
            }
        }
    }

    @Override
    public void generateRenderData() {
        super.generateRenderData();
        this.updateCursor();
    }

    public boolean updateInput(char character) {
        if (!this.focused) {
            return false;
        }
        if (character == '\u232b' || character == '\b') {
            this.deleteChar();
            return true;
        }
        if (TextField.getUnicodeType(Character.codePointAt(new char[]{character}, 0)) == UnicodeType.NEWLINE) {
            this.cursorIndex = this.breakLine(this.cursorIndex);
            this.invokeListeners(ListenerType.TYPE);
            return true;
        }
        if (!this.font.getData().hasGlyph(character)) {
            this.cursorIndex = this.insertChar(character, this.cursorIndex);
            this.invokeListeners(ListenerType.TYPE);
            return true;
        }
        GlyphLayout.GlyphRun row = null;
        if (this.cursorIndex == this.layout.getText().length()) {
            row = this.layout.getRun(this.layout.getLineCount() - 1);
        } else {
            int total = 0;
            int i = 0;
            while (i < this.layout.getLineCount()) {
                if (this.cursorIndex <= this.layout.getTextIndex(total += this.layout.getRun((int)i).glyphs.size)) {
                    row = this.layout.getRun(i);
                    i = this.layout.getLineCount();
                    continue;
                }
                ++i;
            }
        }
        if (row == null) {
            return true;
        }
        Rectangle interior = this.getInterior();
        BitmapFont.Glyph glyph = this.font.getData().getGlyph(character);
        float charWidth = (float)(glyph.width + glyph.xoffset) * this.font.getData().scaleX - this.font.getData().padRight;
        if (row.width + charWidth < interior.width) {
            this.cursorIndex = this.insertChar(character, this.cursorIndex);
            this.invokeListeners(ListenerType.TYPE);
            return true;
        }
        if (this.layout.getWidth() <= 0.0f) {
            return true;
        }
        int oldindex = this.cursorIndex;
        this.cursorIndex = this.insertChar(character, this.cursorIndex);
        float height = this.font.getLineHeight() * (float)this.layout.getLineCount();
        if (interior.height < height) {
            String text = this.layout.getText();
            this.layout.setText(text.substring(0, oldindex) + text.substring(this.cursorIndex));
            this.cursorIndex = oldindex;
            this.layout.layout();
        } else {
            this.invokeListeners(ListenerType.TYPE);
        }
        this.reanchor();
        return true;
    }

    public boolean updateKey(int keycode, boolean down) {
        if (!this.focused) {
            return false;
        }
        switch (keycode) {
            case 57: 
            case 58: {
                this.altDown = down;
                break;
            }
            case 59: 
            case 60: {
                this.shiftDown = down;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 16: 
            case 32: 
            case 64: 
            case 128: {
                this.metaDown = down;
                break;
            }
            case 21: {
                if (down) {
                    this.leftArrow();
                    try {
                        this.timer.schedule(this.leftTask, 500L, 25L);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    break;
                }
                this.leftTask.cancel();
                this.leftTask = new TimerTask(){

                    @Override
                    public void run() {
                        TextField.this.leftArrow();
                    }
                };
                break;
            }
            case 22: {
                if (down) {
                    this.rightArrow();
                    try {
                        this.timer.schedule(this.rightTask, 500L, 25L);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    break;
                }
                this.rightTask.cancel();
                this.rightTask = new TimerTask(){

                    @Override
                    public void run() {
                        TextField.this.rightArrow();
                    }
                };
                break;
            }
            case 19: {
                if (down) {
                    this.upArrow();
                    try {
                        this.timer.schedule(this.upTask, 500L, 25L);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    break;
                }
                this.upTask.cancel();
                this.upTask = new TimerTask(){

                    @Override
                    public void run() {
                        TextField.this.upArrow();
                    }
                };
                break;
            }
            case 20: {
                if (down) {
                    this.downArrow();
                    try {
                        this.timer.schedule(this.downTask, 500L, 25L);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    break;
                }
                this.downTask.cancel();
                this.downTask = new TimerTask(){

                    @Override
                    public void run() {
                        TextField.this.downArrow();
                    }
                };
                break;
            }
            case 66: {
                if (this.shiftDown) break;
                this.releaseFocus();
                break;
            }
            case 160: {
                this.releaseFocus();
                break;
            }
        }
        return true;
    }

    public boolean updatePress(Vector2 pos) {
        Vector2 localPos = this.screenToNodeCoords(pos);
        if (!new Rectangle(0.0f, 0.0f, this.getContentWidth(), this.getContentHeight()).contains(localPos)) {
            if (this.focused) {
                this.releaseFocus();
            }
        } else {
            if (!this.focused) {
                this.requestFocus();
            }
            localPos.sub(this.offset);
            GlyphLayout.GlyphRun run = null;
            Vector2 lOffset = this.layout.getOffset();
            int lineno = 0;
            float cy = 0.0f;
            for (int ii = 0; run == null && ii < this.layout.getLineCount(); ++ii) {
                GlyphLayout.GlyphRun line = this.layout.getRun(ii);
                cy = line.y + lOffset.y - this.font.getLineHeight();
                if (localPos.y >= cy) {
                    run = line;
                    continue;
                }
                ++lineno;
            }
            if (run == null) {
                this.cursorBlink = 0;
                this.updateCursor();
                return true;
            }
            this.widthCache = localPos.x;
            this.cursorIndex = this.getCharIndex(lineno, this.widthCache);
            this.cursor.setPosition(this.widthCache, cy);
            this.cursor.x += this.offset.x - this.cursorWidth / 2.0f;
            this.cursor.y += this.offset.y;
            this.cursor.width = this.cursorWidth;
            this.cursor.height = this.font.getLineHeight();
            this.cursorBlink = 0;
        }
        return true;
    }

    public void updateCursor() {
        float xAdv;
        int lineno = this.getCharRow();
        GlyphLayout.GlyphRun row = this.layout.getRun(lineno);
        int begin = 0;
        for (int i = 0; i < lineno; ++i) {
            begin += this.layout.getRun((int)i).glyphs.size;
        }
        int end = begin + this.layout.getRun((int)lineno).glyphs.size;
        Vector2 lOffset = this.layout.getOffset();
        float f = xAdv = row.xAdvances.size == 0 ? 0.0f : row.xAdvances.first();
        if (((BitmapFont.Glyph)row.glyphs.get((int)0)).id == 10) {
            if (TextAlign.isCenter(this.getAlignment())) {
                row.x = (this.getContentWidth() - this.padleft - this.padrght) * 0.5f;
            } else if (TextAlign.isRight(this.getAlignment())) {
                row.x = this.getContentWidth() - this.padleft - this.padrght;
            }
        }
        this.cache.set(row.x + lOffset.x + xAdv, row.y + lOffset.y - this.font.getLineHeight());
        int beginIdx = this.layout.getTextIndex(begin);
        if (this.cursorIndex > this.layout.getTextIndex(end)) {
            this.cache.x += row.width;
        } else if (this.cursorIndex > beginIdx) {
            int col = 0;
            int i = 0;
            while (beginIdx + i < this.cursorIndex && begin + col < end) {
                if (((BitmapFont.Glyph)row.glyphs.get((int)col)).id == this.layout.getText().charAt(beginIdx + i)) {
                    this.cache.x += row.xAdvances.get(++col);
                }
                ++i;
            }
        }
        this.cache.add(this.offset);
        this.cache.x -= this.cursorWidth / 2.0f;
        this.cursor.setPosition(this.cache);
        this.cursor.width = this.cursorWidth;
        this.cursor.height = this.font.getLineHeight();
    }

    public static UnicodeType getUnicodeType(int code) {
        switch (code) {
            case 9: 
            case 32: 
            case 160: {
                return UnicodeType.SPACE;
            }
            case 10: 
            case 13: 
            case 133: {
                return UnicodeType.NEWLINE;
            }
        }
        if (code == 0 || code == 11 || code == 12 || 28 <= code && code <= 31) {
            return UnicodeType.CONTROL;
        }
        if (code >= 19968 && code <= 40959 || code >= 12288 && code <= 12543 || code >= 65280 && code <= 65519 || code >= 4352 && code <= 4607 || code >= 12592 && code <= 12687 || code >= 44032 && code <= 55215) {
            return UnicodeType.CJK;
        }
        return UnicodeType.CHAR;
    }

    public int skipWord(boolean forward) {
        if (forward) {
            if (this.cursorIndex == this.layout.getText().length()) {
                return this.cursorIndex;
            }
            int code = this.layout.getText().codePointAt(this.cursorIndex);
            int cursor = this.layout.getText().offsetByCodePoints(this.cursorIndex, 1);
            UnicodeType type = TextField.getUnicodeType(code);
            boolean tospace = type == UnicodeType.CHAR || type == UnicodeType.CJK;
            boolean atend = false;
            if (cursor == this.layout.getText().length()) {
                return this.cursorIndex + 1;
            }
            while (!atend && cursor < this.layout.getText().length()) {
                code = this.layout.getText().codePointAt(cursor);
                cursor = this.layout.getText().offsetByCodePoints(cursor, 1);
                type = TextField.getUnicodeType(code);
                if (tospace) {
                    atend = type != UnicodeType.CHAR && type != UnicodeType.CJK;
                    continue;
                }
                atend = type == UnicodeType.CHAR || type == UnicodeType.CJK;
            }
            return atend ? cursor - 1 : cursor;
        }
        if (this.cursorIndex == 0) {
            return this.cursorIndex;
        }
        int code = this.layout.getText().codePointAt(this.cursorIndex - 1);
        int cursor = this.layout.getText().offsetByCodePoints(this.cursorIndex, -1);
        UnicodeType type = TextField.getUnicodeType(code);
        boolean tospace = type == UnicodeType.CHAR || type == UnicodeType.CJK;
        boolean atbegin = false;
        if (cursor == 0) {
            return 0;
        }
        while (!atbegin && cursor > 0) {
            code = this.layout.getText().codePointAt(cursor - 1);
            cursor = this.layout.getText().offsetByCodePoints(cursor, -1);
            type = TextField.getUnicodeType(code);
            if (tospace) {
                atbegin = type != UnicodeType.CHAR && type != UnicodeType.CJK;
                continue;
            }
            atbegin = type == UnicodeType.CHAR || type == UnicodeType.CJK;
        }
        return atbegin ? cursor + 1 : 0;
    }

    public void deleteChar() {
        if (this.cursorIndex <= 0) {
            return;
        }
        if (this.metaDown) {
            this.layout.setText("");
            this.layout.layout();
            this.cursorIndex = 0;
        } else {
            int start = this.altDown ? this.skipWord(false) : this.layout.getText().offsetByCodePoints(this.cursorIndex, -1);
            String text = this.layout.getText();
            this.layout.setText(text.substring(0, start) + text.substring(this.cursorIndex));
            this.layout.layout();
            this.cursorIndex = start;
        }
        this.invokeListeners(ListenerType.TYPE);
        this.clearRenderData();
        this.reanchor();
    }

    public void leftArrow() {
        if (this.cursorIndex > 0) {
            int left = 0;
            if (this.altDown) {
                left = this.skipWord(false);
            } else if (!this.metaDown) {
                left = this.layout.getText().offsetByCodePoints(this.cursorIndex, -1);
            }
            this.cursorIndex = left;
            this.cursorBlink = 0;
            this.updateCursor();
        }
    }

    public void rightArrow() {
        if (this.cursorIndex < this.layout.getText().length()) {
            int right = this.layout.getText().length();
            if (this.altDown) {
                right = this.skipWord(true);
            } else if (!this.metaDown) {
                right = this.layout.getText().offsetByCodePoints(this.cursorIndex, 1);
            }
            this.cursorIndex = right;
            this.cursorBlink = 0;
            this.updateCursor();
        }
    }

    public void upArrow() {
        int lineno = this.getCharRow();
        if (lineno > 0) {
            this.widthCache = this.cursor.x + this.cursor.width / 2.0f - this.offset.x;
            this.cursorIndex = this.getCharIndex(lineno - 1, this.widthCache);
            GlyphLayout.GlyphRun row = this.layout.getRun(lineno - 1);
            this.cache.set(this.widthCache, row.y + this.layout.getOffset().y - this.font.getLineHeight());
            this.cache.add(this.offset);
            this.cache.x -= this.cursorWidth / 2.0f;
            this.cursor.setPosition(this.cache);
            this.cursor.width = this.cursorWidth;
            this.cursor.height = this.font.getLineHeight();
            this.cursorBlink = 0;
        }
    }

    public void downArrow() {
        int lineno = this.getCharRow();
        if (lineno < this.layout.getLineCount() - 1) {
            this.widthCache = this.cursor.x + this.cursor.width / 2.0f - this.offset.x;
            this.cursorIndex = this.getCharIndex(lineno + 1, this.widthCache);
            GlyphLayout.GlyphRun row = this.layout.getRun(lineno + 1);
            this.cache.set(this.widthCache, row.y + this.layout.getOffset().y - this.font.getLineHeight());
            this.cache.add(this.offset);
            this.cache.x -= this.cursorWidth / 2.0f;
            this.cursor.setPosition(this.cache);
            this.cursor.width = this.cursorWidth;
            this.cursor.height = this.font.getLineHeight();
            this.cursorBlink = 0;
        }
    }

    public int insertChar(char character, int pos) {
        if (TextField.getUnicodeType(Character.codePointAt(new char[]{character}, 0)) == UnicodeType.NEWLINE) {
            return this.breakLine(pos);
        }
        String text = this.layout.getText();
        this.layout.setText(text.substring(0, pos) + character + text.substring(pos));
        this.layout.layout();
        this.clearRenderData();
        this.reanchor();
        return this.layout.getText().offsetByCodePoints(pos, 1);
    }

    public int breakLine(int pos) {
        int lines = this.layout.getLineCount();
        float space = this.font.getLineHeight() * (float)lines + this.font.getLineHeight();
        if (space > this.getInterior().height) {
            return pos;
        }
        String text = this.layout.getText();
        this.layout.setText(text.substring(0, pos) + "\n" + text.substring(pos));
        this.layout.layout();
        this.clearRenderData();
        this.reanchor();
        return this.layout.getText().offsetByCodePoints(pos, 1);
    }

    public int getCharIndex(int row, float offset) {
        GlyphLayout.GlyphRun run = this.layout.getRun(row);
        if (((BitmapFont.Glyph)run.glyphs.get((int)0)).id == 10) {
            if (TextAlign.isCenter(this.getAlignment())) {
                run.x = (this.getContentWidth() - this.padleft - this.padrght) * 0.5f;
            } else if (TextAlign.isRight(this.getAlignment())) {
                run.x = this.getContentWidth() - this.padleft - this.padrght;
            }
        }
        float width = run.x + this.layout.getOffset().x;
        int index = 0;
        for (int i = 0; i < row; ++i) {
            index += this.layout.getRun((int)i).glyphs.size;
        }
        if (offset >= width + run.width) {
            this.widthCache = width + run.width;
            index += run.glyphs.size;
            int adjust = 0;
            if (row == this.layout.getLineCount() - 1) {
                return this.layout.getTextIndex(index) + 1;
            }
            if (this.layout.getTextIndex(index) - 1 != this.layout.getTextIndex(index - 1)) {
                --adjust;
            }
            return this.layout.getTextIndex(index) + adjust;
        }
        float[] xAdvances = run.xAdvances.items;
        boolean found = false;
        for (int ii = 0; !found && ii <= run.glyphs.size; ++ii) {
            float advance = xAdvances[ii + 1];
            if (!(offset <= (width += xAdvances[ii]) + advance)) continue;
            found = true;
            if (width + advance - offset < advance / 2.0f) {
                width += advance;
                index += ii + 1;
                continue;
            }
            index += ii;
        }
        if (!found && width < offset) {
            index += run.glyphs.size;
        }
        this.widthCache = width;
        return this.layout.getTextIndex(index);
    }

    public int getCharRow() {
        int lineno;
        if (this.cursorIndex >= this.layout.getText().length()) {
            return this.layout.getLineCount() - 1;
        }
        int total = 0;
        for (lineno = 0; lineno < this.layout.getLineCount() - 1; ++lineno) {
            String line = this.layout.getLine(lineno);
            int temp = total;
            if (this.cursorIndex > this.layout.getTextIndex(total += line.length())) continue;
            if (this.cursorIndex > this.layout.getTextIndex(total - 1) && this.cursorIndex - 1 != this.layout.getTextIndex(total - 1)) {
                ++lineno;
            }
            if (this.cursorIndex >= this.layout.getTextIndex(temp)) break;
            --lineno;
            break;
        }
        return lineno;
    }

    public void invokeListeners(ListenerType listenerType) {
        switch (listenerType) {
            case ENTER: {
                for (Listener item : this.enterListeners) {
                    item.listen(this.getName(), this.layout.getText());
                }
                break;
            }
            case TYPE: {
                for (Listener item : this.typeListeners) {
                    item.listen(this.getName(), this.layout.getText());
                }
                break;
            }
            case EXIT: {
                for (Listener item : this.exitListeners) {
                    item.listen(this.getName(), this.layout.getText());
                }
                break;
            }
        }
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector2 pos = new Vector2((float)screenX, (float)screenY);
        if (this.active && this.focused && !this.inContentBounds(pos)) {
            this.focused = false;
        }
        if (super.touchDown(screenX, screenY, pointer, button)) {
            return true;
        }
        if (this.active) {
            return this.updatePress(pos);
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        if (super.keyTyped(character)) {
            return true;
        }
        if (this.active) {
            return this.updateInput(character);
        }
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (super.keyDown(keycode)) {
            return true;
        }
        if (this.active) {
            return this.updateKey(keycode, true);
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        if (super.keyDown(keycode)) {
            return true;
        }
        if (this.active) {
            return this.updateKey(keycode, false);
        }
        return false;
    }

    @FunctionalInterface
    public static interface Listener {
        public void listen(String var1, String var2);
    }

    static enum ListenerType {
        ENTER,
        TYPE,
        EXIT;

    }

    public static enum UnicodeType {
        CHAR,
        CJK,
        SPACE,
        NEWLINE,
        CONTROL;

    }
}

