/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.graphics.SpriteSheet;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.math.PolyTriangulator;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleData;

public class ObstacleSprite
implements ObstacleData {
    protected SpriteSheet sprite;
    protected SpriteMesh mesh;
    protected Obstacle obstacle;
    protected Color debug;
    protected Affine2 transform;

    public ObstacleSprite() {
        this.sprite = new SpriteSheet();
        this.mesh = new SpriteMesh();
        this.transform = new Affine2();
        this.debug = Color.WHITE;
    }

    public ObstacleSprite(Obstacle obstacle) {
        this(obstacle, true);
    }

    public ObstacleSprite(Obstacle obstacle, boolean mesh) {
        this.obstacle = obstacle;
        this.sprite = new SpriteSheet();
        this.mesh = new SpriteMesh();
        this.transform = new Affine2();
        this.debug = Color.WHITE;
        this.obstacle.setUserData(this);
        if (mesh && obstacle != null) {
            Path2 outline = obstacle.getOutline();
            PolyTriangulator triangulator = new PolyTriangulator();
            triangulator.set(outline);
            triangulator.calculate();
            Poly2 shape = triangulator.getPolygon();
            this.mesh.set(shape, outline.getBounds());
        }
    }

    public String getName() {
        return this.obstacle == null ? null : this.obstacle.getName();
    }

    public Obstacle getObstacle() {
        return this.obstacle;
    }

    public void setObstacle(Obstacle obstacle) {
        this.obstacle = obstacle;
    }

    public SpriteMesh getMesh() {
        return this.mesh;
    }

    public TextureRegion getSpriteSheet() {
        return this.sprite;
    }

    public void setTexture(Texture texture) {
        if (texture != null) {
            this.sprite.set(texture, 1, 1);
        } else {
            this.sprite.setTexture(null);
        }
    }

    public void setTextureRegion(TextureRegion region) {
        if (region != null) {
            this.sprite.setRegion(region);
        } else {
            this.sprite.setTexture(null);
        }
    }

    public void setSpriteSheet(SpriteSheet sheet) {
        this.sprite.set(sheet);
    }

    public Color getDebugColor() {
        return this.debug;
    }

    public void setDebugColor(Color color) {
        this.debug = color == null ? Color.WHITE : color;
    }

    public void draw(SpriteBatch batch) {
        if (this.obstacle == null || this.mesh == null) {
            return;
        }
        float x = this.obstacle.getX();
        float y = this.obstacle.getY();
        float a = this.obstacle.getAngle();
        float u = this.obstacle.getPhysicsUnits();
        this.transform.idt();
        this.transform.preRotate((float)((double)(a * 180.0f) / Math.PI));
        this.transform.preTranslate(x * u, y * u);
        batch.setTextureRegion(this.sprite);
        batch.drawMesh(this.mesh, this.transform, false);
        batch.setTexture(null);
    }

    public void draw(SpriteBatch batch, Affine2 affine) {
        if (this.obstacle == null || this.mesh == null) {
            return;
        }
        float x = this.obstacle.getX();
        float y = this.obstacle.getY();
        float a = this.obstacle.getAngle();
        float u = this.obstacle.getPhysicsUnits();
        this.transform.set(affine);
        this.transform.preRotate((float)((double)(a * 180.0f) / Math.PI));
        this.transform.preTranslate(x * u, y * u);
        batch.setTextureRegion(this.sprite);
        batch.drawMesh(this.mesh, this.transform, false);
        batch.setTexture(null);
    }

    public void drawDebug(SpriteBatch batch) {
        if (this.obstacle == null) {
            return;
        }
        this.obstacle.draw(batch, this.debug);
    }

    public void drawDebug(SpriteBatch batch, Affine2 affine) {
        if (this.obstacle == null) {
            return;
        }
        this.obstacle.draw(batch, this.debug, affine);
    }

    @Override
    public void update(float dt) {
    }
}

