/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics2;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import edu.cornell.gdiac.physics2.Obstacle;

public class BoxObstacle
extends Obstacle {
    protected PolygonShape shape;
    private Vector2 dimension;
    private Vector2 sizeCache;
    private Fixture geometry;
    private float[] vertices;

    public Vector2 getDimension() {
        return this.sizeCache.set(this.dimension);
    }

    public void setDimension(Vector2 value) {
        this.setDimension(value.x, value.y);
    }

    public void setDimension(float width, float height) {
        this.dimension.set(width, height);
        this.markDirty(true);
        this.resize(width, height);
    }

    public float getWidth() {
        return this.dimension.x;
    }

    public void setWidth(float value) {
        this.sizeCache.set(value, this.dimension.y);
        this.setDimension(this.sizeCache);
    }

    public float getHeight() {
        return this.dimension.y;
    }

    public void setHeight(float value) {
        this.sizeCache.set(this.dimension.x, value);
        this.setDimension(this.sizeCache);
    }

    public BoxObstacle() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public BoxObstacle(float width, float height) {
        this(0.0f, 0.0f, width, height);
    }

    public BoxObstacle(float x, float y, float width, float height) {
        super(x, y);
        this.dimension = new Vector2(width, height);
        this.sizeCache = new Vector2();
        this.shape = new PolygonShape();
        this.vertices = new float[8];
        this.geometry = null;
        this.resize(width, height);
    }

    private void resize(float width, float height) {
        this.vertices[0] = -width / 2.0f;
        this.vertices[1] = -height / 2.0f;
        this.vertices[2] = width / 2.0f;
        this.vertices[3] = -height / 2.0f;
        this.vertices[4] = width / 2.0f;
        this.vertices[5] = height / 2.0f;
        this.vertices[6] = -width / 2.0f;
        this.vertices[7] = height / 2.0f;
        this.shape.set(this.vertices);
        this.outline.vertices.clear();
        this.outline.vertices.addAll(this.vertices);
        this.outline.closed = true;
    }

    @Override
    protected void createFixtures() {
        if (this.body == null || this.dimension.x <= 0.0f || this.dimension.y <= 0.0f) {
            return;
        }
        this.releaseFixtures();
        this.fixture.shape = this.shape;
        this.geometry = this.body.createFixture(this.fixture);
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.geometry != null) {
            this.body.destroyFixture(this.geometry);
            this.geometry = null;
        }
    }
}

