/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.ShaderLoader;
import edu.cornell.gdiac.graphics.Shader;

public class ShaderParser
implements AssetParser<Shader> {
    private JsonValue root;

    @Override
    public Class<Shader> getType() {
        return Shader.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.root = this.root.getChild("shaders");
    }

    @Override
    public boolean hasNext() {
        return this.root != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        ShaderLoader.ShaderParameters params = new ShaderLoader.ShaderParameters();
        if (this.root.isObject()) {
            String s;
            if (this.root.has("vertex")) {
                params.vertex20 = s = this.root.getString("vertex", null);
                params.vertex30 = s;
            } else {
                params.vertex20 = this.root.getString("vertex20", null);
                params.vertex30 = this.root.getString("vertex30", null);
            }
            if (this.root.has("fragment")) {
                params.fragment20 = s = this.root.getString("fragment", null);
                params.fragment30 = s;
            } else {
                params.fragment20 = this.root.getString("fragment20", null);
                params.fragment30 = this.root.getString("fragment30", null);
            }
        }
        String file = this.root.name() + ".prog";
        keymap.put((Object)this.root.name(), (Object)file);
        manager.load(file, Shader.class, (AssetLoaderParameters)params);
        this.root = this.root.next();
    }

    public boolean equals(Object o) {
        return o instanceof ShaderParser;
    }
}

