/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.MaterialLibLoader;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.MaterialLib;
import edu.cornell.gdiac.graphics.obj.Model;
import edu.cornell.gdiac.graphics.obj.ModelInfo;
import edu.cornell.gdiac.graphics.obj.ObjParser;
import java.io.BufferedReader;
import java.io.IOException;

public class ObjModelLoader
extends AsynchronousAssetLoader<Model, ModelParameters> {
    protected FileHandleResolver resolver;
    protected ObjParser parser;
    private Model cachedModel;

    public ObjModelLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public ObjModelLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
        this.parser = new ObjParser(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, ModelParameters params) {
        ModelInfo info = this.parser.parseObj(params.name, fileName, true);
        Material baseMaterial = null;
        if (params.material != null) {
            MaterialLib library = (MaterialLib)manager.get(params.material.source, MaterialLib.class);
            info.libraries.put((Object)library.name, (Object)library);
            baseMaterial = library.getMaterial(params.material.name);
        } else {
            for (ObjectMap.Entry lib : params.libraries) {
                MaterialLib library = (MaterialLib)manager.get((String)lib.value, MaterialLib.class);
                info.libraries.put((Object)((String)lib.key), (Object)library);
            }
        }
        this.cachedModel = new Model(info, 0);
        if (baseMaterial != null) {
            for (Model.Surface surface : this.cachedModel.getSurfaces()) {
                if (surface.getMaterial() != null) continue;
                surface.setMaterial(baseMaterial);
            }
        }
    }

    protected Model getLoadedLibrary() {
        return this.cachedModel;
    }

    public Model loadSync(AssetManager manager, String fileName, FileHandle file, ModelParameters params) {
        Model model = this.cachedModel;
        model.createBuffer();
        this.cachedModel = null;
        return model;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ModelParameters params) {
        ObjectMap<String, String> libs = this.getLibraries(file);
        if (params.material != null) {
            Array deps = new Array(1);
            deps.add((Object)new AssetDescriptor(params.material.source, MaterialLib.class, (AssetLoaderParameters)params.material));
            return deps;
        }
        if (params.libraries.size > 0) {
            Array deps = new Array(params.libraries.size);
            for (ObjectMap.Entry lib : params.libraries) {
                deps.add((Object)new AssetDescriptor((String)lib.value, MaterialLib.class));
            }
            return deps;
        }
        return null;
    }

    private ObjectMap<String, String> getLibraries(FileHandle file) {
        ObjectMap result = new ObjectMap();
        BufferedReader reader = file.reader(1024);
        FileHandle directory = file.parent();
        try {
            String prefix = "mtllib";
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains(prefix)) continue;
                int pos0 = line.indexOf(prefix) + prefix.length();
                int pos1 = line.indexOf("#");
                if (pos1 == -1) {
                    pos1 = line.length();
                }
                if (pos0 >= pos1) continue;
                String name = line.substring(pos0, pos1).trim();
                String path = directory.child(name).path();
                result.put((Object)name, (Object)path);
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static class ModelParameters
    extends AssetLoaderParameters<Model> {
        public String name;
        public String source;
        public ObjectMap<String, String> libraries;
        public MaterialLibLoader.MaterialLibParameters material;

        public ModelParameters() {
            this.name = null;
            this.source = null;
            this.material = null;
            this.libraries = new ObjectMap();
        }

        public ModelParameters(String fileName) {
            this.name = fileName;
            this.source = fileName;
            this.material = null;
            this.libraries = new ObjectMap();
        }
    }
}

