/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.MusicQueueLoader;
import edu.cornell.gdiac.audio.MusicQueue;

public class MusicQueueParser
implements AssetParser<MusicQueue> {
    private JsonValue root;

    @Override
    public Class<MusicQueue> getType() {
        return MusicQueue.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.root = this.root.getChild("soundtrack");
    }

    @Override
    public boolean hasNext() {
        return this.root != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        MusicQueueLoader.MusicQueueParameters params = new MusicQueueLoader.MusicQueueParameters();
        params.isMono = this.root.getBoolean("mono", false);
        params.sampleRate = this.root.getInt("sampleRate", 44100);
        params.volume = this.root.getFloat("volume", 1.0f);
        params.pitch = this.root.getFloat("pitch", 1.0f);
        params.panning = this.root.getFloat("panning", 0.0f);
        params.looping = this.root.getBoolean("looping", false);
        params.shortLoop = this.root.getBoolean("shortLoop", false);
        JsonValue sources = this.root.get("sources");
        if (sources != null) {
            for (int ii = 0; ii < sources.size; ++ii) {
                params.sources.add((Object)sources.getString(ii));
            }
        }
        keymap.put((Object)this.root.name(), (Object)this.root.name());
        manager.load(this.root.name(), MusicQueue.class, (AssetLoaderParameters)params);
        this.root = this.root.next();
    }

    public boolean equals(Object o) {
        return o instanceof MusicQueueParser;
    }
}

