/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.MaterialInfo;
import edu.cornell.gdiac.graphics.obj.MaterialLib;
import edu.cornell.gdiac.graphics.obj.ObjParser;

public class MaterialLibLoader
extends AsynchronousAssetLoader<MaterialLib, MaterialLibParameters> {
    protected FileHandleResolver resolver;
    protected ObjParser parser;
    private MaterialLib cachedLib;

    public MaterialLibLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public MaterialLibLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
        this.parser = new ObjParser(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, MaterialLibParameters params) {
        if (params == null) {
            this.cachedLib = this.parser.parseMtl(file.name(), fileName);
            for (ObjectMap.Entry info : this.cachedLib.infos) {
                Material mat = new Material((MaterialInfo)info.value, false);
                mat.setAmbientMap(this.getLightMap(((MaterialInfo)info.value).map_Ka, manager));
                mat.setDiffuseMap(this.getLightMap(((MaterialInfo)info.value).map_Kd, manager));
                mat.setSpecularMap(this.getLightMap(((MaterialInfo)info.value).map_Ks, manager));
                mat.setBumpMap(this.getLightMap(((MaterialInfo)info.value).map_Kn, manager));
                this.cachedLib.setMaterial((String)info.key, mat);
            }
        } else if (params.material != null) {
            this.cachedLib = new MaterialLib();
            Material mat = new Material(params.material, false);
            mat.setAmbientMap(this.getLightMap(params.material.map_Ka, manager));
            mat.setDiffuseMap(this.getLightMap(params.material.map_Kd, manager));
            mat.setSpecularMap(this.getLightMap(params.material.map_Ks, manager));
            mat.setBumpMap(this.getLightMap(params.material.map_Kn, manager));
            this.cachedLib.name = params.material.name;
            this.cachedLib.path = fileName;
            this.cachedLib.infos.put((Object)params.material.name, (Object)params.material);
            this.cachedLib.setMaterial(params.material.name, mat);
        } else {
            this.cachedLib = this.parser.parseMtl(params.name, fileName);
            for (ObjectMap.Entry info : this.cachedLib.infos) {
                Material mat = new Material((MaterialInfo)info.value, false);
                mat.setAmbientMap(this.getLightMap(((MaterialInfo)info.value).map_Ka, manager));
                mat.setDiffuseMap(this.getLightMap(((MaterialInfo)info.value).map_Kd, manager));
                mat.setSpecularMap(this.getLightMap(((MaterialInfo)info.value).map_Ks, manager));
                mat.setBumpMap(this.getLightMap(((MaterialInfo)info.value).map_Kn, manager));
                this.cachedLib.setMaterial((String)info.key, mat);
            }
        }
    }

    private Texture getLightMap(MaterialInfo.LightMap info, AssetManager manager) {
        if (info == null) {
            return null;
        }
        return (Texture)manager.get(info.path, Texture.class);
    }

    protected MaterialLib getLoadedLibrary() {
        return this.cachedLib;
    }

    public MaterialLib loadSync(AssetManager manager, String fileName, FileHandle file, MaterialLibParameters params) {
        MaterialLib library = this.cachedLib;
        this.cachedLib = null;
        return library;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, MaterialLibParameters params) {
        if (params == null) {
            MaterialLib early = this.parser.parseMtl(file.name(), fileName);
            Array deps = new Array(4 * early.infos.size);
            for (ObjectMap.Entry info : early.infos) {
                if (((MaterialInfo)info.value).map_Ka != null) {
                    deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Ka.path, Texture.class));
                }
                if (((MaterialInfo)info.value).map_Kd != null) {
                    deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Kd.path, Texture.class));
                }
                if (((MaterialInfo)info.value).map_Ks != null) {
                    deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Ks.path, Texture.class));
                }
                if (((MaterialInfo)info.value).map_Kn == null) continue;
                deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Kn.path, Texture.class));
            }
            return deps.size > 0 ? deps : null;
        }
        if (params.material != null) {
            Array deps = new Array(4);
            if (params.material.map_Ka != null && !params.textures.containsKey((Object)params.material.map_Ka.name)) {
                deps.add((Object)new AssetDescriptor(params.material.map_Ka.path, Texture.class));
            }
            if (params.material.map_Kd != null && !params.textures.containsKey((Object)params.material.map_Kd.name)) {
                deps.add((Object)new AssetDescriptor(params.material.map_Kd.path, Texture.class));
            }
            if (params.material.map_Ks != null && !params.textures.containsKey((Object)params.material.map_Ks.name)) {
                deps.add((Object)new AssetDescriptor(params.material.map_Ks.path, Texture.class));
            }
            if (params.material.map_Kn != null && !params.textures.containsKey((Object)params.material.map_Kn.name)) {
                deps.add((Object)new AssetDescriptor(params.material.map_Kn.path, Texture.class));
            }
            return deps;
        }
        MaterialLib early = this.parser.parseMtl(params.name, fileName);
        Array deps = new Array(4 * early.infos.size);
        for (ObjectMap.Entry info : early.infos) {
            if (((MaterialInfo)info.value).map_Ka != null && !params.textures.containsKey((Object)((MaterialInfo)info.value).map_Ka.name)) {
                deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Ka.path, Texture.class));
            }
            if (((MaterialInfo)info.value).map_Kd != null && !params.textures.containsKey((Object)((MaterialInfo)info.value).map_Kd.name)) {
                deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Kd.path, Texture.class));
            }
            if (((MaterialInfo)info.value).map_Ks != null && !params.textures.containsKey((Object)((MaterialInfo)info.value).map_Ks.name)) {
                deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Ks.path, Texture.class));
            }
            if (((MaterialInfo)info.value).map_Kn == null || params.textures.containsKey((Object)((MaterialInfo)info.value).map_Kn.name)) continue;
            deps.add((Object)new AssetDescriptor(((MaterialInfo)info.value).map_Kn.path, Texture.class));
        }
        return deps.size > 0 ? deps : null;
    }

    public static class MaterialLibParameters
    extends AssetLoaderParameters<MaterialLib> {
        public String name;
        public String source;
        public ObjectMap<String, String> textures;
        public MaterialInfo material;

        public MaterialLibParameters() {
            this.name = null;
            this.source = null;
            this.material = null;
            this.textures = new ObjectMap();
        }

        public MaterialLibParameters(String fileName) {
            this.name = fileName;
            this.source = fileName;
            this.material = null;
            this.textures = new ObjectMap();
        }
    }
}

