/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.JsonValueLoader;

public class JsonValueParser
implements AssetParser<JsonValue> {
    private JsonValue root;

    @Override
    public Class<JsonValue> getType() {
        return JsonValue.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.root = this.root.getChild("jsons");
    }

    @Override
    public boolean hasNext() {
        return this.root != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        if (this.root.isString()) {
            String file = this.root.asString();
            keymap.put((Object)this.root.name(), (Object)file);
            manager.load(file, JsonValue.class, null);
        } else {
            String file = "inline." + this.root.name();
            keymap.put((Object)this.root.name(), (Object)file);
            JsonValueLoader.JsonValueParameters parameters = new JsonValueLoader.JsonValueParameters();
            String s = this.root.toString();
            int pos = s.indexOf(58);
            parameters.data = pos == -1 ? s : s.substring(pos + 1);
            manager.load(file, JsonValue.class, (AssetLoaderParameters)parameters);
        }
        this.root = this.root.next();
    }

    public boolean equals(Object o) {
        return o instanceof JsonValueParser;
    }
}

