/*
 * Decompiled with CFR 0.152.
 */
package box2dLight.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public final class ShadowShader {
    public static final String TEXTURE_UNIFORM = "u_texture";
    public static final String AMBIENT_UNIFORM = "u_ambient";

    public static final ShaderProgram createShadowShader() {
        String[] vertex20 = new String[]{"attribute vec4 a_position;", "attribute vec2 a_texCoord;", "varying vec2 v_texCoords;", "", "void main() {", "   v_texCoords = a_texCoord;", "   gl_Position = a_position;", "}"};
        String[] vertex30 = new String[]{"in vec4 a_position;", "in vec2 a_texCoord;", "out vec2 v_texCoords;", "", "void main() {", "   v_texCoords = a_texCoord;", "   gl_Position = a_position;", "}"};
        String[] fragment20 = new String[]{"#ifdef GL_ES", "    precision lowp float;", "    #define MED mediump", "#else", "    #define MED ", "#endif", "varying MED vec2 v_texCoords;", "uniform sampler2D u_texture;", "uniform vec4 u_ambient;", "void main() {", "    vec4 c = texture2D(u_texture, v_texCoords);", "    gl_FragColor.rgb = c.rgb * c.a + u_ambient.rgb;", "    gl_FragColor.a = u_ambient.a - c.a;", "}"};
        String[] fragment30 = new String[]{"#ifdef GL_ES", "    precision lowp float;", "    #define MED mediump", "#else", "    #define MED ", "#endif", "out vec4 frag_color;", "in MED vec2 v_texCoords;", "uniform sampler2D u_texture;", "uniform vec4 u_ambient;", "void main() {", "    vec4 c = texture(u_texture, v_texCoords);", "    frag_color.rgb = c.rgb * c.a + u_ambient.rgb;", "    frag_color.a = u_ambient.a - c.a;", "}"};
        String[] vertSource = vertex20;
        String[] fragSource = fragment20;
        if (Gdx.gl30 != null) {
            vertSource = vertex30;
            fragSource = fragment30;
        }
        StringBuilder vstr = new StringBuilder();
        for (String s : vertSource) {
            vstr.append(s);
            vstr.append("\n");
        }
        String vertexShader = vstr.toString();
        StringBuilder fstr = new StringBuilder();
        for (String s : fragSource) {
            fstr.append(s);
            fstr.append("\n");
        }
        String fragmentShader = fstr.toString();
        ShaderProgram.pedantic = false;
        String vertPrefix = ShaderProgram.prependVertexCode;
        String fragPrefix = ShaderProgram.prependFragmentCode;
        if (Gdx.gl30 != null) {
            ShaderProgram.prependVertexCode = "#version 330 core\n";
            ShaderProgram.prependFragmentCode = "#version 330 core\n";
        }
        ShaderProgram shadowShader = new ShaderProgram(vertexShader, fragmentShader);
        if (Gdx.gl30 != null) {
            ShaderProgram.prependVertexCode = vertPrefix;
            ShaderProgram.prependFragmentCode = fragPrefix;
        }
        if (!shadowShader.isCompiled()) {
            Gdx.app.error("Shadow Shader Error", shadowShader.getLog());
        }
        return shadowShader;
    }
}

