/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.shipdemo;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteSheet;

public class Ship {
    public static final int SHIP_IMG_LEFT = 0;
    public static final int SHIP_IMG_FLAT = 9;
    public static final int SHIP_IMG_RIGHT = 17;
    private static final int SHIP_SIZE = 81;
    private static final float SHADOW_OFFSET = 10.0f;
    private static final int TARGET_SIZE = 19;
    private static final int TARGET_DIST = 100;
    private static final float THRUST_FACTOR = 0.4f;
    private static final float BANK_FACTOR = 0.5f;
    private static final float MAXIMUM_BANK = 10.0f;
    private static final float FORWARD_DAMPING = 0.9f;
    private static final float ANGULAR_DAMPING = 0.875f;
    private static final int RELOAD_RATE = 3;
    private static final float DEFAULT_SCALE = 1.0f;
    private Vector2 pos;
    private Vector2 vel;
    private Color tint;
    private Color stint;
    private float mass;
    protected Vector2 tofs;
    protected float ang;
    protected float dang;
    protected int refire;
    private Affine2 transform = new Affine2();
    private SpriteSheet shipSprite;
    private Texture targetTexture;

    public SpriteSheet getFilmStrip() {
        return this.shipSprite;
    }

    public void setFilmStrip(SpriteSheet value) {
        this.shipSprite = value;
        this.shipSprite.setFrame(9);
    }

    public Texture getTargetTexture() {
        return this.targetTexture;
    }

    public void setTargetTexture(Texture value) {
        this.targetTexture = value;
    }

    public Vector2 getPosition() {
        return this.pos;
    }

    public void setPosition(Vector2 value) {
        this.pos.set(value);
    }

    public Vector2 getVelocity() {
        return this.vel;
    }

    public void setVelocity(Vector2 value) {
        this.vel.set(value);
    }

    public float getAngle() {
        return this.ang;
    }

    public void setAngle(float value) {
        this.ang = value;
    }

    public Color getColor() {
        return this.tint;
    }

    public void setColor(Color value) {
        this.tint.set(value);
    }

    public boolean canFireWeapon() {
        return this.refire > 3;
    }

    public void reloadWeapon() {
        this.refire = 0;
    }

    public float getMass() {
        return this.mass;
    }

    public float getDiameter() {
        return 81.0f;
    }

    public Ship(float x, float y, float ang) {
        this.pos = new Vector2(x, y);
        this.ang = ang;
        this.vel = new Vector2();
        this.dang = 0.0f;
        this.mass = 1.0f;
        this.tofs = new Vector2();
        this.refire = 0;
        this.tint = new Color(Color.WHITE);
        this.stint = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    }

    public void move(float forward, float turn) {
        this.processTurn(turn);
        if (forward != 0.0f) {
            this.vel.add(forward * (float)Math.cos(Math.toRadians(this.ang)) * 0.4f, forward * (float)(-Math.sin(Math.toRadians(this.ang))) * 0.4f);
        } else {
            this.vel.scl(0.9f);
        }
        this.ang += this.dang;
        if (this.ang > 360.0f) {
            this.ang -= 360.0f;
        }
        if (this.ang < 0.0f) {
            this.ang += 360.0f;
        }
        this.pos.add(this.vel);
        if (this.refire <= 3) {
            ++this.refire;
        }
    }

    private void processTurn(float turn) {
        int frame;
        int n = frame = this.shipSprite == null ? 0 : this.shipSprite.getFrame();
        if (turn != 0.0f) {
            this.dang -= turn / 0.5f;
            if (this.dang < -10.0f) {
                this.dang = -10.0f;
            } else if (this.dang > 10.0f) {
                this.dang = 10.0f;
            }
            if (turn > 0.0f && frame < 17) {
                ++frame;
            } else if (turn < 0.0f && frame > 0) {
                --frame;
            }
        } else {
            if (this.dang != 0.0f) {
                this.dang *= 0.875f;
            }
            if (frame < 9) {
                ++frame;
            } else if (frame > 9) {
                --frame;
            }
        }
        if (this.shipSprite != null) {
            this.shipSprite.setFrame(frame);
        }
    }

    public void acquireTarget(Ship other) {
        this.tofs.set(other.pos).sub(this.pos);
        this.tofs.nor();
        this.tofs.scl(100.0f);
    }

    public void drawShip(SpriteBatch batch) {
        if (this.shipSprite == null) {
            return;
        }
        float ox = 0.5f * (float)this.shipSprite.getRegionWidth();
        float oy = 0.5f * (float)this.shipSprite.getRegionHeight();
        float rotate = -(90.0f + this.ang);
        float sx = this.pos.x + 10.0f;
        float sy = this.pos.y + 10.0f;
        SpriteBatch.computeTransform((Affine2)this.transform, (float)ox, (float)oy, (float)sx, (float)sy, (float)rotate, (float)1.0f, (float)1.0f);
        batch.setColor(this.stint);
        batch.draw((TextureRegion)this.shipSprite, this.transform);
        SpriteBatch.computeTransform((Affine2)this.transform, (float)ox, (float)oy, (float)this.pos.x, (float)this.pos.y, (float)rotate, (float)1.0f, (float)1.0f);
        batch.setColor(this.tint);
        batch.draw((TextureRegion)this.shipSprite, this.transform);
    }

    public void drawTarget(SpriteBatch batch) {
        if (this.targetTexture == null) {
            return;
        }
        float tx = this.pos.x + this.tofs.x;
        float ty = this.pos.y + this.tofs.y;
        float ox = 9.5f;
        float oy = 9.5f;
        SpriteBatch.computeTransform((Affine2)this.transform, (float)ox, (float)oy, (float)tx, (float)ty, (float)0.0f, (float)1.0f, (float)1.0f);
        batch.setColor(Color.WHITE);
        batch.draw(this.targetTexture, this.transform);
    }
}

