/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.shipdemo;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import edu.cornell.gdiac.graphics.SpriteBatch;

public class PhotonQueue {
    private static final float PHOTON_VELOCITY = 5.0f;
    private static final int MAX_AGE = 48;
    private static final int MAX_PHOTONS = 512;
    private static Texture texture;
    private Affine2 transform = new Affine2();
    protected Photon[] queue = new Photon[512];
    protected int head = 0;
    protected int tail = -1;
    protected int size = 0;

    public PhotonQueue() {
        for (int ii = 0; ii < 512; ++ii) {
            this.queue[ii] = new Photon();
        }
    }

    public Texture getTexture() {
        return texture;
    }

    public void setTexture(Texture value) {
        texture = value;
    }

    public void addPhoton(Vector2 position, Vector2 velocity, float angle) {
        float fire_x = velocity.x + (float)Math.cos(Math.toRadians(angle)) * 5.0f;
        float fire_y = velocity.y + (float)(-Math.sin(Math.toRadians(angle))) * 5.0f;
        if (this.size == 512) {
            this.head = (this.head + 1) % 512;
            --this.size;
        }
        this.tail = (this.tail + 1) % 512;
        this.queue[this.tail].allocate(position.x, position.y, fire_x, fire_y);
        ++this.size;
    }

    public void move(Rectangle bounds) {
        while (this.size > 0 && this.queue[this.head].age > 48) {
            this.head = (this.head + 1) % 512;
            --this.size;
        }
        for (int ii = 0; ii < this.size; ++ii) {
            int idx = (this.head + ii) % 512;
            this.queue[idx].move(bounds);
        }
    }

    public void draw(SpriteBatch batch) {
        if (texture == null) {
            return;
        }
        float ox = (float)texture.getWidth() / 2.0f;
        float oy = (float)texture.getHeight() / 2.0f;
        for (int ii = 0; ii < this.size; ++ii) {
            int idx = (this.head + ii) % 512;
            float scale = 1.25f - (float)this.queue[idx].age * 0.5f / 48.0f;
            SpriteBatch.computeTransform((Affine2)this.transform, (float)ox, (float)oy, (float)this.queue[idx].x, (float)this.queue[idx].y, (float)0.0f, (float)scale, (float)scale);
            batch.setColor(Color.WHITE);
            batch.draw(texture, this.transform);
        }
    }

    public class Photon {
        public float x = 0.0f;
        public float y = 0.0f;
        public float vx = 0.0f;
        public float vy = 0.0f;
        public int age = -1;

        public void allocate(float x, float y, float vx, float vy) {
            this.x = x;
            this.y = y;
            this.vx = vx;
            this.vy = vy;
            this.age = 0;
        }

        public void move(Rectangle bounds) {
            this.x += this.vx;
            this.y += this.vy;
            if (this.x <= bounds.x) {
                this.vx = -this.vx;
                this.x = bounds.x;
            } else if (this.x >= bounds.width) {
                this.vx = -this.vx;
                this.x = bounds.width - 1.0f;
            }
            if (this.y <= bounds.y) {
                this.vy = -this.vy;
                this.y = bounds.y;
            } else if (this.y >= bounds.height) {
                this.vy = -this.vy;
                this.y = bounds.height - 1.0f;
            }
            ++this.age;
        }
    }
}

