/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.shipdemo;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ScreenUtils;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.util.ScreenListener;

public class LoadingScene
implements Screen,
InputProcessor {
    private static int DEFAULT_BUDGET = 15;
    private AssetDirectory internal;
    private AssetDirectory assets;
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private Affine2 affine;
    private ScreenListener listener;
    private int width;
    private int height;
    JsonValue constants;
    private float scale;
    private float progress;
    private int pressState;
    private int budget;
    private boolean active;

    public int getBudget() {
        return this.budget;
    }

    public void setBudget(int millis) {
        this.budget = millis;
    }

    public boolean isReady() {
        return this.pressState == 2;
    }

    public AssetDirectory getAssets() {
        return this.assets;
    }

    public LoadingScene(String file) {
        this(file, DEFAULT_BUDGET);
    }

    public LoadingScene(String file, int millis) {
        this.budget = millis;
        this.internal = new AssetDirectory("loading/boot.json");
        this.internal.loadAssets();
        this.internal.finishLoading();
        this.constants = (JsonValue)this.internal.getEntry("constants", JsonValue.class);
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.progress = 0.0f;
        this.pressState = 0;
        this.affine = new Affine2();
        Gdx.input.setInputProcessor((InputProcessor)this);
        this.assets = new AssetDirectory(file);
        this.assets.loadAssets();
        this.active = true;
    }

    public void dispose() {
        this.internal.unloadAssets();
        this.internal.dispose();
    }

    public void setSpriteBatch(SpriteBatch batch) {
        this.batch = batch;
    }

    public SpriteBatch getSpriteBatch() {
        return this.batch;
    }

    private void update(float delta) {
        if (this.progress < 1.0f) {
            this.assets.update(this.budget);
            this.progress = this.assets.getProgress();
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    private void draw() {
        ScreenUtils.clear((float)0.702f, (float)0.1255f, (float)0.145f, (float)1.0f);
        this.batch.begin((Camera)this.camera);
        this.batch.setColor(Color.WHITE);
        Texture texture = (Texture)this.internal.getEntry("splash", Texture.class);
        this.batch.draw(texture, (float)((this.width - this.height) / 2), 0.0f, (float)this.height, (float)this.height);
        if (this.progress < 1.0f) {
            this.drawProgress();
        } else {
            float cx = this.width / 2;
            float cy = (int)(this.constants.getFloat("bar.height") * (float)this.height);
            float s = this.constants.getFloat("button.scale") * this.scale;
            Color tint = this.pressState == 1 ? Color.GRAY : Color.WHITE;
            texture = (Texture)this.internal.getEntry("play", Texture.class);
            SpriteBatch.computeTransform((Affine2)this.affine, (float)(texture.getWidth() / 2), (float)(texture.getHeight() / 2), (float)cx, (float)cy, (float)0.0f, (float)s, (float)s);
            this.batch.setColor(tint);
            this.batch.draw(texture, this.affine);
        }
        this.batch.end();
    }

    private void drawProgress() {
        float w = (int)(this.constants.getFloat("bar.width") * (float)this.width);
        float cx = this.width / 2;
        float cy = (int)(this.constants.getFloat("bar.height") * (float)this.height);
        this.batch.setColor(Color.WHITE);
        TextureRegion region1 = (TextureRegion)this.internal.getEntry("progress.backleft", TextureRegion.class);
        this.batch.draw(region1, cx - w / 2.0f, cy, this.scale * (float)region1.getRegionWidth(), this.scale * (float)region1.getRegionHeight());
        TextureRegion region2 = (TextureRegion)this.internal.getEntry("progress.backright", TextureRegion.class);
        this.batch.draw(region2, cx + w / 2.0f - this.scale * (float)region2.getRegionWidth(), cy, this.scale * (float)region2.getRegionWidth(), this.scale * (float)region2.getRegionHeight());
        TextureRegion region3 = (TextureRegion)this.internal.getEntry("progress.background", TextureRegion.class);
        this.batch.draw(region3, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth(), cy, w - this.scale * (float)(region2.getRegionWidth() + region1.getRegionWidth()), this.scale * (float)region3.getRegionHeight());
        region1 = (TextureRegion)this.internal.getEntry("progress.foreleft", TextureRegion.class);
        this.batch.draw(region1, cx - w / 2.0f, cy, this.scale * (float)region1.getRegionWidth(), this.scale * (float)region1.getRegionHeight());
        if (this.progress > 0.0f) {
            region2 = (TextureRegion)this.internal.getEntry("progress.foreright", TextureRegion.class);
            float span = this.progress * (w - this.scale * (float)(region1.getRegionWidth() + region2.getRegionWidth()));
            this.batch.draw(region2, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth() + span, cy, this.scale * (float)region2.getRegionWidth(), this.scale * (float)region2.getRegionHeight());
            region3 = (TextureRegion)this.internal.getEntry("progress.foreground", TextureRegion.class);
            this.batch.draw(region3, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth(), cy, span, this.scale * (float)region3.getRegionHeight());
        } else {
            region2 = (TextureRegion)this.internal.getEntry("progress.foreright", TextureRegion.class);
            this.batch.draw(region2, cx - w / 2.0f + this.scale * (float)region1.getRegionWidth(), cy, this.scale * (float)region2.getRegionWidth(), this.scale * (float)region2.getRegionHeight());
        }
    }

    public void render(float delta) {
        if (this.active) {
            this.update(delta);
            this.draw();
            if (this.isReady() && this.listener != null) {
                this.listener.exitScreen((Screen)this, 0);
            }
        }
    }

    public void resize(int width, int height) {
        this.scale = (float)height / this.constants.getFloat("height");
        this.width = width;
        this.height = height;
        if (this.camera == null) {
            this.camera = new OrthographicCamera((float)width, (float)height);
        } else {
            this.camera.setToOrtho(false, (float)width, (float)height);
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void show() {
        this.active = true;
    }

    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        float s;
        float radius;
        if (this.progress < 1.0f || this.pressState == 2) {
            return true;
        }
        float cx = this.width / 2;
        float cy = (int)(this.constants.getFloat("bar.height") * (float)this.height);
        float dist = ((float)screenX - cx) * ((float)screenX - cx) + ((float)(screenY = this.height - screenY) - cy) * ((float)screenY - cy);
        if (dist < (radius = (s = this.constants.getFloat("button.scale") * this.scale) * (float)((Texture)this.internal.getEntry("play", Texture.class)).getWidth() / 2.0f) * radius) {
            this.pressState = 1;
        }
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.pressState == 1) {
            this.pressState = 2;
            return false;
        }
        return true;
    }

    public boolean keyDown(int keycode) {
        return true;
    }

    public boolean keyTyped(char character) {
        return true;
    }

    public boolean keyUp(int keycode) {
        return true;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return true;
    }

    public boolean scrolled(float dx, float dy) {
        return true;
    }

    public boolean touchCancelled(int screenX, int screenY, int pointer, int button) {
        return true;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return true;
    }
}

