/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.shipdemo;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import edu.cornell.gdiac.util.Controllers;
import edu.cornell.gdiac.util.XBoxController;

public class InputController {
    protected int player;
    protected XBoxController xbox;
    private float forward;
    private float turning;
    private boolean pressedFire;
    private boolean quitGame;

    public float getForward() {
        return this.forward;
    }

    public float getTurn() {
        return this.turning;
    }

    public boolean didPressFire() {
        return this.pressedFire;
    }

    public boolean didQuitGame() {
        return this.quitGame;
    }

    public InputController(int id) {
        this.player = id;
        Array controllers = Controllers.get().getXBoxControllers();
        this.xbox = controllers.size > id ? (XBoxController)controllers.get(id) : null;
    }

    public void sync() {
        if (this.xbox != null) {
            this.forward = -this.xbox.getLeftY();
            this.forward = (double)this.forward < 0.1 && (double)this.forward > -0.1 ? 0.0f : this.forward;
            this.turning = -this.xbox.getRightX();
            this.turning = (double)this.turning < 0.1 && (double)this.turning > -0.1 ? 0.0f : this.turning;
            this.pressedFire = this.xbox.getRightTrigger() > 0.6f;
            this.quitGame = this.xbox.getBack();
        } else {
            int shoot;
            int right;
            int left;
            int down;
            int up;
            if (this.player == 0) {
                up = 19;
                down = 20;
                left = 21;
                right = 22;
                shoot = 62;
            } else {
                up = 51;
                down = 47;
                left = 29;
                right = 32;
                shoot = 52;
            }
            this.turning = 0.0f;
            this.forward = 0.0f;
            this.pressedFire = false;
            if (Gdx.input.isKeyPressed(up) && !Gdx.input.isKeyPressed(down)) {
                this.forward = 1.0f;
            } else if (Gdx.input.isKeyPressed(down) && !Gdx.input.isKeyPressed(up)) {
                this.forward = -1.0f;
            }
            if (Gdx.input.isKeyPressed(left) && !Gdx.input.isKeyPressed(right)) {
                this.turning = 1.0f;
            } else if (Gdx.input.isKeyPressed(right) && !Gdx.input.isKeyPressed(left)) {
                this.turning = -1.0f;
            }
            if (Gdx.input.isKeyPressed(shoot)) {
                this.pressedFire = true;
            }
            if (Gdx.input.isKeyPressed(111)) {
                this.quitGame = true;
            }
        }
    }
}

