/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.shipdemo;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.ScreenUtils;
import edu.cornell.cis3152.shipdemo.CollisionController;
import edu.cornell.cis3152.shipdemo.InputController;
import edu.cornell.cis3152.shipdemo.PhotonQueue;
import edu.cornell.cis3152.shipdemo.Ship;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteSheet;
import edu.cornell.gdiac.util.ScreenListener;

public class GameScene
implements Screen {
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private ScreenListener listener;
    private int width;
    private int height;
    protected InputController blueController;
    protected InputController redController;
    protected CollisionController physicsController;
    private Texture background;
    private Sound blueSound;
    private Sound redSound;
    protected Ship shipBlue;
    protected Ship shipRed;
    protected PhotonQueue photons;
    private Rectangle bounds;
    private boolean active;

    public GameScene(AssetDirectory assets, SpriteBatch batch) {
        this.batch = batch;
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.background = (Texture)assets.getEntry("background", Texture.class);
        this.photons = new PhotonQueue();
        this.photons.setTexture((Texture)assets.getEntry("photon", Texture.class));
        this.blueSound = (Sound)assets.getEntry("laser", SoundEffect.class);
        this.redSound = (Sound)assets.getEntry("fusion", SoundEffect.class);
        SpriteSheet shipSprite = (SpriteSheet)assets.getEntry("ship.animation", SpriteSheet.class);
        Texture targetTexture = (Texture)assets.getEntry("target", Texture.class);
        this.shipRed = new Ship((float)this.width * 0.33333334f, (float)this.height * 0.5f, 0.0f);
        this.shipRed.setFilmStrip(new SpriteSheet(shipSprite));
        this.shipRed.setTargetTexture(targetTexture);
        this.shipRed.setColor(new Color(1.0f, 0.25f, 0.25f, 1.0f));
        this.shipBlue = new Ship((float)this.width * 0.6666667f, (float)this.height * 0.5f, 180.0f);
        this.shipBlue.setFilmStrip(new SpriteSheet(shipSprite));
        this.shipBlue.setTargetTexture(targetTexture);
        this.shipBlue.setColor(new Color(0.5f, 0.5f, 1.0f, 1.0f));
        this.redController = new InputController(1);
        this.blueController = new InputController(0);
        this.physicsController = new CollisionController();
    }

    public void update(float dt) {
        this.redController.sync();
        this.blueController.sync();
        if (this.redController.didPressFire() && this.firePhoton(this.shipRed, this.photons)) {
            this.redSound.play();
        }
        if (this.blueController.didPressFire() && this.firePhoton(this.shipBlue, this.photons)) {
            this.blueSound.play();
        }
        this.shipRed.move(this.redController.getForward(), this.redController.getTurn());
        this.shipBlue.move(this.blueController.getForward(), this.blueController.getTurn());
        this.photons.move(this.bounds);
        this.shipRed.acquireTarget(this.shipBlue);
        this.shipBlue.acquireTarget(this.shipRed);
        this.physicsController.checkForCollision(this.shipBlue, this.shipRed);
        this.physicsController.checkInBounds(this.shipBlue, this.bounds);
        this.physicsController.checkInBounds(this.shipRed, this.bounds);
    }

    public void draw(float dt) {
        ScreenUtils.clear((Color)Color.BLACK);
        this.batch.begin((Camera)this.camera);
        this.batch.setBlendMode(SpriteBatch.BlendMode.ALPHA_BLEND);
        this.batch.draw(this.background, 0.0f, 0.0f, (float)this.width, (float)this.height);
        this.shipBlue.drawShip(this.batch);
        this.shipRed.drawShip(this.batch);
        this.batch.setBlendMode(SpriteBatch.BlendMode.ADDITIVE);
        this.shipBlue.drawTarget(this.batch);
        this.shipRed.drawTarget(this.batch);
        this.photons.draw(this.batch);
        this.batch.end();
    }

    public void dispose() {
    }

    private boolean firePhoton(Ship ship, PhotonQueue photons) {
        if (ship.canFireWeapon()) {
            photons.addPhoton(ship.getPosition(), ship.getVelocity(), ship.getAngle());
            ship.reloadWeapon();
            return true;
        }
        return false;
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.bounds == null) {
            this.bounds = new Rectangle(0.0f, 0.0f, (float)width, (float)height);
        } else {
            this.bounds.set(0.0f, 0.0f, (float)width, (float)height);
        }
        if (this.camera == null) {
            this.camera = new OrthographicCamera((float)width, (float)height);
        } else {
            this.camera.setToOrtho(false, (float)width, (float)height);
        }
    }

    public void render(float delta) {
        if (this.active) {
            this.update(delta);
            this.draw(delta);
            if (this.listener != null) {
                boolean exit = this.redController.didQuitGame();
                boolean bl = exit = exit || this.blueController.didQuitGame();
                if (exit) {
                    this.listener.exitScreen((Screen)this, 0);
                }
            }
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void show() {
        this.active = true;
    }

    public void hide() {
        this.active = false;
    }

    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }
}

