/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.shipdemo;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import edu.cornell.cis3152.shipdemo.GameScene;
import edu.cornell.cis3152.shipdemo.LoadingScene;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.util.ScreenListener;

public class GDXRoot
extends Game
implements ScreenListener {
    AssetDirectory directory;
    SpriteBatch batch;
    LoadingScene loading;
    GameScene playing;

    public void create() {
        this.loading = new LoadingScene("assets.json", 1);
        this.batch = new SpriteBatch();
        this.loading.setSpriteBatch(this.batch);
        this.loading.setScreenListener(this);
        this.setScreen(this.loading);
    }

    public void dispose() {
        this.setScreen(null);
        if (this.loading != null) {
            this.loading.dispose();
            this.loading = null;
        }
        if (this.playing != null) {
            this.playing.dispose();
            this.playing = null;
        }
        this.batch.dispose();
        this.batch = null;
        if (this.directory != null) {
            this.directory.unloadAssets();
            this.directory.dispose();
            this.directory = null;
        }
        super.dispose();
    }

    public void resize(int width, int height) {
        if (this.loading != null) {
            this.loading.resize(width, height);
        }
        if (this.playing != null) {
            this.playing.resize(width, height);
        }
        super.resize(width, height);
    }

    public void exitScreen(Screen screen, int exitCode) {
        if (screen == this.loading) {
            this.playing = new GameScene(this.loading.getAssets(), this.batch);
            this.setScreen(this.playing);
            this.loading.dispose();
            this.loading = null;
        } else {
            Gdx.app.exit();
        }
    }
}

