/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.shipdemo;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import edu.cornell.cis3152.shipdemo.Ship;

public class CollisionController {
    public static final float COLLISION_COEFF = 0.1f;
    private Vector2 normal;
    private Vector2 velocity = new Vector2();
    private Vector2 temp;

    public CollisionController() {
        this.normal = new Vector2();
        this.temp = new Vector2();
    }

    public void checkForCollision(Ship ship1, Ship ship2) {
        this.normal.set(ship1.getPosition()).sub(ship2.getPosition());
        float distance = this.normal.len();
        float impactDistance = (ship1.getDiameter() + ship2.getDiameter()) / 2.0f;
        this.normal.nor();
        if (distance < impactDistance) {
            this.temp.set(this.normal).scl((impactDistance - distance) / 2.0f);
            ship1.getPosition().add(this.temp);
            this.temp.set(this.normal).scl((impactDistance - distance) / 2.0f);
            ship2.getPosition().sub(this.temp);
            this.velocity.set(ship1.getVelocity()).sub(ship2.getVelocity());
            float impulse = -1.1f * this.normal.dot(this.velocity) / (this.normal.dot(this.normal) * (1.0f / ship1.getMass() + 1.0f / ship2.getMass()));
            this.temp.set(this.normal).scl(impulse / ship1.getMass());
            ship1.getVelocity().add(this.temp);
            this.temp.set(this.normal).scl(impulse / ship2.getMass());
            ship2.getVelocity().sub(this.temp);
        }
    }

    public void checkInBounds(Ship ship, Rectangle bounds) {
        if (ship.getPosition().x <= bounds.x) {
            ship.getVelocity().x = -ship.getVelocity().x;
            ship.getPosition().x = bounds.x;
        } else if (ship.getPosition().x >= bounds.width) {
            ship.getVelocity().x = -ship.getVelocity().x;
            ship.getPosition().x = bounds.width - 1.0f;
        }
        if (ship.getPosition().y <= bounds.y) {
            ship.getVelocity().y = -ship.getVelocity().y;
            ship.getPosition().y = bounds.y;
        } else if (ship.getPosition().y >= bounds.height) {
            ship.getVelocity().y = -ship.getVelocity().y;
            ship.getPosition().y = bounds.height - 1.0f;
        }
    }
}

