/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.physics2;

import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import edu.cornell.gdiac.math.PathFactory;
import edu.cornell.gdiac.physics2.Obstacle;

public class WheelObstacle
extends Obstacle {
    protected CircleShape shape;
    private Fixture geometry;
    private float radius;
    private float tolerance = 0.05f;

    public float getRadius() {
        return this.shape.getRadius();
    }

    public void setRadius(float value) {
        if (this.shape == null) {
            this.shape = new CircleShape();
        }
        this.shape.setRadius(value);
        this.radius = value;
        this.markDirty(true);
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(float tolerance) {
        this.tolerance = tolerance;
        PathFactory pather = new PathFactory();
        pather.setTolerance(tolerance);
        this.outline = pather.makeCircle(0.0f, 0.0f, this.radius);
    }

    public WheelObstacle() {
        this(0.0f, 0.0f, 0.0f);
    }

    public WheelObstacle(float radius) {
        this(0.0f, 0.0f, radius);
    }

    public WheelObstacle(float x, float y, float radius) {
        super(x, y);
        if (radius > 0.0f) {
            this.shape = new CircleShape();
            this.radius = radius;
            this.shape.setRadius(radius);
            PathFactory pather = new PathFactory();
            pather.setTolerance(this.tolerance);
            this.outline = pather.makeCircle(0.0f, 0.0f, radius);
        }
    }

    @Override
    protected void createFixtures() {
        if (this.body == null || this.shape == null) {
            return;
        }
        this.releaseFixtures();
        this.fixture.shape = this.shape;
        this.geometry = this.body.createFixture(this.fixture);
        this.markDirty(false);
    }

    @Override
    protected void releaseFixtures() {
        if (this.geometry != null) {
            this.body.destroyFixture(this.geometry);
            this.geometry = null;
        }
    }
}

