/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.BooleanArray;
import com.badlogic.gdx.utils.FloatArray;

public class Spline2 {
    private int size;
    private FloatArray points;
    public BooleanArray smooth;
    public boolean closed;
    private final int MAX_DEPTH = 8;
    private final float SMOOTH_TOLERANCE = 1.0E-4f;
    private Vector2 temp0 = new Vector2();
    private Vector2 temp1 = new Vector2();
    private Vector2 temp2 = new Vector2();
    private float[] left = new float[4];
    private float[] rght = new float[4];

    public Spline2() {
        this.points = new FloatArray();
        this.smooth = new BooleanArray();
        this.closed = false;
        this.size = 0;
    }

    public Spline2(Vector2 point) {
        this(point.x, point.y);
    }

    public Spline2(float x, float y) {
        this.points = new FloatArray(2);
        this.smooth = new BooleanArray(1);
        this.points.items[0] = x;
        this.points.items[1] = y;
        this.points.size = 2;
        this.smooth.items[0] = false;
        this.smooth.size = 1;
        this.closed = false;
        this.size = 0;
    }

    public Spline2(Vector2 start, Vector2 end) {
        this(start.x, start.y, end.x, end.y);
    }

    public Spline2(float sx, float sy, float ex, float ey) {
        this.points = new FloatArray(8);
        this.smooth = new BooleanArray(2);
        this.points.items[0] = sx;
        this.points.items[1] = sy;
        this.points.items[2] = sx;
        this.points.items[3] = sy;
        this.points.items[4] = ex;
        this.points.items[5] = ey;
        this.points.items[6] = ex;
        this.points.items[7] = ey;
        this.points.size += 8;
        this.smooth.items[0] = false;
        this.smooth.items[1] = false;
        this.smooth.size += 2;
        this.closed = sx == ex && sy == ey;
        this.size = 1;
    }

    public Spline2(float[] points) {
        this(points, 0, points.length);
    }

    public Spline2(float[] points, int poff, int psize) {
        if (psize / 2 % 3 != 1) {
            throw new IllegalArgumentException("Control point array is the wrong size.");
        }
        this.size = (psize / 2 - 1) / 3;
        this.closed = false;
        this.points = new FloatArray(psize);
        this.points.addAll(points, poff, psize);
        this.smooth = new BooleanArray(this.size + 1);
        this.smooth.items[0] = false;
        for (int i = 1; i < this.size; ++i) {
            this.smooth.items[i] = this.checkSmooth(i);
        }
        this.smooth.items[this.size] = false;
        this.smooth.size = this.size + 1;
    }

    public Spline2(Spline2 spline) {
        this.size = spline.size;
        this.closed = spline.closed;
        this.points = new FloatArray(spline.points);
        this.smooth = new BooleanArray(spline.smooth);
    }

    public Spline2 set(Vector2 point) {
        return this.set(point.x, point.y);
    }

    public Spline2 set(float x, float y) {
        this.points.clear();
        this.points.ensureCapacity(2);
        this.points.items[0] = x;
        this.points.items[1] = y;
        this.points.size = 2;
        this.smooth.clear();
        this.smooth.ensureCapacity(1);
        this.smooth.items[0] = false;
        this.smooth.size = 1;
        this.closed = false;
        this.size = 0;
        return this;
    }

    public Spline2 set(Vector2 start, Vector2 end) {
        return this.set(start.x, start.y, end.x, end.y);
    }

    public Spline2 set(float sx, float sy, float ex, float ey) {
        this.points.clear();
        this.points.ensureCapacity(8);
        this.smooth.clear();
        this.smooth.ensureCapacity(2);
        this.points.items[0] = sx;
        this.points.items[1] = sy;
        this.points.items[2] = sx;
        this.points.items[3] = sy;
        this.points.items[4] = ex;
        this.points.items[5] = ey;
        this.points.items[6] = ex;
        this.points.items[7] = ey;
        this.points.size += 8;
        this.smooth.items[0] = false;
        this.smooth.items[1] = false;
        this.smooth.size += 2;
        this.closed = sx == ex && sy == ey;
        this.size = 1;
        return this;
    }

    public Spline2 set(float[] points) {
        return this.set(points, 0, points.length);
    }

    public Spline2 set(float[] points, int poff, int psize) {
        if (psize / 2 % 3 != 1) {
            throw new IllegalArgumentException("Control point array is the wrong size.");
        }
        this.size = (psize / 2 - 1) / 3;
        this.closed = false;
        this.points.clear();
        this.points.addAll(points, poff, psize);
        this.smooth.clear();
        this.smooth.ensureCapacity(this.size + 1);
        this.smooth.items[0] = false;
        for (int i = 1; i < this.size; ++i) {
            this.smooth.items[i] = this.checkSmooth(i);
        }
        this.smooth.items[this.size] = false;
        this.smooth.size = this.size + 1;
        return this;
    }

    public Spline2 set(Spline2 spline) {
        this.size = spline.size;
        this.closed = spline.closed;
        this.points.clear();
        this.points.addAll(spline.points);
        this.smooth.clear();
        this.smooth.addAll(spline.smooth);
        return this;
    }

    public void setClosed(boolean flag) {
        if (this.points.size == 0) {
            return;
        }
        if (flag && !this.closed) {
            if (this.points.items[0] != this.points.items[this.points.size - 2] || this.points.items[1] != this.points.items[this.points.size - 1]) {
                this.addAnchor(this.points.items[0], this.points.items[1]);
            }
        } else if (!flag && this.closed) {
            this.deleteAnchor(this.size);
        }
        this.closed = flag;
    }

    public int size() {
        return this.size;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private Vector2 getPoint(int segment, float tp) {
        return this.getPoint(segment, tp, null);
    }

    private Vector2 getPoint(int segment, float tp, Vector2 point) {
        if (segment < 0 || segment >= this.size) {
            throw new IllegalArgumentException("Illegal spline segment");
        }
        if (!(tp >= 0.0f) || !(tp <= 1.0f)) {
            throw new IllegalArgumentException("Illegal segment parameter");
        }
        int index = 3 * segment;
        float sp = 1.0f - tp;
        float a = sp * sp;
        float d = tp * tp;
        float b = 3.0f * tp * a;
        float c = 3.0f * sp * d;
        float x = (a *= sp) * this.points.items[index * 2] + b * this.points.items[index * 2 + 2] + c * this.points.items[index * 2 + 4] + (d *= tp) * this.points.items[index * 2 + 6];
        float y = a * this.points.items[index * 2 + 1] + b * this.points.items[index * 2 + 3] + c * this.points.items[index * 2 + 5] + d * this.points.items[index * 2 + 7];
        if (point == null) {
            point = new Vector2(x, y);
        } else {
            point.set(x, y);
        }
        return point;
    }

    public Vector2 getPoint(float tp) {
        return this.getPoint((int)tp, tp - (float)((int)tp));
    }

    public Vector2 getPoint(float tp, Vector2 point) {
        return this.getPoint((int)tp, tp - (float)((int)tp), point);
    }

    public void setPoint(float tp, Vector2 point) {
        this.setPoint(tp, point.x, point.y);
    }

    public void setPoint(float tp, float x, float y) {
        if (!(tp >= 0.0f) || !(tp <= (float)this.size)) {
            throw new IllegalArgumentException("Parameter out of bounds");
        }
        if (this.closed && !(tp < (float)this.size)) {
            throw new IllegalArgumentException("Parameter out of bounds for closed spline");
        }
        int seg = (int)tp;
        if ((float)seg == tp) {
            this.setAnchor(seg, x, y);
        } else {
            this.insertAnchor(seg, tp -= (float)seg);
            this.setAnchor(seg + 1, x, y);
        }
    }

    public void setAnchor(int index, Vector2 point) {
        this.setAnchor(index, point.x, point.y);
    }

    public void setAnchor(int index, float x, float y) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (this.closed && index >= this.size) {
            throw new IllegalArgumentException("Index out of bounds for closed spline");
        }
        float dx = x - this.points.items[6 * index];
        float dy = y - this.points.items[6 * index + 1];
        if (index > 0) {
            int n = 3 * index * 2 - 2;
            this.points.items[n] = this.points.items[n] + dx;
            int n2 = 3 * index * 2 - 1;
            this.points.items[n2] = this.points.items[n2] + dy;
        } else if (this.closed) {
            int n = 3 * this.size * 2 - 2;
            this.points.items[n] = this.points.items[n] + dx;
            int n3 = 3 * this.size * 2 - 1;
            this.points.items[n3] = this.points.items[n3] + dy;
        }
        if (index < this.size) {
            int n = 3 * index * 2 + 1;
            this.points.items[n] = this.points.items[n] + dx;
            int n4 = 3 * index * 2 + 2;
            this.points.items[n4] = this.points.items[n4] + dy;
        } else if (this.closed) {
            this.points.items[2] = this.points.items[2] + dx;
            this.points.items[3] = this.points.items[3] + dy;
        }
        this.points.items[3 * index * 2] = x;
        this.points.items[3 * index * 2 + 1] = y;
    }

    public boolean isSmooth(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (this.closed && index > this.size - 1) {
            throw new IllegalArgumentException("Index out of bounds for closed spline");
        }
        return this.smooth.items[index];
    }

    public void setSmooth(int index, boolean flag) {
        if (this.closed && index >= this.size) {
            throw new IllegalArgumentException("Index out of bounds for closed spline");
        }
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (!(this.closed || index > 0 && index < this.size)) {
            throw new IllegalArgumentException("End point smoothness cannot be changed");
        }
        this.smooth.items[index] = flag;
        if (flag) {
            int rindx = index == 0 && this.closed ? this.size : index;
            this.temp0.set(this.points.items[3 * rindx * 2 - 2] - this.points.items[3 * index * 2], this.points.items[3 * rindx * 2 - 1] - this.points.items[3 * index * 2 + 1]);
            this.temp1.set(this.points.items[3 * index * 2] - this.points.items[3 * index * 2 + 2], this.points.items[3 * index * 2 + 1] - this.points.items[3 * index * 2 + 3]);
            if (this.temp0.isZero()) {
                this.temp0 = this.temp1;
            } else if (this.temp1.isZero()) {
                this.temp1 = this.temp0;
            } else {
                float scale0 = this.temp0.len();
                float scale1 = this.temp1.len();
                this.temp0 = this.temp0.nor();
                this.temp1 = this.temp1.nor();
                this.temp2.set((this.temp0.x + this.temp1.x) / 2.0f, (this.temp0.y + this.temp1.y) / 2.0f);
                this.temp2 = this.temp2.nor();
                this.temp0.set(this.temp2);
                this.temp0.scl(scale0);
                this.temp1.set(this.temp2);
                this.temp1.scl(scale1);
            }
            this.points.items[3 * rindx * 2 - 2] = this.points.items[3 * index * 2] + this.temp0.x;
            this.points.items[3 * rindx * 2 - 1] = this.points.items[3 * index * 2 + 1] + this.temp0.y;
            this.points.items[3 * index * 2 + 1] = this.points.items[3 * index * 2] - this.temp1.x;
            this.points.items[3 * index * 2 + 2] = this.points.items[3 * index * 2 + 1] - this.temp1.y;
        }
    }

    public Vector2 getTangent(int index) {
        return this.getTangent(index, null);
    }

    public Vector2 getTangent(int index, Vector2 point) {
        int tangt;
        if (index < 0 || index >= 2 * this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        int spline = (index + 1) / 2;
        int anchor = 3 * spline;
        int n = tangt = index % 2 == 1 ? anchor - 1 : anchor + 1;
        if (point == null) {
            point = new Vector2(this.points.items[tangt * 2], this.points.items[tangt * 2 + 1]);
        } else {
            point.set(this.points.items[tangt * 2], this.points.items[tangt * 2 + 1]);
        }
        return point;
    }

    public void setTangent(int index, Vector2 tang, boolean symmetric) {
        this.setTangent(index, tang.x, tang.y, symmetric);
    }

    public void setTangent(int index, float x, float y, boolean symmetric) {
        int tangt2;
        if (index < 0 || index >= 2 * this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        int spline = (index + 1) / 2;
        int anchor = 3 * spline;
        int tangt1 = index % 2 == 1 ? anchor - 1 : anchor + 1;
        int n = tangt2 = index % 2 == 1 ? anchor + 1 : anchor - 1;
        if (spline == 0) {
            tangt2 = this.closed ? 3 * this.size - 1 : -1;
        } else if (spline == this.size) {
            int n2 = tangt2 = this.closed ? 1 : -1;
        }
        if (symmetric && tangt2 != -1) {
            this.points.items[tangt2 * 2] = this.points.items[anchor * 2] + this.points.items[anchor * 2] - x;
            this.points.items[tangt2 * 2 + 1] = this.points.items[anchor * 2 + 1] + this.points.items[anchor * 2 + 1] - y;
        } else if (this.smooth.items[spline] && tangt2 != -1) {
            this.temp0.set(this.points.items[anchor * 2] - this.points.items[tangt2 * 2], this.points.items[anchor * 2 + 1] - this.points.items[tangt2 * 2 + 1]);
            float d = this.temp0.len();
            this.temp0.set(this.points.items[anchor * 2] - x, this.points.items[anchor * 2 + 1] - y);
            this.temp0 = this.temp0.nor();
            this.temp0.scl(d);
            this.points.items[tangt2 * 2] = this.points.items[anchor * 2] + this.temp0.x;
            this.points.items[tangt2 * 2 + 1] = this.points.items[anchor * 2 + 1] + this.temp0.y;
        }
        this.points.items[tangt1 * 2] = x;
        this.points.items[tangt1 * 2 + 1] = y;
    }

    public FloatArray getControlPoints() {
        return this.points;
    }

    public int addAnchor(Vector2 point, Vector2 tang) {
        return this.addAnchor(point.x, point.y, tang.x, tang.y);
    }

    public int addAnchor(float px, float py, float tx, float ty) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot append to closed curve");
        }
        if (this.points.size == 0) {
            this.set(px, py);
        } else {
            int poff = this.points.size;
            this.points.ensureCapacity(6);
            int soff = this.smooth.size++;
            this.smooth.ensureCapacity(1);
            this.smooth.items[soff] = false;
            int pos = 3 * this.size + 1;
            if (this.smooth.items[this.size]) {
                this.points.items[poff] = this.points.items[(pos - 1) * 2] * 2.0f - this.points.items[(pos - 2) * 2];
                this.points.items[poff + 1] = this.points.items[(pos - 1) * 2 + 1] * 2.0f - this.points.items[(pos - 2) * 2 + 1];
            } else {
                this.points.items[poff] = this.points.items[(pos - 1) * 2];
                this.points.items[poff + 1] = this.points.items[(pos - 1) * 2 + 1];
            }
            this.points.items[poff + 2] = tx;
            this.points.items[poff + 3] = ty;
            this.points.items[poff + 4] = px;
            this.points.items[poff + 5] = py;
            this.points.size += 6;
            ++this.size;
        }
        return this.size;
    }

    public int addAnchor(Vector2 point) {
        return this.addAnchor(point.x, point.y, point.x, point.y);
    }

    public int addAnchor(float x, float y) {
        return this.addAnchor(x, y, x, y);
    }

    public int addBezier(Vector2 control1, Vector2 control2, Vector2 point) {
        return this.addBezier(control1.x, control1.y, control2.x, control2.y, point.x, point.y);
    }

    public int addBezier(float c1x, float c1y, float c2x, float c2y, float px, float py) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot append to closed curve");
        }
        if (this.points.size == 0) {
            this.set(0.0f, 0.0f);
        }
        int poff = this.points.size;
        int soff = this.smooth.size++;
        this.points.ensureCapacity(6);
        this.smooth.ensureCapacity(1);
        this.smooth.items[soff] = false;
        this.points.items[poff++] = c1x;
        this.points.items[poff++] = c1y;
        this.points.items[poff++] = c2x;
        this.points.items[poff++] = c2y;
        this.points.items[poff++] = px;
        this.points.items[poff++] = py;
        this.points.size += 6;
        ++this.size;
        return this.size;
    }

    public int addQuad(Vector2 control, Vector2 point) {
        return this.addQuad(control.x, control.y, point.x, point.y);
    }

    public int addQuad(float cx, float cy, float px, float py) {
        if (this.closed) {
            throw new IllegalArgumentException("Cannot append to closed curve");
        }
        if (this.points.size == 0) {
            this.set(0.0f, 0.0f);
        }
        int poff = this.points.size;
        int soff = this.smooth.size++;
        this.points.ensureCapacity(6);
        this.smooth.ensureCapacity(1);
        this.smooth.items[soff] = false;
        int idx = poff;
        this.points.items[idx++] = this.points.items[poff - 2] + 0.6666667f * (cx - this.points.items[poff - 2]);
        this.points.items[idx++] = this.points.items[poff - 1] + 0.6666667f * (cy - this.points.items[poff - 1]);
        this.points.items[idx++] = px + 0.6666667f * (cx - px);
        this.points.items[idx++] = py + 0.6666667f * (cy - py);
        this.points.items[idx++] = px;
        this.points.items[idx++] = py;
        this.points.size += 6;
        ++this.size;
        return this.size;
    }

    public void deleteAnchor(int index) {
        if (this.closed && index > this.size) {
            throw new IllegalArgumentException("Index out of bounds for closed spline");
        }
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (index == this.size && !this.closed) {
            this.points.size -= 6;
            --this.smooth.size;
        } else {
            this.points.removeRange(3 * index * 2, 3 * index * 2 + 5);
            this.smooth.removeIndex(index);
        }
        --this.size;
    }

    private void insertAnchor(int segment, float param) {
        int ii;
        if (segment < 0 || segment > this.size) {
            throw new IllegalArgumentException("Illegal spline segment");
        }
        if (param <= 0.0f || param >= 1.0f) {
            throw new IllegalArgumentException("Illegal insertion parameter");
        }
        this.subdivide(segment, param);
        this.points.ensureCapacity(6);
        this.smooth.ensureCapacity(1);
        this.smooth.insert(segment, true);
        this.points.insertRange(3 * segment, 6);
        int offset = 3 * segment;
        for (ii = 0; ii < this.left.length; ++ii) {
            this.points.items[offset++] = this.left[ii];
        }
        offset = 3 * (segment + 1);
        for (ii = 0; ii < this.rght.length; ++ii) {
            this.points.items[offset++] = this.rght[ii];
        }
        ++this.size;
    }

    public void insertAnchor(float param) {
        this.insertAnchor((int)param, param - (float)((int)param));
    }

    public Vector2 nearestPoint(Vector2 point) {
        return this.getPoint(this.nearestParameter(point));
    }

    public Vector2 nearestPoint(Vector2 point, Vector2 result) {
        return this.getPoint(this.nearestParameter(point), result);
    }

    public float nearestParameter(Vector2 point) {
        return this.nearestParameter(point.x, point.y);
    }

    public float nearestParameter(float x, float y) {
        float tmin = -1.0f;
        float dmin = -1.0f;
        int smin = -1;
        for (int i = 0; i < this.size; ++i) {
            Vector2 pair = this.getProjectionSlow(i, x, y);
            if (smin != -1 && !(pair.y < dmin)) continue;
            tmin = pair.x;
            dmin = pair.y;
            smin = i;
        }
        return (float)smin + tmin;
    }

    public int nearestAnchor(Vector2 point, float threshold) {
        return this.nearestAnchor(point.x, point.y, threshold);
    }

    public int nearestAnchor(float x, float y, float threshold) {
        float best = 2.1474836E9f;
        int index = -1;
        for (int i = 0; i <= this.size; ++i) {
            float tx = this.points.items[3 * i * 2] - x;
            float ty = this.points.items[3 * i * 2 + 1] - y;
            float d = tx * tx + ty * ty;
            if (!(d < threshold) || !(d < best)) continue;
            best = d;
            index = i;
        }
        return index;
    }

    public int nearestTangent(Vector2 point, float threshold) {
        return this.nearestTangent(point.x, point.y, threshold);
    }

    public int nearestTangent(float x, float y, float threshold) {
        float best = 2.1474836E9f;
        int index = -1;
        for (int i = 0; i < this.size; ++i) {
            float tx = this.points.items[(3 * i + 1) * 2] - x;
            float ty = this.points.items[(3 * i + 1) * 2 + 1] - y;
            float d = tx * tx + ty * ty;
            if (d < threshold && d < best) {
                best = d;
                index = 2 * i + 1;
            }
            if (!((d = (tx = this.points.items[(3 * i + 2) * 2] - x) * tx + (ty = this.points.items[(3 * i + 2) * 2 + 1] - y) * ty) < threshold) || !(d < best)) continue;
            best = d;
            index = 2 * i + 2;
        }
        return index;
    }

    public void clear() {
        this.points.clear();
        this.smooth.clear();
        this.closed = false;
        this.size = 0;
    }

    private void subdivide(int segment, float tp) {
        float src0x = this.points.items[2 * segment * 3];
        float src0y = this.points.items[2 * segment * 3 + 1];
        float src1x = this.points.items[2 * segment * 3 + 2];
        float src1y = this.points.items[2 * segment * 3 + 3];
        float src2x = this.points.items[2 * segment * 3 + 4];
        float src2y = this.points.items[2 * segment * 3 + 5];
        float src3x = this.points.items[2 * segment * 3 + 6];
        float src3y = this.points.items[2 * segment * 3 + 7];
        float hx = (1.0f - tp) * src1x + tp * src2x;
        float hy = (1.0f - tp) * src1y + tp * src2y;
        float[] result = new float[16];
        this.left[0] = src0x;
        this.left[1] = src0y;
        this.left[2] = (1.0f - tp) * src0x + tp * src1x;
        this.left[3] = (1.0f - tp) * src0y + tp * src1y;
        this.left[4] = (1.0f - tp) * this.left[2] + tp * hx;
        this.left[5] = (1.0f - tp) * this.left[3] + tp * hy;
        this.rght[7] = src3y;
        this.rght[6] = src3x;
        this.rght[5] = (1.0f - tp) * src2y + tp * src3y;
        this.rght[4] = (1.0f - tp) * src2x + tp * src3x;
        this.rght[3] = (1.0f - tp) * hy + tp * this.rght[5];
        this.rght[2] = (1.0f - tp) * hx + tp * this.rght[4];
        this.rght[1] = (1.0f - tp) * this.left[5] + tp * this.rght[3];
        this.rght[0] = (1.0f - tp) * this.left[4] + tp * this.rght[2];
        this.left[6] = this.rght[0];
        this.left[7] = this.rght[1];
    }

    private Vector2 getProjectionSlow(int segment, float x, float y) {
        float d;
        Vector2 result = new Vector2(-1.0f, -1.0f);
        int RESOLUTION = 256;
        for (int i = 0; i < RESOLUTION; ++i) {
            float t = (float)i / (float)RESOLUTION;
            this.getPoint(segment, t, this.temp0);
            this.temp0.sub(x, y);
            d = this.temp0.len2();
            if (result.x != -1.0f && !(d < result.y)) continue;
            result.x = t;
            result.y = d;
        }
        float tx = this.points.items[3 * this.size * 2] - x;
        float ty = this.points.items[3 * this.size * 2 + 1] - y;
        d = tx * tx + ty * ty;
        if (d < result.y) {
            result.x = 1.0f;
            result.y = d;
        }
        return result;
    }

    private boolean checkSmooth(int index) {
        this.temp0.set(this.points.items[3 * index * 2 - 2] - this.points.items[3 * index * 2], this.points.items[3 * index * 2 - 1] - this.points.items[3 * index * 2 + 1]);
        this.temp1.set(this.points.items[3 * index * 2 + 2] - this.points.items[3 * index * 2], this.points.items[3 * index * 2 + 3] - this.points.items[3 * index * 2 + 1]);
        this.temp0 = this.temp0.nor();
        this.temp1 = this.temp1.nor();
        this.temp0.sub(this.temp1);
        return this.temp0.len2() < 1.0E-4f;
    }
}

