/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntSet;

public class Path2 {
    public FloatArray vertices;
    public IntSet corners;
    public boolean closed;
    private static final float CU_MATH_EPSILON = 5.0E-4f;
    private static Vector2 temp1 = new Vector2();
    private static Vector2 temp2 = new Vector2();
    private static Vector2 temp3 = new Vector2();

    public Path2() {
        this.vertices = new FloatArray(8);
        this.corners = new IntSet(16, 0.8f);
        this.closed = false;
    }

    public Path2(float[] vertices) {
        if (vertices.length < 4) {
            throw new IllegalArgumentException("path2 must contain at least 2 points.");
        }
        this.vertices = new FloatArray(vertices);
        this.corners = new IntSet(vertices.length, 0.8f);
        this.closed = false;
    }

    public Path2(float[] vertices, int voffset, int vlength) {
        if (vlength < 4) {
            throw new IllegalArgumentException("path2 must contain at least 2 points.");
        }
        this.vertices = new FloatArray(vlength);
        this.vertices.addAll(vertices, voffset, vlength);
        this.corners = new IntSet(vlength, 0.8f);
        this.closed = false;
    }

    public Path2(Path2 path) {
        this.vertices = new FloatArray(path.vertices);
        this.corners = new IntSet(path.corners);
        this.closed = path.closed;
    }

    public Path2(Rectangle rect) {
        this.vertices = new FloatArray(8);
        this.corners = new IntSet(8, 0.8f);
        this.corners.addAll(new int[]{0, 1, 2, 3});
        this.vertices.items[0] = rect.x;
        this.vertices.items[1] = rect.y;
        this.vertices.items[2] = rect.x + rect.width;
        this.vertices.items[3] = rect.y;
        this.vertices.items[4] = rect.x + rect.width;
        this.vertices.items[5] = rect.y + rect.height;
        this.vertices.items[6] = rect.x;
        this.vertices.items[7] = rect.y + rect.height;
        this.vertices.size = 8;
        this.closed = true;
    }

    public Path2 set(float[] vertices) {
        if (vertices.length < 4) {
            throw new IllegalArgumentException("path2 must contain at least 2 points.");
        }
        this.vertices.clear();
        this.vertices.addAll(vertices);
        this.corners.clear();
        this.closed = false;
        return this;
    }

    public Path2 set(float[] vertices, int voffset, int vlength) {
        if (vlength < 4) {
            throw new IllegalArgumentException("path2 must contain at least 2 points.");
        }
        this.vertices.clear();
        this.vertices.addAll(vertices, voffset, vlength);
        this.corners.clear();
        this.closed = false;
        return this;
    }

    public Path2 set(Path2 path) {
        this.vertices.clear();
        this.vertices.addAll(path.vertices);
        this.corners.clear();
        this.corners.addAll(path.corners);
        this.closed = path.closed;
        return this;
    }

    public Path2 set(Rectangle rect) {
        this.vertices.clear();
        this.corners.clear();
        this.corners.addAll(new int[]{0, 1, 2, 3});
        this.vertices.items[0] = rect.x;
        this.vertices.items[1] = rect.y;
        this.vertices.items[2] = rect.x + rect.width;
        this.vertices.items[3] = rect.y;
        this.vertices.items[4] = rect.x + rect.width;
        this.vertices.items[5] = rect.y + rect.height;
        this.vertices.items[6] = rect.x;
        this.vertices.items[7] = rect.y + rect.height;
        this.vertices.size = 8;
        this.closed = true;
        return this;
    }

    public void clear() {
        this.vertices.clear();
        this.corners.clear();
        this.closed = false;
    }

    public boolean empty() {
        return this.vertices.size == 0;
    }

    public int size() {
        return this.vertices.size / 2;
    }

    public int indexSize() {
        return this.closed ? 2 * this.size() : 2 * (this.size() - 1);
    }

    public Polyline getPolyline() {
        return new Polyline(this.vertices.items);
    }

    public Polygon getPolygon() {
        return new Polygon(this.vertices.items);
    }

    public Vector2[] getVertices() {
        Vector2[] result = new Vector2[this.vertices.size / 2];
        for (int ii = 0; ii < this.vertices.size; ii += 2) {
            result[ii / 2] = new Vector2(this.vertices.items[ii], this.vertices.items[ii + 1]);
        }
        return result;
    }

    public short[] getIndices() {
        return this.getIndices(new short[0]);
    }

    public short[] getIndices(short[] buffer) {
        int iSize = buffer.length;
        short[] copy = new short[iSize + this.vertices.size];
        System.arraycopy(buffer, 0, copy, 0, buffer.length);
        int curIndex = iSize;
        for (int i = 0; i < this.vertices.size / 2 - 1; ++i) {
            copy[curIndex] = (short)i;
            copy[curIndex + 1] = (short)(i + 1);
            curIndex += 2;
        }
        if (this.closed) {
            copy[curIndex] = (short)(this.vertices.size / 2 - 1);
            copy[curIndex + 1] = 0;
        }
        return copy;
    }

    public float getPositionX(int index) {
        return this.vertices.items[2 * index];
    }

    public float getPositionY(int index) {
        return this.vertices.items[2 * index + 1];
    }

    public Vector2 vertexAt(int index) {
        if (index < 0 || index > (this.vertices.size - 2) / 2) {
            throw new IndexOutOfBoundsException();
        }
        return new Vector2(this.vertices.items[2 * index], this.vertices.items[2 * index + 1]);
    }

    public Vector2 vertexAt(int index, Vector2 point) {
        if (index < 0 || index > (this.vertices.size - 2) / 2) {
            throw new IndexOutOfBoundsException();
        }
        if (point == null) {
            point = new Vector2(this.vertices.items[2 * index], this.vertices.items[2 * index + 1]);
        } else {
            point.set(this.vertices.items[2 * index], this.vertices.items[2 * index + 1]);
        }
        return point;
    }

    public Vector2 pop() {
        if (this.vertices.size == 0) {
            return null;
        }
        this.corners.remove((this.vertices.size - 2) / 2);
        Vector2 point = new Vector2(this.vertices.items[this.vertices.size - 2], this.vertices.items[this.vertices.size - 1]);
        this.vertices.size -= 2;
        return point;
    }

    public Vector2 pop(Vector2 point) {
        if (this.vertices.size == 0) {
            return null;
        }
        this.corners.remove((this.vertices.size - 2) / 2);
        if (point == null) {
            point = new Vector2(this.vertices.items[this.vertices.size - 2], this.vertices.items[this.vertices.size - 1]);
        } else {
            point.set(this.vertices.items[this.vertices.size - 2], this.vertices.items[this.vertices.size - 1]);
        }
        this.vertices.size -= 2;
        return point;
    }

    public void push(Vector2 point, boolean corner) {
        this.push(point.x, point.y, corner);
    }

    public void push(float x, float y, boolean corner) {
        this.vertices.ensureCapacity(2);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.size += 2;
        if (corner) {
            this.corners.add((this.vertices.size - 2) / 2);
        }
    }

    public Vector2 remove(int index) {
        if (this.vertices.size - 1 < index * 2) {
            return null;
        }
        Vector2 point = this.vertexAt(index);
        this.corners.remove(index);
        this.vertices.removeRange(index * 2, index * 2 + 1);
        return point;
    }

    public Vector2 remove(int index, Vector2 point) {
        if (this.vertices.size - 1 < index * 2) {
            return null;
        }
        point = this.vertexAt(index, point);
        this.corners.remove(index);
        this.vertices.removeRange(index * 2, index * 2 + 1);
        return point;
    }

    public void add(int index, Vector2 point, boolean corner) {
        this.add(index, point.x, point.y, corner);
    }

    public void add(int index, float x, float y, boolean corner) {
        if (index > (this.vertices.size - 2) / 2) {
            index = (this.vertices.size - 2) / 2 + 1;
        }
        this.vertices.insert(2 * index, x);
        this.vertices.insert(2 * index + 1, x);
        for (int ii = this.vertices.size; ii >= index; --ii) {
            if (!this.corners.contains(ii)) continue;
            this.corners.remove(ii);
            this.corners.addAll(new int[]{ii + 1});
        }
        if (corner) {
            this.corners.add(index);
        }
    }

    public void reserve(int size) {
        if (size <= this.vertices.size) {
            return;
        }
        this.vertices.ensureCapacity(size - this.vertices.size);
    }

    public boolean onSegment(Vector2 point, Vector2 a, Vector2 b, float variance) {
        float d1 = point.dst(a);
        float d2 = point.dst(b);
        float d3 = a.dst(b);
        return Math.abs(d3 - d2 - d1) <= variance;
    }

    public boolean contains(float x, float y) {
        if (!this.closed) {
            return false;
        }
        int intersects = 0;
        for (int i = 0; i < this.vertices.size - 2; i += 2) {
            float x1 = this.vertices.items[i];
            float y1 = this.vertices.items[i + 1];
            float x2 = this.vertices.items[i + 2];
            float y2 = this.vertices.items[i + 3];
            if (!(y1 <= y && y < y2) && (!(y2 <= y) || !(y < y1)) || !(x < (x2 - x1) / (y2 - y1) * (y - y1) + x1)) continue;
            ++intersects;
        }
        float x1 = this.vertices.items[this.vertices.size - 2];
        float y1 = this.vertices.items[this.vertices.size - 1];
        float x2 = this.vertices.items[0];
        float y2 = this.vertices.items[1];
        if ((y1 <= y && y < y2 || y2 <= y && y < y1) && x < (x2 - x1) / (y2 - y1) * (y - y1) + x1) {
            ++intersects;
        }
        return intersects & true;
    }

    public boolean contains(Vector2 point) {
        return this.contains(point.x, point.y);
    }

    public boolean incident(float x, float y, float err) {
        temp1.set(x, y);
        for (int i = 0; i < this.vertices.size - 2; i += 2) {
            temp2.set(this.vertices.items[i], this.vertices.items[i + 1]);
            temp3.set(this.vertices.items[i + 2], this.vertices.items[i + 3]);
            if (!this.onSegment(temp1, temp2, temp3, err)) continue;
            return true;
        }
        if (this.closed) {
            temp2.set(this.vertices.items[this.vertices.size - 2], this.vertices.items[this.vertices.size - 1]);
            temp3.set(this.vertices.items[0], this.vertices.items[1]);
            return this.onSegment(temp1, temp2, temp3, err);
        }
        return false;
    }

    public boolean incident(Vector2 point, float err) {
        return this.incident(point.x, point.y, err);
    }

    public int leftTurn() {
        if (this.vertices.size <= 4) {
            return 0;
        }
        int nLeft = 0;
        if (this.closed) {
            float p0x = this.vertices.items[this.vertices.size - 2];
            float p0y = this.vertices.items[this.vertices.size - 1];
            float p1x = this.vertices.items[0];
            float p1y = this.vertices.items[1];
            for (int i = 2; i < this.vertices.size; i += 2) {
                float p2x = this.vertices.items[i];
                float p2y = this.vertices.items[i + 1];
                float cross = (p2x - p1x) * (p1y - p0y) - (p1x - p0x) * (p2y - p1y);
                if ((double)cross < 0.0) {
                    ++nLeft;
                }
                p0x = p1x;
                p0y = p1y;
                p1x = p2x;
                p1y = p2y;
            }
            float p2x = this.vertices.items[0];
            float p2y = this.vertices.items[1];
            float cross = (p2x - p1x) * (p1y - p0y) - (p1x - p0x) * (p2y - p1y);
            if ((double)cross < 0.0) {
                ++nLeft;
            }
        } else {
            float p0x = this.vertices.items[0];
            float p0y = this.vertices.items[1];
            float p1x = this.vertices.items[2];
            float p1y = this.vertices.items[3];
            for (int i = 4; i < this.vertices.size; i += 2) {
                float p2x = this.vertices.items[i];
                float p2y = this.vertices.items[i + 1];
                float cross = (p2x - p1x) * (p1y - p0y) - (p1x - p0x) * (p2y - p1y);
                if ((double)cross < 0.0) {
                    ++nLeft;
                }
                p0x = p1x;
                p0y = p1y;
                p1x = p2x;
                p1y = p2y;
            }
        }
        return nLeft;
    }

    public boolean isConvex() {
        if (this.vertices.size <= 4 || !this.closed) {
            return false;
        }
        int nLeft = 0;
        float p0x = this.vertices.items[this.vertices.size - 2];
        float p0y = this.vertices.items[this.vertices.size - 1];
        float p1x = this.vertices.items[0];
        float p1y = this.vertices.items[1];
        for (int i = 2; i < this.vertices.size; i += 2) {
            float p2x = this.vertices.items[i];
            float p2y = this.vertices.items[i + 1];
            float cross = (p2x - p1x) * (p1y - p0y) - (p1x - p0x) * (p2y - p1y);
            if ((double)cross < 0.0) {
                ++nLeft;
            }
            p0x = p1x;
            p0y = p1y;
            p1x = p2x;
            p1y = p2y;
        }
        float p2x = this.vertices.items[0];
        float p2y = this.vertices.items[1];
        float cross = (p2x - p1x) * (p1y - p0y) - (p1x - p0x) * (p2y - p1y);
        if ((double)cross < 0.0) {
            ++nLeft;
        }
        return nLeft == this.vertices.size / 2;
    }

    public float area() {
        temp1.set(this.vertices.items[0], this.vertices.items[1]);
        float area = 0.0f;
        for (int i = 4; i < this.vertices.size; i += 2) {
            temp2.set(this.vertices.items[i - 2], this.vertices.items[i - 1]);
            temp3.set(this.vertices.items[i], this.vertices.items[i + 1]);
            temp2.sub(temp1);
            temp3.sub(temp1);
            area += Path2.temp2.x * Path2.temp3.y - Path2.temp3.x * Path2.temp2.y;
        }
        return area * 0.5f;
    }

    public int orientation() {
        return Path2.orientation(this.vertices);
    }

    public static int orientation(Vector2 a, Vector2 b, Vector2 c) {
        float val = (b.y - a.y) * (c.x - a.x) - (b.x - a.x) * (c.y - a.y);
        if (-5.0E-4f < val && val < 5.0E-4f) {
            return 0;
        }
        return val > 0.0f ? 1 : -1;
    }

    public static int orientation(float ax, float ay, float bx, float by, float cx, float cy) {
        float val = (by - ay) * (cx - ax) - (bx - ax) * (cy - ay);
        if (-5.0E-4f < val && val < 5.0E-4f) {
            return 0;
        }
        return val > 0.0f ? 1 : -1;
    }

    public static int orientation(FloatArray path) {
        int idx = Path2.hullPoint(path);
        int vCount = path.size / 2;
        int bx = idx == 0 ? vCount - 1 : idx - 1;
        int ax = idx == vCount - 1 ? 0 : idx + 1;
        temp1.set(path.items[bx * 2], path.items[bx * 2 + 1]);
        temp2.set(path.items[idx * 2], path.items[idx * 2 + 1]);
        temp3.set(path.items[ax * 2], path.items[ax * 2 + 1]);
        return Path2.orientation(temp1, temp2, temp3);
    }

    public static int orientation(float[] path, int offset, int length) {
        int idx = Path2.hullPoint(path, offset, length);
        int vCount = length / 2;
        int bx = idx == offset ? vCount - 1 : idx - 1;
        int ax = idx == vCount - 1 ? offset : idx + 1;
        temp1.set(path[offset + bx * 2], path[offset + bx * 2 + 1]);
        temp2.set(path[offset + idx * 2], path[offset + idx * 2 + 1]);
        temp3.set(path[offset + ax * 2], path[offset + ax * 2 + 1]);
        return Path2.orientation(temp1, temp2, temp3);
    }

    public Path2 reverse() {
        int end = this.vertices.size - 2;
        for (int i = 0; i < this.vertices.size / 2; i += 2) {
            float x = this.vertices.items[end - i];
            float y = this.vertices.items[end - i + 1];
            this.vertices.items[end - i] = this.vertices.items[i];
            this.vertices.items[end - i + 1] = this.vertices.items[i + 1];
            this.vertices.items[i] = x;
            this.vertices.items[i + 1] = y;
        }
        IntSet.IntSetIterator it = this.corners.iterator();
        this.corners.clear();
        while (it.hasNext) {
            this.corners.add(this.vertices.size / 2 - it.next() - 1);
        }
        return this;
    }

    public Path2 reversed() {
        Path2 copy = this;
        copy.reverse();
        return copy;
    }

    private int hullPoint() {
        return Path2.hullPoint(this.vertices);
    }

    private static int hullPoint(FloatArray path) {
        if (path.size == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        double mx = path.items[0];
        double my = path.items[1];
        int pos = 0;
        for (int i = 2; i < path.size; i += 2) {
            if ((double)path.items[i] < mx) {
                mx = path.items[i];
                my = path.items[i + 1];
                pos = i / 2;
                continue;
            }
            if ((double)path.items[i] != mx || !((double)path.items[i + 1] < my)) continue;
            my = path.items[i + 1];
            pos = i / 2;
        }
        return pos;
    }

    private static int hullPoint(float[] path, int offset, int length) {
        if (path.length == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        double mx = path[offset];
        double my = path[offset + 1];
        int pos = 0;
        for (int i = 2; i < length; i += 2) {
            if ((double)path[i] < mx) {
                mx = path[offset + i];
                my = path[offset + i + 1];
                pos = i / 2;
                continue;
            }
            if ((double)path[offset + i] != mx || !((double)path[offset + i + 1] < my)) continue;
            my = path[offset + i + 1];
            pos = i / 2;
        }
        return pos;
    }

    public Path2 scl(float scale) {
        int i = 0;
        while (i < this.vertices.size) {
            int n = i++;
            this.vertices.items[n] = this.vertices.items[n] * scale;
        }
        return this;
    }

    public Path2 scl(Vector2 scale) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            int n = i;
            this.vertices.items[n] = this.vertices.items[n] * scale.x;
            int n2 = i + 1;
            this.vertices.items[n2] = this.vertices.items[n2] * scale.y;
        }
        return this;
    }

    public Path2 div(float scale) {
        if (scale == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        return this.scl(1.0f / scale);
    }

    public Path2 div(Vector2 scale) {
        if (scale.x == 0.0f || scale.y == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        temp1.set(1.0f / scale.x, 1.0f / scale.y);
        return this.scl(temp1);
    }

    public Path2 add(Vector2 offset) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            int n = i;
            this.vertices.items[n] = this.vertices.items[n] + offset.x;
            int n2 = i + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + offset.y;
        }
        return this;
    }

    public Path2 sub(Vector2 offset) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            int n = i;
            this.vertices.items[n] = this.vertices.items[n] - offset.x;
            int n2 = i + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - offset.y;
        }
        return this;
    }

    public Path2 transform(Affine2 transform) {
        for (int i = 0; i < this.vertices.size; i += 2) {
            temp1.set(this.vertices.items[i], this.vertices.items[i + 1]);
            transform.applyTo(temp1);
            this.vertices.items[i] = Path2.temp1.x;
            this.vertices.items[i + 1] = Path2.temp1.y;
        }
        return this;
    }

    public Path2 add(Path2 extra) {
        this.closed = false;
        this.reserve(extra.vertices.size);
        int size = this.vertices.size / 2;
        this.vertices.addAll(extra.vertices);
        IntSet.IntSetIterator it = extra.corners.iterator();
        while (it.hasNext) {
            this.corners.add(it.next() + size);
        }
        return this;
    }

    public Path2 slice(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("The indices are invalid");
        }
        Path2 copy = new Path2(this.vertices.items, start * 2, end * 2);
        for (int i = start; i < end; ++i) {
            if (!this.isCorner(i)) continue;
            copy.corners.add(i - start);
        }
        return copy;
    }

    public Path2 sliceForm(int start) {
        return this.slice(start, this.vertices.size / 2);
    }

    public Path2 sliceTo(int end) {
        return this.slice(0, end);
    }

    public boolean isCorner(int index) {
        return this.corners.contains(index);
    }

    public String toString(boolean verbose) {
        String ss = verbose ? "Path2[" : "[";
        for (int i = 0; i < this.vertices.size; i += 2) {
            ss = ss + "(" + this.vertices.items[i] + ", " + this.vertices.items[i + 1] + ")";
            if (i == this.vertices.size - 2) continue;
            ss = ss + "; ";
        }
        ss = ss + "]";
        return ss;
    }

    public String toString() {
        return this.toString(true);
    }

    public Rectangle getBounds() {
        if (this.vertices.size == 0) {
            return null;
        }
        float minX = this.vertices.items[0];
        float minY = this.vertices.items[1];
        float maxX = minX;
        float maxY = minY;
        for (int i = 0; i < this.vertices.size; i += 2) {
            float x = this.vertices.items[i];
            float y = this.vertices.items[i + 1];
            if (x < minX) {
                minX = x;
            } else if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
                continue;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }
}

