/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.obj;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.Model;

public class ModelRef {
    private Model model;
    private Material material;
    private Matrix4 modelview;
    private Matrix4 normalmat;
    private Vector3 anchor;
    private Vector3 position;
    private Vector3 scale;
    private Quaternion rotate;
    private Quaternion tempQuat;

    public ModelRef(Model m) {
        this.model = m;
        this.modelview = new Matrix4();
        this.normalmat = new Matrix4();
        this.anchor = new Vector3();
        this.position = new Vector3();
        this.scale = new Vector3(1.0f, 1.0f, 1.0f);
        this.rotate = new Quaternion();
        this.tempQuat = new Quaternion();
    }

    public Model getModel() {
        return this.model;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public void setPosition(Vector3 position) {
        this.position.set(position);
        this.updateMatrices();
    }

    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
        this.updateMatrices();
    }

    public void setAnchor(Vector3 anchor) {
        if (!this.anchor.epsilonEquals(anchor)) {
            this.position.set(anchor);
            this.position.mul(this.modelview);
        }
        this.anchor.set(anchor);
        this.updateMatrices();
    }

    public void setAnchor(float x, float y, float z) {
        if (!this.anchor.epsilonEquals(x, y, z)) {
            this.position.set(this.anchor);
            this.position.mul(this.modelview);
        }
        this.anchor.set(x, y, z);
        this.updateMatrices();
    }

    Vector3 getAnchor() {
        return this.anchor;
    }

    public Vector3 getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.setScale(scale, scale, scale);
    }

    public void setScale(Vector3 scale) {
        this.scale.set(scale);
        this.updateMatrices();
    }

    public void setScale(float x, float y, float z) {
        this.scale.set(x, y, z);
        this.updateMatrices();
    }

    public Quaternion getRotation() {
        return this.rotate;
    }

    public void setRotation(Quaternion rot) {
        this.rotate.set(rot);
        this.updateMatrices();
    }

    public void setRotation(float phi, float theta) {
        this.tempQuat.set(Vector3.X, phi);
        this.rotate.set(Vector3.Y, theta);
        this.rotate.mul(this.tempQuat);
        this.updateMatrices();
    }

    public Matrix4 getModelView() {
        return this.modelview;
    }

    public Matrix4 getNormals() {
        return this.normalmat;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    private void updateMatrices() {
        this.modelview.idt();
        this.modelview.trn(this.position.x, this.position.y, this.position.z);
        this.modelview.rotate(this.rotate);
        this.modelview.scale(this.scale.x, this.scale.y, this.scale.z);
        this.modelview.trn(-this.anchor.x, -this.anchor.y, -this.anchor.z);
        this.normalmat.set(this.modelview);
        this.normalmat.inv();
        this.normalmat.tra();
    }
}

