/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.graphics.GLDebug;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class VertexBuffer
implements Disposable {
    private GL20 gl;
    protected int stride;
    protected int vertMax;
    protected int vertArray;
    protected int vertBuffer;
    protected FloatBuffer floatVertData;
    protected int indxBuffer;
    protected ShortBuffer shortIndxData;
    protected ShaderProgram shader;
    protected ObjectMap<String, Boolean> enabled;
    protected ObjectMap<String, AttribData> attributes;
    private boolean isbound = false;
    private boolean initialized;
    boolean loadv = false;
    boolean loadi = false;

    public VertexBuffer(int stride, int capacity) {
        this(stride, capacity, 3 * capacity);
    }

    public VertexBuffer(int stride, int vertMax, int indxMax) {
        if (stride <= 0) {
            throw new IllegalArgumentException("Stride must be > 0: " + stride);
        }
        if (vertMax < 0) {
            throw new IllegalArgumentException("Vertex capacity must be >= 0: " + vertMax);
        }
        if (indxMax < 0) {
            throw new IllegalArgumentException("Index capacity must be >= 0: " + indxMax);
        }
        this.gl = Gdx.gl30;
        boolean is30 = true;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
            is30 = false;
        }
        this.stride = stride;
        this.vertMax = vertMax;
        this.shader = null;
        IntBuffer vertArrayPtr = BufferUtils.newIntBuffer((int)1);
        vertArrayPtr.put(0, 0);
        IntBuffer vertBufferPtr = BufferUtils.newIntBuffer((int)1);
        vertBufferPtr.put(0, 0);
        IntBuffer indxBufferPtr = BufferUtils.newIntBuffer((int)1);
        indxBufferPtr.put(0, 0);
        this.floatVertData = BufferUtils.newFloatBuffer((int)(stride * vertMax / 4));
        this.shortIndxData = BufferUtils.newShortBuffer((int)indxMax);
        this.enabled = new ObjectMap();
        this.attributes = new ObjectMap();
        if (is30) {
            Gdx.gl30.glGenVertexArrays(1, vertArrayPtr);
            this.vertArray = vertArrayPtr.get(0);
            if (this.vertArray == 0) {
                throw new GdxRuntimeException("Could not create vertex array.");
            }
        } else {
            this.vertArray = -1;
        }
        this.gl.glGenBuffers(1, vertBufferPtr);
        this.vertBuffer = vertBufferPtr.get(0);
        if (this.vertBuffer == 0) {
            if (is30) {
                Gdx.gl30.glDeleteVertexArrays(1, vertArrayPtr);
            }
            throw new GdxRuntimeException("Could not create vertex buffer.");
        }
        this.gl.glGenBuffers(1, indxBufferPtr);
        this.indxBuffer = indxBufferPtr.get(0);
        if (this.indxBuffer == 0) {
            if (is30) {
                Gdx.gl30.glDeleteVertexArrays(1, vertArrayPtr);
            }
            this.gl.glDeleteBuffers(1, vertBufferPtr);
            throw new GdxRuntimeException("Could not create index buffer.");
        }
        this.initialized = true;
    }

    public void dispose() {
        this.gl.glBindBuffer(34962, 0);
        if (this.vertBuffer == 0) {
            return;
        }
        if (this.enabled != null) {
            this.enabled.clear();
            this.enabled = null;
        }
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        if (this.indxBuffer != 0) {
            IntBuffer indxBufferPtr = BufferUtils.newIntBuffer((int)1);
            indxBufferPtr.put(0, this.indxBuffer);
            this.gl.glDeleteBuffers(1, indxBufferPtr);
            this.indxBuffer = 0;
        }
        if (this.vertBuffer != 0) {
            IntBuffer vertBufferPtr = BufferUtils.newIntBuffer((int)1);
            vertBufferPtr.put(0, this.vertBuffer);
            this.gl.glDeleteBuffers(1, vertBufferPtr);
            this.vertBuffer = 0;
        }
        if (this.vertArray > 0) {
            IntBuffer vertArrayPtr = BufferUtils.newIntBuffer((int)1);
            vertArrayPtr.put(0, this.vertArray);
            Gdx.gl30.glDeleteVertexArrays(1, vertArrayPtr);
            this.vertArray = 0;
        }
        this.shader = null;
        this.stride = 0;
    }

    public void bind() {
        assert (this.vertBuffer != 0) : "VertexBuffer has not been initialized.";
        if (Gdx.gl30 != null) {
            Gdx.gl30.glBindVertexArray(this.vertArray);
            this.gl.glBindBuffer(34962, this.vertBuffer);
            this.gl.glBindBuffer(34963, this.indxBuffer);
        } else {
            this.gl.glBindBuffer(34962, this.vertBuffer);
            this.gl.glBindBuffer(34963, this.indxBuffer);
            for (ObjectMap.Entry attrib : this.attributes) {
                String key = (String)attrib.key;
                AttribData attribute = (AttribData)attrib.value;
                if (!((Boolean)this.enabled.get((Object)key)).booleanValue()) continue;
                this.gl.glEnableVertexAttribArray(attribute.pos);
                this.gl.glVertexAttribPointer(attribute.pos, attribute.size, attribute.type, attribute.norm, this.stride, attribute.offset);
            }
        }
        this.isbound = true;
    }

    public void unbind() {
        if (this.isBound()) {
            this.gl.glBindBuffer(34963, 0);
            this.gl.glBindBuffer(34962, 0);
            if (Gdx.gl30 != null) {
                Gdx.gl30.glBindVertexArray(0);
            } else {
                for (ObjectMap.Entry attrib : this.attributes) {
                    AttribData attribute = (AttribData)attrib.value;
                    this.gl.glDisableVertexAttribArray(attribute.pos);
                }
            }
        }
        this.isbound = false;
    }

    public void attach(ShaderProgram shader) {
        assert (shader != null) : "Attempting to attach a null shader";
        if (this.shader != shader) {
            this.shader = shader;
            this.bind();
            for (ObjectMap.Entry attrib : this.attributes) {
                String key = (String)attrib.key;
                AttribData attribute = (AttribData)attrib.value;
                int pos = this.gl.glGetAttribLocation(shader.getHandle(), key);
                if (pos == -1) {
                    Gdx.app.debug("OPENGL", String.format("Active shader has no attribute '%s'.", key));
                    continue;
                }
                if (((Boolean)this.enabled.get((Object)key)).booleanValue()) {
                    attribute.pos = pos;
                    this.gl.glEnableVertexAttribArray(pos);
                    this.gl.glVertexAttribPointer(pos, attribute.size, attribute.type, attribute.norm, this.stride, attribute.offset);
                    continue;
                }
                attribute.pos = pos;
                this.gl.glDisableVertexAttribArray(pos);
            }
            int error = this.gl.glGetError();
            assert (error == 0) : "VertexBuffer: " + GLDebug.errorName(error);
        } else {
            this.bind();
        }
    }

    public ShaderProgram detach() {
        ShaderProgram result = this.shader;
        this.unbind();
        this.shader = null;
        return result;
    }

    public boolean isBound() {
        return this.isbound;
    }

    public int getStride() {
        return this.stride;
    }

    public void loadVertexData(float[] data, int size, int usage) {
        assert (this.isBound()) : "Vertex buffer is not bound";
        this.floatVertData.position(0);
        BufferUtils.copy((float[])data, (Buffer)this.floatVertData, (int)size, (int)0);
        this.gl.glBufferData(34962, this.stride * size, (Buffer)this.floatVertData, usage);
        int error = this.gl.glGetError();
        assert (error == 0) : "VertexBuffer Error";
        this.loadv = usage == 35044;
    }

    public void loadVertexData(float[] data, int size) {
        this.loadVertexData(data, size, 35040);
    }

    public void loadIndexData(short[] data, int size, int usage) {
        assert (this.isBound()) : "Vertex buffer is not bound";
        this.shortIndxData.position(0);
        BufferUtils.copy((short[])data, (int)0, (Buffer)this.shortIndxData, (int)size);
        this.gl.glBufferData(34963, 2 * size, (Buffer)this.shortIndxData, usage);
        int error = this.gl.glGetError();
        assert (error == 0) : "VertexBuffer Error";
        this.loadi = usage == 35044;
    }

    public void loadIndexData(short[] data, int size) {
        this.loadIndexData(data, size, 35040);
    }

    public void draw(int mode, int count, int offset) {
        assert (this.isBound()) : "Vertex buffer is not bound";
        this.gl.glDrawElements(mode, count, 5123, offset * 2);
    }

    public void drawInstanced(int mode, int count, int instance, int offset) {
        assert (this.isBound()) : "Vertex is not bound";
        if (Gdx.gl30 == null) {
            throw new UnsupportedOperationException("Instancing requires OpenGL 3.0");
        }
        Gdx.gl30.glDrawElementsInstanced(mode, count, 5125, offset * 4, instance);
    }

    public void setupAttribute(String name, int size, int type, boolean norm, int offset) {
        AttribData data = new AttribData();
        data.size = size;
        data.norm = norm;
        data.type = type;
        data.offset = offset;
        this.attributes.put((Object)name, (Object)data);
        this.enabled.put((Object)name, (Object)true);
        if (this.shader != null) {
            this.shader.bind();
            int pos = this.gl.glGetAttribLocation(this.shader.getHandle(), name);
            if (pos == -1) {
                Gdx.app.debug("OPENGL", String.format("Active shader has no attribute '%s'.", name));
            } else {
                this.gl.glEnableVertexAttribArray(pos);
                this.gl.glVertexAttribPointer(pos, data.size, data.type, data.norm, this.stride, data.offset);
            }
            int error = this.gl.glGetError();
            assert (error == 0) : "VertexBuffer Error";
        }
    }

    public void enableAttribute(String name) {
        assert (this.enabled.containsKey((Object)name)) : "Vertex buffer has no attribute " + name;
        assert (this.isBound()) : "Vertex buffer is not bound.";
        if (!((Boolean)this.enabled.get((Object)name)).booleanValue()) {
            this.enabled.put((Object)name, (Object)true);
            if (this.shader != null) {
                int locale = this.shader.getUniformLocation(name);
                this.gl.glEnableVertexAttribArray(locale);
            }
        }
    }

    public void disableAttribute(String name) {
        assert (this.enabled.containsKey((Object)name)) : "Vertex buffer has no attribute " + name;
        assert (this.isBound()) : "Vertex buffer is not bound.";
        if (((Boolean)this.enabled.get((Object)name)).booleanValue()) {
            this.enabled.put((Object)name, (Object)false);
            if (this.shader != null) {
                int locale = this.shader.getUniformLocation(name);
                this.gl.glDisableVertexAttribArray(locale);
            }
        }
    }

    protected static class AttribData {
        public int pos = -1;
        public int size;
        public int type;
        public boolean norm;
        public int offset;
    }
}

