/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Pool;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.graphics.TextAlign;
import edu.cornell.gdiac.graphics.TexturedMesh;

public class TextLayout
implements Pool.Poolable {
    private String text;
    private BitmapFont font;
    private Color color;
    private float maxWidth;
    private int alignment;
    private Rectangle bounds;
    private Rectangle constraint;
    private GlyphLayout layout;
    private Array<TexturedMesh> meshes;
    private boolean invalid;
    private Rectangle quad;
    private Vector2 offset;
    private Array<Rectangle> glyphBounds;
    private IntArray indices;
    private char[] codepoint = new char[1];

    public TextLayout() {
        this("", null, 0.0f);
    }

    public TextLayout(float width) {
        this("", null, width);
    }

    public TextLayout(String text, BitmapFont font) {
        this(text, font, 0.0f);
    }

    public TextLayout(String text, BitmapFont font, float width) {
        this.text = text;
        this.font = font;
        this.alignment = 33;
        this.maxWidth = width;
        this.color = Color.WHITE;
        this.layout = new GlyphLayout();
        this.bounds = new Rectangle();
        this.constraint = new Rectangle();
        this.quad = new Rectangle();
        this.meshes = new Array();
        this.offset = new Vector2();
        this.glyphBounds = new Array();
        this.indices = new IntArray();
        if (text.length() == 0) {
            this.layout.runs.add((Object)new GlyphLayout.GlyphRun());
        }
        this.setFont(font);
    }

    public void reset() {
        this.text = "";
        this.font = null;
        this.alignment = 33;
        this.maxWidth = 0.0f;
        this.color = Color.WHITE;
        this.constraint.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.quad.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.offset.set(0.0f, 0.0f);
        this.glyphBounds.clear();
        this.indices.clear();
        this.invalidate();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (text.length() == 0) {
            this.layout.runs.add((Object)new GlyphLayout.GlyphRun());
        }
        this.invalidate();
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public void setFont(BitmapFont font) {
        this.font = font;
        if (font != null) {
            int size = font.getRegions().size;
            if (size > this.meshes.size) {
                int diff = size - this.meshes.size;
                this.meshes.ensureCapacity(diff);
                for (int ii = 0; ii < diff; ++ii) {
                    this.meshes.add((Object)new TexturedMesh());
                }
            }
            for (int ii = 0; ii < size; ++ii) {
                ((TexturedMesh)this.meshes.get(ii)).setTextureRegion(font.getRegion(ii));
            }
            this.color = font.getColor();
        }
        this.invalidate();
    }

    public float getWidth() {
        return this.maxWidth;
    }

    public void setWidth(float width) {
        this.maxWidth = width;
        this.invalidate();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int align) {
        this.alignment = TextAlign.normalize(align);
        this.invalidate();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c == null ? Color.WHITE : c;
        this.invalidate();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rect) {
        this.constraint.set(rect.x, rect.y, rect.width, rect.height);
        this.invalidate();
    }

    public void setBounds(float x, float y, float width, float height) {
        this.constraint.set(x, y, width, height);
        this.invalidate();
    }

    public void clearBounds() {
        this.constraint.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.invalidate();
    }

    public GlyphLayout.GlyphRun getRun(int idx) {
        return (GlyphLayout.GlyphRun)this.layout.runs.get(idx);
    }

    public Vector2 getOffset() {
        return this.offset;
    }

    public int getTextIndex(int idx) {
        if (idx < 0 || this.indices.isEmpty()) {
            return 0;
        }
        if (idx >= this.indices.size) {
            return this.indices.items[this.indices.size - 1];
        }
        return this.indices.items[idx];
    }

    public void invalidate() {
        this.invalid = true;
        this.bounds.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int ii = 0; ii < this.meshes.size; ++ii) {
            ((TexturedMesh)this.meshes.get(ii)).clear();
        }
    }

    boolean validated() {
        return !this.invalid;
    }

    public int getLineCount() {
        return this.layout.runs.size;
    }

    public String getLine(int line) {
        GlyphLayout.GlyphRun run = (GlyphLayout.GlyphRun)this.layout.runs.get(line);
        int size = run.glyphs.size;
        if (((BitmapFont.Glyph)run.glyphs.get((int)(size - 1))).id == 10) {
            --size;
        }
        char[] data = new char[size];
        for (int ii = 0; ii < size; ++ii) {
            data[ii] = (char)((BitmapFont.Glyph)run.glyphs.get((int)ii)).id;
        }
        return new String(data);
    }

    public Rectangle getGlyphBounds(int index) {
        return (Rectangle)this.glyphBounds.get(index);
    }

    public int getGlyphIndex(Vector2 p) {
        return this.getGlyphIndex(p.x, p.y);
    }

    public int getGlyphIndex(float x, float y) {
        int total = 0;
        GlyphLayout.GlyphRun run = null;
        for (int ii = 0; run == null && ii < this.layout.runs.size; ++ii) {
            GlyphLayout.GlyphRun line = (GlyphLayout.GlyphRun)this.layout.runs.get(ii);
            float gy = line.y + this.offset.y;
            if (gy >= y && y >= gy - this.font.getLineHeight()) {
                run = line;
                continue;
            }
            total += line.glyphs.size;
        }
        if (run == null) {
            return this.text.length();
        }
        Object[] glyphs = run.glyphs.items;
        float[] xAdvances = run.xAdvances.items;
        float gx = run.x + this.offset.x;
        if (x < gx) {
            return this.text.length();
        }
        for (int ii = 0; ii < run.glyphs.size; ++ii) {
            gx += xAdvances[ii];
            float gw = ((BitmapFont.Glyph)glyphs[ii]).xadvance;
            if (!(gx <= x) || !(x <= gx + gw)) continue;
            return this.indices.items[total + ii];
        }
        return this.text.length();
    }

    int getNearestIndex(Vector2 p) {
        return this.getNearestIndex(p.x, p.y);
    }

    public int getNearestIndex(float x, float y) {
        int total = 0;
        GlyphLayout.GlyphRun run = null;
        for (int ii = 0; run == null && ii < this.layout.runs.size; ++ii) {
            GlyphLayout.GlyphRun line = (GlyphLayout.GlyphRun)this.layout.runs.get(ii);
            float gy = line.y + this.offset.y;
            if (y >= gy - this.font.getLineHeight()) {
                run = line;
                continue;
            }
            total += line.glyphs.size;
        }
        if (run == null) {
            run = (GlyphLayout.GlyphRun)this.layout.runs.get(this.layout.runs.size - 1);
            total -= run.glyphs.size;
        }
        Object[] glyphs = run.glyphs.items;
        float[] xAdvances = run.xAdvances.items;
        float gx = run.x + this.offset.x;
        for (int ii = 0; ii < run.glyphs.size; ++ii) {
            float gw = ((BitmapFont.Glyph)glyphs[ii]).xadvance;
            if (!(x <= (gx += xAdvances[ii]) + gw)) continue;
            return this.indices.items[total + ii];
        }
        return this.indices.items[this.indices.size - 1];
    }

    public Array<TexturedMesh> getMeshes() {
        this.layout();
        return this.meshes;
    }

    public SpriteMesh getGlyphBoxes() {
        this.layout();
        SpriteMesh mesh = new SpriteMesh();
        this.getGlyphBoxes(mesh);
        return mesh;
    }

    public int getGlyphBoxes(SpriteMesh mesh) {
        this.layout();
        boolean constrained = this.constraint.width > 0.0f && this.constraint.height > 0.0f;
        int total = 0;
        for (int ii = 0; ii < this.layout.runs.size; ++ii) {
            int jj;
            int nn;
            GlyphLayout.GlyphRun run = (GlyphLayout.GlyphRun)this.layout.runs.get(ii);
            Object[] glyphs = run.glyphs.items;
            float[] xAdvances = run.xAdvances.items;
            float gx = run.x;
            float gy = run.y;
            boolean more = true;
            if (constrained) {
                nn = run.glyphs.size;
                for (jj = 0; more && jj < nn; ++jj) {
                    int size = mesh.vertices.size;
                    more = this.getOutline((BitmapFont.Glyph)glyphs[jj], mesh, this.constraint, gx += xAdvances[jj], gy);
                    if (size == mesh.vertices.size) continue;
                    ++total;
                }
                continue;
            }
            nn = run.glyphs.size;
            for (jj = 0; jj < nn; ++jj) {
                this.getOutline((BitmapFont.Glyph)glyphs[jj], mesh, gx += xAdvances[jj], gy);
                ++total;
            }
        }
        mesh.command = 4;
        return total;
    }

    public void layout() {
        GlyphLayout.GlyphRun run;
        int ii;
        if (!this.invalid || this.font == null) {
            return;
        }
        this.layout.setText(this.font, (CharSequence)this.text, this.color, this.maxWidth, this.alignment, this.maxWidth > 0.0f);
        if (this.text.length() == 0 || this.text.strip().length() == 0) {
            this.layout.runs.add((Object)new GlyphLayout.GlyphRun());
        }
        this.computeBounds();
        this.unalignConstraint();
        boolean constrained = this.constraint.width > 0.0f && this.constraint.height > 0.0f;
        BitmapFont.Glyph newline = new BitmapFont.Glyph();
        newline.id = 10;
        boolean empty = true;
        int row = 0;
        float ly = 0.0f;
        for (ii = 0; ii < this.text.length(); ++ii) {
            if (this.isNewline(this.text.charAt(ii))) {
                if (empty) {
                    run = new GlyphLayout.GlyphRun();
                    if (TextAlign.isCenter(this.getAlignment())) {
                        run.x = this.constraint.getWidth() * 0.5f;
                    } else if (TextAlign.isRight(this.getAlignment())) {
                        run.x = this.constraint.getWidth();
                    }
                    run.y = ly;
                    run.glyphs.add((Object)newline);
                    run.xAdvances.add(0.0f, 0.0f);
                    this.layout.runs.insert(row, (Object)run);
                } else {
                    run = (GlyphLayout.GlyphRun)this.layout.runs.get(row);
                    run.glyphs.add((Object)newline);
                    run.xAdvances.add((float)(run.glyphs.size - 1), 0.0f);
                }
                ly -= this.font.getLineHeight();
                empty = true;
                ++row;
                continue;
            }
            empty = false;
        }
        for (ii = 0; ii < this.layout.runs.size; ++ii) {
            BitmapFont.Glyph glyph;
            int jj;
            int nn;
            run = (GlyphLayout.GlyphRun)this.layout.runs.get(ii);
            Object[] glyphs = run.glyphs.items;
            float[] xAdvances = run.xAdvances.items;
            float gx = run.x;
            float gy = run.y;
            boolean more = true;
            if (constrained) {
                nn = run.glyphs.size;
                for (jj = 0; more && jj < nn; ++jj) {
                    glyph = (BitmapFont.Glyph)glyphs[jj];
                    more = this.getQuad(glyph, (SpriteMesh)this.meshes.get(glyph.page), this.constraint, gx += xAdvances[jj], gy);
                }
                continue;
            }
            nn = run.glyphs.size;
            for (jj = 0; jj < nn; ++jj) {
                glyph = (BitmapFont.Glyph)glyphs[jj];
                this.getQuad(glyph, (SpriteMesh)this.meshes.get(glyph.page), gx += xAdvances[jj], gy);
            }
        }
        for (ii = 0; ii < this.meshes.size; ++ii) {
            ((TexturedMesh)this.meshes.get((int)ii)).command = 4;
        }
        this.alignBounds();
        this.computeGlyphBounds();
        this.invalid = false;
    }

    private void computeBounds() {
        GlyphLayout.GlyphRun line = (GlyphLayout.GlyphRun)this.layout.runs.get(0);
        float left = line.x;
        for (int ii = 1; ii < this.layout.runs.size; ++ii) {
            line = (GlyphLayout.GlyphRun)this.layout.runs.get(ii);
            left = Math.min(left, line.x);
        }
        float w = this.layout.width + left;
        float h = this.layout.height + this.font.getLineHeight() - this.font.getCapHeight();
        this.bounds.set(left, -h, w, h);
    }

    private void unalignConstraint() {
        if ((this.alignment & 4) != 0) {
            this.constraint.y -= this.bounds.height;
        } else if ((this.alignment & 0x20) != 0) {
            this.constraint.y -= this.bounds.height / 2.0f;
        } else if ((this.alignment & 0x40) != 0) {
            this.constraint.y -= this.layout.height;
        }
        if ((this.alignment & 0x10) != 0) {
            this.constraint.x += this.bounds.width;
        } else if ((this.alignment & 1) != 0) {
            this.constraint.x += this.bounds.width / 2.0f + this.bounds.x / 2.0f;
        }
    }

    private void alignBounds() {
        float dy = 0.0f;
        if ((this.alignment & 4) != 0) {
            dy = this.bounds.height;
        } else if ((this.alignment & 0x40) != 0) {
            dy = this.bounds.height - this.font.getLineHeight() + this.font.getCapHeight();
        } else if ((this.alignment & 0x20) != 0) {
            dy = this.bounds.height / 2.0f;
        }
        float dx = 0.0f;
        if ((this.alignment & 0x10) != 0) {
            dx = -this.bounds.width;
        } else if ((this.alignment & 1) != 0) {
            dx = -this.bounds.width / 2.0f - this.bounds.x / 2.0f;
        }
        this.offset.set(dx, dy);
        this.bounds.width -= this.bounds.x;
        this.bounds.y += dy;
        this.bounds.x += dx;
        this.constraint.y += dy;
        this.constraint.x += dx;
        if (this.constraint.width > 0.0f && this.constraint.height > 0.0f) {
            this.intersect(this.bounds, this.constraint, this.bounds);
        }
        if (dy != 0.0f || dx != 0.0f) {
            for (int ii = 0; ii < this.meshes.size; ++ii) {
                ((TexturedMesh)this.meshes.get(ii)).add(dx, dy);
            }
        }
    }

    private void computeGlyphBounds() {
        float gy;
        if (this.layout.runs.size == 0) {
            return;
        }
        int row = 0;
        int col = 0;
        int total = 0;
        GlyphLayout.GlyphRun run = (GlyphLayout.GlyphRun)this.layout.runs.get(0);
        Object[] glyphs = run.glyphs.items;
        float[] xAdvances = run.xAdvances.items;
        float gx = run.x + this.offset.x;
        float ly = gy = run.y + this.offset.y;
        this.glyphBounds.size = 0;
        this.indices.size = 0;
        this.glyphBounds.ensureCapacity(this.text.length());
        this.indices.ensureCapacity(this.text.length());
        Object[] bounds = this.glyphBounds.items;
        for (int ii = 0; ii < this.text.length(); ++ii) {
            while (col >= run.glyphs.size && row < this.layout.runs.size - 1) {
                run = (GlyphLayout.GlyphRun)this.layout.runs.get(++row);
                glyphs = run.glyphs.items;
                xAdvances = run.xAdvances.items;
                ly = gy;
                gx = run.x + this.offset.x;
                gy = run.y + this.offset.y;
                col = 0;
            }
            if (col >= run.glyphs.size) {
                if (bounds[ii] == null) {
                    bounds[ii] = new Rectangle();
                    continue;
                }
                ((Rectangle)bounds[ii]).set(0.0f, 0.0f, 0.0f, 0.0f);
                continue;
            }
            BitmapFont.Glyph g = (BitmapFont.Glyph)glyphs[col];
            if (g.id == this.text.charAt(ii)) {
                float scaleX = this.font.getScaleX();
                float scaleY = this.font.getScaleY();
                float x = gx + (float)g.xoffset * scaleX;
                float y = gy + (float)g.yoffset * scaleY;
                float w = (float)g.width * scaleX;
                float h = (float)g.height * scaleY;
                if (bounds[ii] == null) {
                    bounds[ii] = new Rectangle(x, y, w, h);
                } else {
                    ((Rectangle)bounds[ii]).set(x, y, w, h);
                }
                this.indices.items[total++] = ii;
                gx += xAdvances[col++];
                continue;
            }
            if (this.isNewline(this.text.charAt(ii))) {
                float lh = this.font.getLineHeight();
                float x = 0.0f;
                float y = ly;
                if (TextAlign.isCenter(this.getAlignment())) {
                    x = this.constraint.getWidth() * 0.5f;
                } else if (TextAlign.isRight(this.getAlignment())) {
                    x = this.constraint.getWidth();
                }
                ly -= lh;
                if (bounds[ii] == null) {
                    bounds[ii] = new Rectangle(x, y, 0.0f, lh);
                    continue;
                }
                ((Rectangle)bounds[ii]).set(x, y, 0.0f, lh);
                continue;
            }
            if (bounds[ii] == null) {
                bounds[ii] = new Rectangle();
                continue;
            }
            ((Rectangle)bounds[ii]).set(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.glyphBounds.size = this.text.length();
        this.indices.size = total;
    }

    private Rectangle intersect(Rectangle rect1, Rectangle rect2, Rectangle rect3) {
        float minX = Math.max(rect1.x, rect2.x);
        float minY = Math.max(rect1.y, rect2.y);
        float maxX = Math.min(rect1.x + rect1.width, rect2.x + rect2.width);
        float maxY = Math.min(rect1.y + rect1.height, rect2.y + rect2.height);
        if (maxX - minX < 0.0f || maxY - minY < 0.0f) {
            maxY = 0.0f;
            minY = 0.0f;
            maxX = 0.0f;
            minX = 0.0f;
        }
        rect3.set(minX, minY, maxX - minX, maxY - minY);
        return rect3;
    }

    private boolean getQuad(BitmapFont.Glyph glyph, SpriteMesh mesh, Rectangle rect, float ox, float oy) {
        float scaleX = this.font.getScaleX();
        float scaleY = this.font.getScaleY();
        float x = ox + (float)glyph.xoffset * scaleX;
        float y = oy + (float)glyph.yoffset * scaleY;
        float w = (float)glyph.width * scaleX;
        float h = (float)glyph.height * scaleY;
        this.quad.set(x, y, w, h);
        if (!rect.overlaps(this.quad) || w <= 0.0f) {
            return this.quad.x + this.quad.width <= rect.x + rect.width;
        }
        this.intersect(this.quad, rect, this.quad);
        boolean result = this.quad.x + this.quad.width <= rect.x + rect.width;
        float s1 = (this.quad.x - x) / w;
        float s2 = 1.0f - (x + w - this.quad.x - this.quad.width) / w;
        float t1 = (this.quad.y - y) / h;
        float t2 = 1.0f - (y + h - this.quad.y - this.quad.height) / h;
        float u1 = glyph.u * (1.0f - s1) + glyph.u2 * s1;
        float u2 = glyph.u * (1.0f - s2) + glyph.u2 * s2;
        float v1 = glyph.v * (1.0f - t1) + glyph.v2 * t1;
        float v2 = glyph.v * (1.0f - t2) + glyph.v2 * t2;
        short vtx = (short)mesh.vertexCount();
        mesh.push(this.quad.x, this.quad.y, this.color, u1, v1);
        mesh.push(this.quad.x + this.quad.width, this.quad.y, this.color, u2, v1);
        mesh.push(this.quad.x + this.quad.width, this.quad.y + this.quad.height, this.color, u2, v2);
        mesh.push(this.quad.x, this.quad.y + this.quad.height, this.color, u1, v2);
        mesh.indices.ensureCapacity(6);
        int idx = mesh.indices.size;
        mesh.indices.items[idx++] = vtx;
        mesh.indices.items[idx++] = (short)(vtx + 1);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 3);
        mesh.indices.items[idx++] = vtx;
        mesh.indices.size += 6;
        return result;
    }

    private void getQuad(BitmapFont.Glyph glyph, SpriteMesh mesh, float ox, float oy) {
        float scaleX = this.font.getScaleX();
        float scaleY = this.font.getScaleY();
        float x = ox + (float)glyph.xoffset * scaleX;
        float y = oy + (float)glyph.yoffset * scaleY;
        float w = (float)glyph.width * scaleX;
        float h = (float)glyph.height * scaleY;
        if (w <= 0.0f) {
            return;
        }
        float u1 = glyph.u;
        float u2 = glyph.u2;
        float v1 = glyph.v;
        float v2 = glyph.v2;
        short vtx = (short)mesh.vertexCount();
        mesh.push(x, y, this.color, u1, v1);
        mesh.push(x + w, y, this.color, u2, v1);
        mesh.push(x + w, y + h, this.color, u2, v2);
        mesh.push(x, y + h, this.color, u1, v2);
        mesh.indices.ensureCapacity(6);
        int idx = mesh.indices.size;
        mesh.indices.items[idx++] = vtx;
        mesh.indices.items[idx++] = (short)(vtx + 1);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 3);
        mesh.indices.items[idx++] = vtx;
        mesh.indices.size += 6;
    }

    private boolean getOutline(BitmapFont.Glyph glyph, SpriteMesh mesh, Rectangle rect, float ox, float oy) {
        float scaleX = this.font.getScaleX();
        float scaleY = this.font.getScaleY();
        float x = ox + (float)glyph.xoffset * scaleX;
        float y = oy + (float)glyph.yoffset * scaleY;
        float w = (float)glyph.width * scaleX;
        float h = (float)glyph.height * scaleY;
        this.quad.set(x, y, w, h);
        if (!rect.overlaps(this.quad) || w <= 0.0f) {
            return this.quad.x + this.quad.width <= rect.x + rect.width;
        }
        this.intersect(this.quad, rect, this.quad);
        boolean result = this.quad.x + this.quad.width <= rect.x + rect.width;
        short vtx = (short)mesh.vertexCount();
        mesh.push(this.quad.x, this.quad.y);
        mesh.push(this.quad.x + this.quad.width, this.quad.y);
        mesh.push(this.quad.x + this.quad.width, this.quad.y + this.quad.height);
        mesh.push(this.quad.x, this.quad.y + this.quad.height);
        mesh.indices.ensureCapacity(8);
        int idx = mesh.indices.size;
        mesh.indices.items[idx++] = vtx;
        mesh.indices.items[idx++] = (short)(vtx + 1);
        mesh.indices.items[idx++] = (short)(vtx + 1);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 3);
        mesh.indices.items[idx++] = (short)(vtx + 3);
        mesh.indices.items[idx++] = vtx;
        mesh.indices.size += 8;
        return result;
    }

    private void getOutline(BitmapFont.Glyph glyph, SpriteMesh mesh, float ox, float oy) {
        float scaleX = this.font.getScaleX();
        float scaleY = this.font.getScaleY();
        float x = ox + (float)glyph.xoffset * scaleX;
        float y = oy + (float)glyph.yoffset * scaleY;
        float w = (float)glyph.width * scaleX;
        float h = (float)glyph.height * scaleY;
        if (w <= 0.0f) {
            return;
        }
        short vtx = (short)mesh.vertexCount();
        mesh.push(this.quad.x, this.quad.y);
        mesh.push(this.quad.x + this.quad.width, this.quad.y);
        mesh.push(this.quad.x + this.quad.width, this.quad.y + this.quad.height);
        mesh.push(this.quad.x, this.quad.y + this.quad.height);
        mesh.indices.ensureCapacity(8);
        int idx = mesh.indices.size;
        mesh.indices.items[idx++] = vtx;
        mesh.indices.items[idx++] = (short)(vtx + 1);
        mesh.indices.items[idx++] = (short)(vtx + 1);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 2);
        mesh.indices.items[idx++] = (short)(vtx + 3);
        mesh.indices.items[idx++] = (short)(vtx + 3);
        mesh.indices.items[idx++] = vtx;
        mesh.indices.size += 8;
    }

    public static UnicodeType getUnicodeType(int code) {
        switch (code) {
            case 9: 
            case 32: 
            case 160: {
                return UnicodeType.SPACE;
            }
            case 10: 
            case 13: 
            case 133: {
                return UnicodeType.NEWLINE;
            }
        }
        if (code == 0 || code == 11 || code == 12 || 28 <= code && code <= 31) {
            return UnicodeType.CONTROL;
        }
        if (code >= 19968 && code <= 40959 || code >= 12288 && code <= 12543 || code >= 65280 && code <= 65519 || code >= 4352 && code <= 4607 || code >= 12592 && code <= 12687 || code >= 44032 && code <= 55215) {
            return UnicodeType.CJK;
        }
        return UnicodeType.CHAR;
    }

    private boolean isNewline(char c) {
        this.codepoint[0] = c;
        int value = Character.codePointAt(this.codepoint, 0);
        return TextLayout.getUnicodeType(value) == UnicodeType.NEWLINE;
    }

    public static enum UnicodeType {
        CHAR,
        CJK,
        SPACE,
        NEWLINE,
        CONTROL;

    }
}

