/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.backend;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.lwjgl3.audio.JavaSoundAudioRecorder;
import com.badlogic.gdx.backends.lwjgl3.audio.Lwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALMusic;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALSound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.audio.AudioEngine;
import edu.cornell.gdiac.audio.AudioSource;
import edu.cornell.gdiac.audio.AudioStream;
import edu.cornell.gdiac.audio.EffectFilter;
import edu.cornell.gdiac.audio.MusicQueue;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.backend.Effect;
import edu.cornell.gdiac.backend.EffectFactory;
import edu.cornell.gdiac.backend.audio.AudioDeviceAdapter;
import edu.cornell.gdiac.backend.audio.AudioRecorderAdapter;
import edu.cornell.gdiac.backend.audio.Mp3Source;
import edu.cornell.gdiac.backend.audio.OggSource;
import edu.cornell.gdiac.backend.audio.OpenALBuffer;
import edu.cornell.gdiac.backend.audio.WavSource;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALUtil;
import org.lwjgl.openal.EXTEfx;
import org.lwjgl.openal.SOFTReopenDevice;

public class GDXAudio
implements AudioEngine,
Lwjgl3Audio {
    private final int deviceBufferSize;
    private final int deviceBufferCount;
    private boolean noDevice = false;
    private long device;
    private long context;
    private ObjectMap<String, Class<?>> extensionToFormat = new ObjectMap();
    private IntArray allSources;
    private IntIntMap sourceToIndex = new IntIntMap();
    private IntIntMap indexToSource = new IntIntMap();
    private OpenALBuffer[] buffers;
    private int recentIndex;
    private boolean globalPause;
    private boolean[] paused;
    private FloatBuffer floatdata;
    private int[] attributes = new int[4];
    private final int numAuxSlots = 64;
    private int[] auxiliaryEfxSlots;
    private boolean[] slotInUse;
    private String preferredOutputDevice = null;

    public GDXAudio() {
        this(24, 9, 512);
    }

    public GDXAudio(int simultaneousSources, int deviceBufferCount, int deviceBufferSize) {
        int errorCode;
        int ii;
        this.deviceBufferSize = deviceBufferSize;
        this.deviceBufferCount = deviceBufferCount;
        this.registerFormat("ogg", OggSource.class);
        this.registerFormat("wav", WavSource.class);
        this.registerFormat("mp3", Mp3Source.class);
        this.device = ALC10.alcOpenDevice((ByteBuffer)null);
        if (this.device == 0L) {
            this.noDevice = true;
            return;
        }
        ALCCapabilities deviceCapabilities = ALC.createCapabilities((long)this.device);
        this.attributes[0] = ALC10.alcGetInteger((long)this.device, (int)131075);
        this.attributes[1] = 64;
        this.context = ALC10.alcCreateContext((long)this.device, (int[])this.attributes);
        if (this.context == 0L) {
            ALC10.alcCloseDevice((long)this.device);
            this.noDevice = true;
            return;
        }
        if (!ALC10.alcMakeContextCurrent((long)this.context)) {
            this.noDevice = true;
            return;
        }
        AL.createCapabilities((ALCCapabilities)deviceCapabilities);
        AL10.alGetError();
        this.allSources = new IntArray(false, simultaneousSources);
        for (ii = 0; ii < simultaneousSources; ++ii) {
            int sourceId = AL10.alGenSources();
            errorCode = AL10.alGetError();
            if (errorCode != 0) {
                Gdx.app.error("OpenAL", "Unable to allocated source: " + AL10.alGetString((int)errorCode));
                ii = simultaneousSources;
                continue;
            }
            this.sourceToIndex.put(sourceId, this.allSources.size);
            this.indexToSource.put(this.allSources.size, sourceId);
            this.allSources.add(sourceId);
        }
        Effect.engine = this;
        this.auxiliaryEfxSlots = new int[64];
        this.slotInUse = new boolean[64];
        for (ii = 0; ii < 64; ++ii) {
            int slotID = EXTEfx.alGenAuxiliaryEffectSlots();
            errorCode = AL10.alGetError();
            if (errorCode != 0) {
                Gdx.app.error("OpenAL", "Unable to allocated auxillary slot: " + ii);
                break;
            }
            this.auxiliaryEfxSlots[ii] = slotID;
        }
        this.buffers = new OpenALBuffer[simultaneousSources];
        this.recentIndex = simultaneousSources - 1;
        this.paused = new boolean[simultaneousSources];
        this.globalPause = false;
        this.floatdata = BufferUtils.createFloatBuffer((int)4);
    }

    public boolean loadEffect(EffectFilter effect) {
        int effectId = ((Effect)effect).getId();
        if (!EXTEfx.alIsEffect((int)effectId)) {
            Gdx.app.error("OpenAL", "effect is corrupted");
            return false;
        }
        if (((Effect)effect).slot != -1) {
            return true;
        }
        int selectedSlotI = -1;
        for (int i = 0; i < this.auxiliaryEfxSlots.length; ++i) {
            if (this.slotInUse[i]) continue;
            selectedSlotI = i;
            break;
        }
        if (selectedSlotI == -1) {
            return false;
        }
        EXTEfx.alAuxiliaryEffectSloti((int)this.auxiliaryEfxSlots[selectedSlotI], (int)1, (int)effectId);
        ((Effect)effect).slot = selectedSlotI;
        int erCode = AL10.alGetError();
        if (erCode != 0) {
            Gdx.app.error("OpenAL", "Error! Code: " + erCode);
            return false;
        }
        return true;
    }

    public void unloadEffect(int slot) {
        EXTEfx.alAuxiliaryEffectSloti((int)this.auxiliaryEfxSlots[slot], (int)1, (int)0);
        this.slotInUse[slot] = false;
    }

    public void EmptyEffectSlots() {
        for (int slotId : this.auxiliaryEfxSlots) {
            EXTEfx.alAuxiliaryEffectSloti((int)slotId, (int)1, (int)0);
        }
        this.slotInUse = new boolean[this.slotInUse.length];
    }

    public boolean setEffect(int sourceId, EffectFilter effect, int sendSlot) {
        if (!EXTEfx.alIsEffect((int)((Effect)effect).getId()) || !AL10.alIsSource((int)sourceId)) {
            Gdx.app.error("OpenAL", "source or effect not valid");
            return false;
        }
        if (((Effect)effect).slot == -1 && !this.loadEffect(effect)) {
            return false;
        }
        AL11.alSource3i((int)sourceId, (int)131078, (int)this.auxiliaryEfxSlots[((Effect)effect).slot], (int)sendSlot, (int)0);
        int errCode = AL10.alGetError();
        if (errCode != 0) {
            Gdx.app.error("OpenAL", "error code " + errCode);
            return false;
        }
        return true;
    }

    public void removeEffect(int sourceId, int sendSlot) {
        if (!AL10.alIsSource((int)sourceId)) {
            return;
        }
        AL11.alSource3i((int)sourceId, (int)131078, (int)0, (int)sendSlot, (int)0);
    }

    public void dispose() {
        int ii;
        if (this.noDevice) {
            return;
        }
        for (ii = 0; ii < this.buffers.length; ++ii) {
            if (this.buffers[ii] == null) continue;
            this.buffers[ii].stop();
            this.buffers[ii] = null;
        }
        int n = this.allSources.size;
        for (ii = 0; ii < n; ++ii) {
            int sourceId = this.allSources.get(ii);
            int state = AL10.alGetSourcei((int)sourceId, (int)4112);
            if (state != 4116) {
                AL10.alSourceStop((int)sourceId);
            }
            AL10.alDeleteSources((int)sourceId);
        }
        this.allSources.clear();
        this.sourceToIndex.clear();
        this.indexToSource.clear();
        ALC10.alcDestroyContext((long)this.context);
        ALC10.alcCloseDevice((long)this.device);
    }

    public void registerFormat(String extension, Class<?> theClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (theClass == null) {
            throw new IllegalArgumentException("soundClass cannot be null.");
        }
        this.extensionToFormat.put((Object)extension, theClass);
    }

    @Override
    public AudioSource newSource(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file + " does not exist.");
        }
        Class format = (Class)this.extensionToFormat.get((Object)file.extension().toLowerCase());
        if (format == null) {
            throw new GdxRuntimeException("Unknown file extension for sound: " + file);
        }
        try {
            return (AudioSource)format.getConstructor(FileHandle.class).newInstance(file);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating " + format.getName() + " for file: " + file, (Throwable)ex);
        }
    }

    @Override
    public SoundHandle newSound(FileHandle file) {
        if (this.noDevice) {
            return null;
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file + " does not exist.");
        }
        Class format = (Class)this.extensionToFormat.get((Object)file.extension().toLowerCase());
        if (format == null) {
            throw new GdxRuntimeException("Unknown file extension for sound: " + file);
        }
        try {
            AudioSource sample = (AudioSource)format.getConstructor(FileHandle.class).newInstance(file);
            return new SoundHandle(sample);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating " + format.getName() + " for file: " + file, (Throwable)ex);
        }
    }

    @Override
    public SoundEffect newSoundEffect(AudioSource source) {
        if (this.noDevice) {
            return null;
        }
        return new SoundHandle(source);
    }

    @Override
    public MusicHandle newMusic(FileHandle file) {
        if (this.noDevice) {
            return null;
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file + " does not exist.");
        }
        Class format = (Class)this.extensionToFormat.get((Object)file.extension().toLowerCase());
        if (format == null) {
            throw new GdxRuntimeException("Unknown file extension for sound: " + file);
        }
        try {
            AudioSource sample = (AudioSource)format.getConstructor(FileHandle.class).newInstance(file);
            return new MusicHandle(sample);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating " + format.getName() + " for file: " + file, (Throwable)ex);
        }
    }

    @Override
    public MusicQueue newMusicQueue(boolean isMono, int sampleRate) {
        if (this.noDevice) {
            return null;
        }
        return new MusicHandle(isMono, sampleRate);
    }

    public AudioDevice newAudioDevice(int sampleRate, boolean isMono) {
        if (this.noDevice) {
            return new AudioDeviceAdapter(isMono);
        }
        return new Device(isMono, sampleRate, this.deviceBufferSize, this.deviceBufferCount);
    }

    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        if (this.noDevice) {
            return new AudioRecorderAdapter();
        }
        return new JavaSoundAudioRecorder(samplingRate, isMono);
    }

    @Override
    public int getCapacity() {
        return this.buffers.length;
    }

    @Override
    public void pause() {
        if (!this.noDevice) {
            this.globalPause = true;
            for (int ii = 0; ii < this.paused.length; ++ii) {
                int sourceId = this.indexToSource.get(ii, -1);
                if (this.getSourceState(sourceId) == 4114) {
                    this.paused[ii] = true;
                    AL10.alSourcePause((int)sourceId);
                    continue;
                }
                this.paused[ii] = false;
            }
        }
    }

    @Override
    public void resume() {
        if (!this.noDevice) {
            for (int ii = 0; ii < this.paused.length; ++ii) {
                if (!this.paused[ii]) continue;
                int sourceId = this.indexToSource.get(ii, -1);
                AL10.alSourcePlay((int)sourceId);
                this.paused[ii] = false;
            }
        }
        this.globalPause = false;
    }

    @Override
    public edu.cornell.gdiac.audio.EffectFactory getEffectFactory() {
        return new EffectFactory();
    }

    protected int obtainSource(OpenALBuffer sound) {
        if (this.noDevice) {
            return 0;
        }
        int sourceId = -1;
        int next = (this.recentIndex + 1) % this.buffers.length;
        while (next != this.recentIndex && sourceId == -1) {
            if (this.buffers[next] == null) {
                this.buffers[next] = sound;
                sourceId = this.indexToSource.get(next, -1);
                this.recentIndex = next;
            }
            next = (next + 1) % this.buffers.length;
        }
        if (sourceId == -1) {
            next = (this.recentIndex + 1) % this.buffers.length;
            while (next != this.recentIndex && sourceId == -1) {
                if (this.buffers[next] != null && this.buffers[next].evictable()) {
                    sourceId = this.indexToSource.get(next, -1);
                    this.stopSource(sourceId);
                    this.buffers[next] = sound;
                    this.recentIndex = next;
                }
                next = (next + 1) % this.buffers.length;
            }
        }
        return sourceId;
    }

    protected void freeSource(int sourceId) {
        if (this.noDevice) {
            return;
        }
        AL10.alSourceStop((int)sourceId);
        AL10.alSourcei((int)sourceId, (int)4105, (int)0);
        int index = this.sourceToIndex.get(sourceId, -1);
        this.buffers[index] = null;
    }

    public void stopSource(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alSourceStop((int)sourceId);
            AL10.alSourcei((int)sourceId, (int)4105, (int)0);
            this.buffers[this.sourceToIndex.get((int)sourceId, (int)-1)] = null;
        }
    }

    public void pauseSource(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            if (this.globalPause) {
                this.paused[this.sourceToIndex.get((int)sourceId, (int)-1)] = true;
            } else if (AL10.alGetSourcei((int)sourceId, (int)4112) == 4114) {
                AL10.alSourcePause((int)sourceId);
            }
        }
    }

    public void resumeSource(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            if (this.globalPause) {
                this.paused[this.sourceToIndex.get((int)sourceId, (int)-1)] = true;
            } else if (AL10.alGetSourcei((int)sourceId, (int)4112) == 4115) {
                AL10.alSourcePlay((int)sourceId);
            }
        }
    }

    public int getSourceState(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            return AL10.alGetSourcei((int)sourceId, (int)4112);
        }
        return 4116;
    }

    public void setSourceGain(int sourceId, float gain) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alSourcef((int)sourceId, (int)4106, (float)gain);
        }
    }

    public float getSourceGain(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            return AL10.alGetSourcef((int)sourceId, (int)4106);
        }
        return -1.0f;
    }

    public void setSourceLoop(int sourceId, boolean loop) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alSourcei((int)sourceId, (int)4103, (int)(loop ? 1 : 0));
        }
    }

    public boolean getSourceLoop(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            return AL10.alGetSourcei((int)sourceId, (int)4103) == 1;
        }
        return false;
    }

    public void setSourcePitch(int sourceId, float pitch) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alSourcef((int)sourceId, (int)4099, (float)pitch);
        }
    }

    public float getSourcePitch(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            return AL10.alGetSourcef((int)sourceId, (int)4099);
        }
        return 1.0f;
    }

    public void setSourcePan(int sourceId, float pan) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alSource3f((int)sourceId, (int)4100, (float)MathUtils.cos((float)((pan - 1.0f) * (float)Math.PI / 2.0f)), (float)0.0f, (float)MathUtils.sin((float)((pan + 1.0f) * (float)Math.PI / 2.0f)));
        }
    }

    public float getSourcePan(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alGetSourcef((int)sourceId, (int)4100, (FloatBuffer)this.floatdata);
            float x = (float)Math.acos(this.floatdata.get());
            this.floatdata.clear();
            return 2.0f * x / (float)Math.PI + 1.0f;
        }
        return 0.0f;
    }

    public void setSourceSecOffset(int sourceId, float seconds) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alSourcef((int)sourceId, (int)4132, (float)seconds);
        }
    }

    public float getSourceSecOffset(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            return AL10.alGetSourcef((int)sourceId, (int)4132);
        }
        return -1.0f;
    }

    public void setSourceByteOffset(int sourceId, int offset) {
        if (sourceId != -1 && !this.noDevice) {
            AL10.alSourcei((int)sourceId, (int)4134, (int)offset);
        }
    }

    public int getSourceByteOffset(int sourceId) {
        if (sourceId != -1 && !this.noDevice) {
            return AL10.alGetSourcei((int)sourceId, (int)4134);
        }
        return -1;
    }

    public void update() {
        if (this.noDevice) {
            return;
        }
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            if (this.buffers[ii] == null) continue;
            this.buffers[ii].update(this.indexToSource.get(ii, -1));
        }
    }

    public boolean switchOutputDevice(String deviceIdentifier) {
        return this.switchOutputDevice(deviceIdentifier, true);
    }

    private boolean switchOutputDevice(String deviceIdentifier, boolean setPreferred) {
        if (setPreferred) {
            this.preferredOutputDevice = deviceIdentifier;
        }
        return SOFTReopenDevice.alcReopenDeviceSOFT((long)this.device, (CharSequence)deviceIdentifier, (IntBuffer)null);
    }

    public String[] getAvailableOutputDevices() {
        List devices = ALUtil.getStringList((long)0L, (int)4115);
        if (devices == null) {
            return new String[0];
        }
        return devices.toArray(new String[0]);
    }

    private class SoundHandle
    extends OpenALSound
    implements SoundEffect,
    OpenALBuffer {
        private int bufferId;
        private AudioSource sample;
        private SoundEffect.OnCompletionListener onCompletionListener;
        private LongMap<Integer> soundToSource;
        private IntMap<Long> sourceToSound;
        private long nextSound;
        private LongMap<EffectFilter[]> soundtoEffect;

        public SoundHandle(AudioSource sample) {
            super(null);
            this.bufferId = -1;
            this.onCompletionListener = null;
            this.nextSound = 0L;
            this.sample = sample;
            ByteBuffer buffer = sample.getData();
            int bytesize = buffer.limit();
            if (!GDXAudio.this.noDevice) {
                this.bufferId = AL10.alGenBuffers();
                int format = sample.getChannels() > 1 ? 4355 : 4353;
                AL10.alBufferData((int)this.bufferId, (int)format, (ShortBuffer)buffer.asShortBuffer(), (int)sample.getSampleRate());
            }
            this.soundToSource = new LongMap();
            this.sourceToSound = new IntMap();
            this.soundtoEffect = new LongMap();
        }

        protected void finalize() throws Throwable {
            this.dispose();
        }

        public void dispose() {
            if (GDXAudio.this.noDevice || this.bufferId == -1) {
                return;
            }
            for (IntMap.Entry entry : this.sourceToSound.entries()) {
                GDXAudio.this.stopSource(entry.key);
            }
            this.soundToSource.clear();
            this.sourceToSound.clear();
            this.sample = null;
            AL10.alDeleteBuffers((int)this.bufferId);
            this.bufferId = -1;
            this.onCompletionListener = null;
        }

        public long play() {
            return this.play(1.0f);
        }

        public long play(float volume) {
            int sourceId = GDXAudio.this.obtainSource(this);
            if (sourceId == -1) {
                return -1L;
            }
            Long oldSoundId = (Long)this.sourceToSound.remove(sourceId);
            if (oldSoundId != null) {
                this.soundToSource.remove(oldSoundId.longValue());
            }
            long soundId = this.nextSound++;
            this.sourceToSound.put(sourceId, (Object)soundId);
            this.soundToSource.put(soundId, (Object)sourceId);
            AL10.alSourcei((int)sourceId, (int)4105, (int)this.bufferId);
            AL10.alSourcei((int)sourceId, (int)4103, (int)0);
            AL10.alSourcef((int)sourceId, (int)4106, (float)volume);
            if (GDXAudio.this.globalPause) {
                ((GDXAudio)GDXAudio.this).paused[((GDXAudio)GDXAudio.this).sourceToIndex.get((int)sourceId, (int)-1)] = true;
            } else {
                AL10.alSourcePlay((int)sourceId);
            }
            return soundId;
        }

        public long play(float volume, float pitch, float pan) {
            long id = this.play();
            if (id != -1L) {
                int sourceId = (Integer)this.soundToSource.get(id);
                GDXAudio.this.setSourcePitch(sourceId, pitch);
                GDXAudio.this.setSourcePan(sourceId, pan);
                GDXAudio.this.setSourceGain(sourceId, volume);
            }
            return id;
        }

        public long loop() {
            return this.loop(1.0f);
        }

        public long loop(float volume) {
            int sourceId = GDXAudio.this.obtainSource(this);
            if (sourceId == -1) {
                return -1L;
            }
            Long oldSoundId = (Long)this.sourceToSound.remove(sourceId);
            if (oldSoundId != null) {
                this.soundToSource.remove(oldSoundId.longValue());
            }
            long soundId = this.nextSound++;
            this.sourceToSound.put(sourceId, (Object)soundId);
            this.soundToSource.put(soundId, (Object)sourceId);
            AL10.alSourcei((int)sourceId, (int)4105, (int)this.bufferId);
            AL10.alSourcei((int)sourceId, (int)4103, (int)1);
            AL10.alSourcef((int)sourceId, (int)4106, (float)volume);
            if (GDXAudio.this.globalPause) {
                ((GDXAudio)GDXAudio.this).paused[((GDXAudio)GDXAudio.this).sourceToIndex.get((int)sourceId, (int)-1)] = true;
            } else {
                AL10.alSourcePlay((int)sourceId);
            }
            return soundId;
        }

        public long loop(float volume, float pitch, float pan) {
            long id = this.loop();
            if (id != -1L) {
                int sourceId = (Integer)this.soundToSource.get(id);
                GDXAudio.this.setSourcePitch(sourceId, pitch);
                GDXAudio.this.setSourcePan(sourceId, pan);
                GDXAudio.this.setSourceGain(sourceId, volume);
            }
            return id;
        }

        @Override
        public void stop() {
            for (IntMap.Entry entry : this.sourceToSound.entries()) {
                GDXAudio.this.stopSource(entry.key);
                if (this.onCompletionListener == null) continue;
                this.onCompletionListener.onCompletion(this, (Long)entry.value);
            }
            this.soundToSource.clear();
            this.sourceToSound.clear();
            this.soundtoEffect.clear();
        }

        public void stop(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.remove(soundId);
            if (sourceId != null) {
                GDXAudio.this.stopSource(sourceId);
                this.sourceToSound.remove(sourceId.intValue());
                this.soundtoEffect.remove(soundId);
                if (this.onCompletionListener != null) {
                    this.onCompletionListener.onCompletion(this, soundId);
                }
            }
        }

        @Override
        public void pause() {
            for (IntMap.Entry entry : this.sourceToSound.entries()) {
                GDXAudio.this.pauseSource(entry.key);
            }
        }

        public void pause(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            GDXAudio.this.pauseSource(sourceId != null ? sourceId : -1);
        }

        @Override
        public void resume() {
            for (IntMap.Entry entry : this.sourceToSound.entries()) {
                GDXAudio.this.resumeSource(entry.key);
            }
        }

        public void resume(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            GDXAudio.this.resumeSource(sourceId != null ? sourceId : -1);
        }

        @Override
        public void setVolume(long soundId, float volume) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            GDXAudio.this.setSourceGain(sourceId != null ? sourceId : -1, volume);
        }

        @Override
        public void setLooping(long soundId, boolean looping) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            GDXAudio.this.setSourceLoop(sourceId != null ? sourceId : -1, looping);
        }

        public void setPitch(long soundId, float pitch) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            GDXAudio.this.setSourcePitch(sourceId != null ? sourceId : -1, pitch);
        }

        public void setPan(long soundId, float pan, float volume) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            int id = sourceId != null ? sourceId : -1;
            GDXAudio.this.setSourcePan(id, pan);
            GDXAudio.this.setSourceGain(id, volume);
        }

        @Override
        public void addEffect(long soundId, EffectFilter effect) {
            if (!this.soundtoEffect.containsKey(soundId)) {
                this.soundtoEffect.put(soundId, (Object)new EffectFilter[GDXAudio.this.attributes[0]]);
            }
            EffectFilter[] sends = (EffectFilter[])this.soundtoEffect.get(soundId);
            for (int i = 0; i < sends.length; ++i) {
                if (sends[i] != null) continue;
                if (!GDXAudio.this.setEffect((Integer)this.soundToSource.get(soundId), effect, i)) break;
                sends[i] = effect;
                break;
            }
        }

        @Override
        public void removeEffect(long soundId, EffectFilter effect) {
            if (!this.soundtoEffect.containsKey(soundId)) {
                return;
            }
            EffectFilter[] sends = (EffectFilter[])this.soundtoEffect.get(soundId);
            for (int i = 0; i < sends.length; ++i) {
                if (sends[i] != effect) continue;
                GDXAudio.this.removeEffect((Integer)this.soundToSource.get(soundId), i);
                sends[i] = null;
                break;
            }
        }

        @Override
        public FileHandle getFile() {
            return this.sample.getFile();
        }

        @Override
        public boolean isMono() {
            return this.sample.getChannels() == 1;
        }

        @Override
        public int getSampleRate() {
            return this.sample.getSampleRate();
        }

        @Override
        public float getDuration() {
            return this.sample.getDuration();
        }

        @Override
        public boolean isPlaying(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            return GDXAudio.this.getSourceState(sourceId != null ? sourceId : -1) == 4114;
        }

        @Override
        public float getPosition(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            return GDXAudio.this.getSourceState(sourceId != null ? sourceId : -1);
        }

        @Override
        public void setPosition(long soundId, float seconds) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            GDXAudio.this.setSourceSecOffset(sourceId != null ? sourceId : -1, seconds);
        }

        @Override
        public float getVolume(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            return GDXAudio.this.getSourceGain(sourceId != null ? sourceId : -1);
        }

        @Override
        public boolean getLooping(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            return GDXAudio.this.getSourceLoop(sourceId != null ? sourceId : -1);
        }

        @Override
        public float getPitch(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            return GDXAudio.this.getSourcePitch(sourceId != null ? sourceId : -1);
        }

        @Override
        public void setPan(long soundId, float pan) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            GDXAudio.this.setSourcePan(sourceId != null ? sourceId : -1, pan);
        }

        @Override
        public float getPan(long soundId) {
            Integer sourceId = (Integer)this.soundToSource.get(soundId);
            return GDXAudio.this.getSourcePan(sourceId != null ? sourceId : -1);
        }

        @Override
        public void setOnCompletionListener(SoundEffect.OnCompletionListener listener) {
            this.onCompletionListener = listener;
        }

        @Override
        public void update() {
            for (IntMap.Entry entry : this.sourceToSound.entries()) {
                this.update(entry.key);
            }
        }

        @Override
        public void update(int sourceId) {
            Long soundId;
            int state = AL10.alGetSourcei((int)sourceId, (int)4112);
            if (state != 4114 && state != 4115 && (soundId = (Long)this.sourceToSound.get(sourceId)) != null) {
                GDXAudio.this.stopSource(sourceId);
                if (this.onCompletionListener != null) {
                    this.onCompletionListener.onCompletion(this, soundId);
                }
            }
        }

        @Override
        public boolean evictable() {
            return true;
        }
    }

    private class MusicHandle
    extends OpenALMusic
    implements MusicQueue,
    OpenALBuffer {
        private static final int MINIMUM_SIZE = 16384;
        private final int bufferSize;
        private final int bufferCount = 3;
        private final int bytesPerSample = 2;
        private final byte[] tempBytes;
        private final ByteBuffer tempBuffer;
        private int sourceId;
        private IntBuffer allBuffers;
        private IntIntMap usedBuffers;
        private int bufferAvail;
        private int nextBuffer;
        private boolean isPlaying;
        private boolean isLooping;
        private boolean loopLocal;
        private float volume;
        private float pitch;
        private float pan;
        private int format;
        private int sampleRate;
        private Array<AudioSource> samples;
        private Array<AudioStream> streams;
        private int position;
        private long renderedBytes;
        private AudioSource orphaned;
        private int bufferStart;
        private AudioSource[] leaving;
        private AudioSource[] arriving;
        private long[] byteoffs;
        private Music.OnCompletionListener onCompletionListener;
        private MusicQueue.OnTransitionListener onTransitionListener;
        private EffectFilter[] effects;

        public MusicHandle(boolean isMono, int sampleRate) {
            super(null, null);
            this.bufferSize = Math.max(16384, GDXAudio.this.deviceBufferSize);
            this.bufferCount = 3;
            this.bytesPerSample = 2;
            this.tempBytes = new byte[this.bufferSize];
            this.tempBuffer = BufferUtils.createByteBuffer((int)this.bufferSize);
            this.sourceId = -1;
            this.volume = 1.0f;
            this.pitch = 1.0f;
            this.pan = 0.0f;
            this.position = 0;
            this.renderedBytes = 0L;
            this.bufferStart = 0;
            this.onCompletionListener = null;
            this.onTransitionListener = null;
            this.effects = new EffectFilter[GDXAudio.this.attributes[0]];
            this.format = isMono ? 4353 : 4355;
            this.sampleRate = sampleRate;
            this.samples = new Array();
            this.streams = new Array();
            this.position = -1;
            this.allocBuffers();
        }

        public MusicHandle(AudioSource sample) {
            this(sample.getChannels() == 1, sample.getSampleRate());
            if (sample.getChannels() > 2) {
                throw new IllegalArgumentException(String.format("OpenAL does not support more than two channels (found %d)", sample.getChannels()));
            }
            this.samples.add((Object)sample);
            this.streams.add((Object)sample.getStream());
            this.position = 0;
        }

        private void allocBuffers() {
            if (this.allBuffers == null) {
                this.allBuffers = BufferUtils.createIntBuffer((int)3);
                AL10.alGenBuffers((IntBuffer)this.allBuffers);
                int errorCode = AL10.alGetError();
                if (errorCode != 0) {
                    throw new GdxRuntimeException("Unable to allocate audio buffers. AL Error: " + errorCode);
                }
                this.bufferAvail = 3;
                this.usedBuffers = new IntIntMap();
                for (int ii = 0; ii < 3; ++ii) {
                    this.usedBuffers.put(this.allBuffers.get(ii), 0);
                }
                this.nextBuffer = 0;
                int min = this.allBuffers.get(0);
                int max = this.allBuffers.get(0);
                for (int ii = 1; ii < 3; ++ii) {
                    int temp = this.allBuffers.get(ii);
                    if (temp < min) {
                        min = temp;
                    }
                    if (temp <= max) continue;
                    max = temp;
                }
                this.bufferStart = min;
                this.leaving = new AudioSource[max - min + 1];
                this.arriving = new AudioSource[max - min + 1];
                this.byteoffs = new long[max - min + 1];
            }
        }

        private boolean initBuffers() {
            int bufferId;
            boolean filled = false;
            while (this.bufferAvail > 0 && (bufferId = this.obtainBuffer()) != -1 && this.fill(bufferId)) {
                filled = true;
                AL10.alSourceQueueBuffers((int)this.sourceId, (int)bufferId);
                int error = AL10.alGetError();
                if (error == 0) continue;
                Gdx.app.error("OpenAL", "Music buffer " + bufferId + " could not be initialized: " + AL10.alGetString((int)error));
                this.stop();
                return false;
            }
            return filled;
        }

        public void dispose() {
            this.stop();
            if (this.allBuffers != null) {
                AL10.alDeleteBuffers((IntBuffer)this.allBuffers);
                this.allBuffers = null;
            }
            this.samples.clear();
            this.streams.clear();
            this.onCompletionListener = null;
            this.onTransitionListener = null;
        }

        public synchronized void updateEffect() {
            if (this.sourceId == -1) {
                return;
            }
            for (int i = 0; i < this.effects.length; ++i) {
                if (this.effects[i] != null) {
                    GDXAudio.this.setEffect(this.sourceId, this.effects[i], i);
                    continue;
                }
                GDXAudio.this.removeEffect(this.sourceId, i);
            }
        }

        public synchronized void play() {
            if (this.sourceId == -1) {
                this.sourceId = GDXAudio.this.obtainSource(this);
                if (this.sourceId == -1) {
                    return;
                }
                this.position = 0;
                GDXAudio.this.setSourceLoop(this.sourceId, false);
                this.setPan(this.pan, this.volume);
                boolean filled = this.initBuffers();
                if (!filled && this.onCompletionListener != null) {
                    this.onCompletionListener.onCompletion((Music)this);
                }
            }
            if (!this.isPlaying) {
                if (GDXAudio.this.globalPause) {
                    ((GDXAudio)GDXAudio.this).paused[((GDXAudio)GDXAudio.this).sourceToIndex.get((int)this.sourceId, (int)-1)] = true;
                } else {
                    this.updateEffect();
                    GDXAudio.this.setSourceGain(this.sourceId, this.volume);
                    GDXAudio.this.setSourcePitch(this.sourceId, this.pitch);
                    GDXAudio.this.setSourcePan(this.sourceId, this.pan);
                    AL10.alSourcePlay((int)this.sourceId);
                }
                this.isPlaying = true;
            }
        }

        @Override
        public synchronized void pause() {
            GDXAudio.this.pauseSource(this.sourceId);
            this.isPlaying = false;
        }

        @Override
        public synchronized void resume() {
            GDXAudio.this.resumeSource(this.sourceId);
            this.isPlaying = true;
        }

        @Override
        public synchronized void stop() {
            if (this.sourceId != -1) {
                this.reset();
                GDXAudio.this.freeSource(this.sourceId);
                this.sourceId = -1;
                this.isPlaying = false;
            }
        }

        public synchronized boolean isPlaying() {
            return this.isPlaying && !GDXAudio.this.globalPause;
        }

        public synchronized void setVolume(float volume) {
            this.volume = volume;
            GDXAudio.this.setSourceGain(this.sourceId, volume);
        }

        public synchronized float getVolume() {
            return this.volume;
        }

        public synchronized void setLooping(boolean isLooping) {
            this.isLooping = isLooping;
        }

        public synchronized boolean isLooping() {
            return this.isLooping;
        }

        public synchronized void setPan(float pan, float volume) {
            this.volume = volume;
            this.pan = pan;
            GDXAudio.this.setSourcePan(this.sourceId, pan);
            GDXAudio.this.setSourceGain(this.sourceId, volume);
        }

        public synchronized void setPosition(float seconds) {
            int location;
            if (this.sourceId == -1) {
                return;
            }
            boolean wasPlaying = this.isPlaying;
            this.isPlaying = false;
            AL10.alSourceStop((int)this.sourceId);
            this.unqueueBuffers();
            long bytesPerFrame = this.format == 4353 ? 2 : 4;
            long byteOffs = (long)(seconds * (float)this.sampleRate) * bytesPerFrame;
            for (location = 0; location < this.samples.size && byteOffs >= ((AudioStream)this.streams.get(location)).getByteSize(); byteOffs -= ((AudioStream)this.streams.get(location)).getByteSize(), ++location) {
            }
            if (location != this.position) {
                ((AudioStream)this.streams.get(this.position)).reset();
                this.position = location;
            }
            boolean filled = false;
            if (this.position < this.streams.size) {
                int length = 0;
                length = ((AudioStream)this.streams.get(this.position)).seek(byteOffs, this.tempBytes);
                if (length > 0) {
                    int bufferId = this.obtainBuffer();
                    this.tempBuffer.clear();
                    this.tempBuffer.put(this.tempBytes, 0, length).flip();
                    AL10.alBufferData((int)bufferId, (int)this.format, (ByteBuffer)this.tempBuffer, (int)this.sampleRate);
                    AL10.alSourceQueueBuffers((int)this.sourceId, (int)bufferId);
                    int error = AL10.alGetError();
                    if (error != 0) {
                        Gdx.app.error("OpenAL", "Stream seek position failed: " + AL10.alGetString((int)error));
                        this.stop();
                    } else {
                        this.initBuffers();
                        filled = true;
                    }
                } else {
                    filled = this.initBuffers();
                }
            }
            if (!filled) {
                this.stop();
                if (this.onCompletionListener != null) {
                    this.onCompletionListener.onCompletion((Music)this);
                }
                if (this.onTransitionListener != null) {
                    this.onTransitionListener.onCompletion(this, (AudioSource)this.samples.get(this.samples.size - 1));
                }
                return;
            }
            if (wasPlaying) {
                AL10.alSourcePlay((int)this.sourceId);
                this.isPlaying = true;
            }
        }

        @Override
        public void addEffect(EffectFilter effect) {
            for (EffectFilter effectFilter : this.effects) {
                if (effectFilter != effect) continue;
                return;
            }
            for (int i = 0; i < this.effects.length; ++i) {
                if (this.effects[i] != null) continue;
                this.effects[i] = effect;
                break;
            }
            this.updateEffect();
        }

        @Override
        public void removeEffect(EffectFilter effect) {
            for (int i = 0; i < this.effects.length; ++i) {
                if (this.effects[i] != effect) continue;
                this.effects[i] = null;
                break;
            }
            this.updateEffect();
        }

        @Override
        public void clearAllEffect() {
            Arrays.fill(this.effects, null);
            this.updateEffect();
        }

        public synchronized float getPosition() {
            long offset = this.renderedBytes + (long)(this.sourceId != -1 ? AL10.alGetSourcei((int)this.sourceId, (int)4134) : 0);
            long bytesPerFrame = this.format == 4353 ? 2 : 4;
            return (float)offset / (float)((long)this.sampleRate * bytesPerFrame);
        }

        public synchronized void setOnCompletionListener(Music.OnCompletionListener listener) {
            this.onCompletionListener = listener;
        }

        @Override
        public synchronized void setOnTransitionListener(MusicQueue.OnTransitionListener listener) {
            this.onTransitionListener = listener;
        }

        @Override
        public synchronized boolean isMono() {
            return this.format == 4353;
        }

        @Override
        public synchronized int getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public synchronized float getDuration() {
            long totalBytes = 0L;
            for (int ii = 0; ii < this.streams.size; ++ii) {
                totalBytes += ((AudioStream)this.streams.get(ii)).getByteSize();
            }
            return (float)totalBytes / (float)(this.sampleRate * (this.format == 4353 ? 2 : 4));
        }

        @Override
        public synchronized void setPitch(float pitch) {
            this.pitch = pitch;
            GDXAudio.this.setSourcePitch(this.sourceId, pitch);
        }

        @Override
        public synchronized float getPitch() {
            return this.pitch;
        }

        @Override
        public synchronized void setPan(float pan) {
            this.pan = pan;
            GDXAudio.this.setSourcePan(this.sourceId, pan);
        }

        @Override
        public synchronized float getPan() {
            return this.pan;
        }

        @Override
        public synchronized void setLoopBehavior(boolean local) {
            this.loopLocal = local;
        }

        @Override
        public synchronized boolean getLoopBehavior() {
            return this.loopLocal;
        }

        @Override
        public synchronized int getNumberOfSources() {
            return this.samples.size;
        }

        @Override
        public synchronized AudioSource getCurrent() {
            if (this.position >= 0 && this.position < this.samples.size) {
                return (AudioSource)this.samples.get(this.position);
            }
            return null;
        }

        @Override
        public synchronized AudioSource getSource(int pos) {
            return (AudioSource)this.samples.get(pos);
        }

        @Override
        public synchronized void setSource(int pos, AudioSource source) {
            int nformat = 65539;
            if (source.getChannels() <= 2) {
                int n = nformat = source.getChannels() == 1 ? 4353 : 4355;
            }
            if (source.getSampleRate() != this.sampleRate || this.format != nformat) {
                throw new IllegalArgumentException("Source " + source + " does not match the format of this music buffer.");
            }
            this.samples.set(pos, (Object)source);
            this.streams.set(pos, (Object)source.getStream());
        }

        @Override
        public synchronized void addSource(AudioSource source) {
            int nformat = 65539;
            if (source.getChannels() <= 2) {
                int n = nformat = source.getChannels() == 1 ? 4353 : 4355;
            }
            if (source.getSampleRate() != this.sampleRate || this.format != nformat) {
                throw new IllegalArgumentException("Source " + source + " does not match the format of this music buffer.");
            }
            this.samples.add((Object)source);
            this.streams.add((Object)source.getStream());
        }

        @Override
        public synchronized void insertSource(int pos, AudioSource source) {
            int nformat = 65539;
            if (source.getChannels() <= 2) {
                int n = nformat = source.getChannels() == 1 ? 4353 : 4355;
            }
            if (source.getSampleRate() != this.sampleRate || this.format != nformat) {
                throw new IllegalArgumentException("Source " + source + " does not match the format of this music buffer.");
            }
            this.samples.insert(pos, (Object)source);
            this.streams.insert(pos, (Object)source.getStream());
            if (pos < this.position) {
                ++this.position;
            }
        }

        @Override
        public synchronized AudioSource removeSource(int pos) {
            if (this.position == pos) {
                this.orphaned = (AudioSource)this.samples.get(pos);
            }
            this.streams.removeIndex(pos);
            return (AudioSource)this.samples.removeIndex(pos);
        }

        @Override
        public synchronized void clearSources() {
            this.streams.clear();
            this.samples.clear();
        }

        @Override
        public synchronized void advanceSource() {
            this.advanceSource(1);
        }

        @Override
        public synchronized void advanceSource(int steps) {
            if (steps < 0) {
                throw new IllegalArgumentException("Advance may not move backwards");
            }
            boolean wasPlaying = false;
            boolean filled = false;
            if (this.sourceId != -1) {
                wasPlaying = this.isPlaying;
                this.isPlaying = false;
                AL10.alSourceStop((int)this.sourceId);
                this.unqueueBuffers();
            }
            if (steps == 0 && this.position >= 0 && this.position < this.streams.size) {
                ((AudioStream)this.streams.get(this.position)).reset();
            } else {
                if (this.position >= 0 && this.position < this.streams.size) {
                    this.orphaned = (AudioSource)this.samples.get(this.position);
                }
                if (this.isLooping && this.position + steps >= this.streams.size) {
                    int previous = this.position;
                    this.reset();
                    this.position = (previous + steps) % this.streams.size;
                } else {
                    this.position += steps;
                }
            }
            if (this.sourceId != -1) {
                filled = this.initBuffers();
                if (!filled) {
                    this.stop();
                    if (this.onCompletionListener != null) {
                        this.onCompletionListener.onCompletion((Music)this);
                    }
                    if (this.onTransitionListener != null) {
                        this.onTransitionListener.onCompletion(this, (AudioSource)this.samples.get(this.position));
                    }
                    return;
                }
                if (wasPlaying) {
                    AL10.alSourcePlay((int)this.sourceId);
                    this.isPlaying = true;
                }
            }
        }

        @Override
        public synchronized void jumpToSource(int pos) {
            if (pos < 0) {
                pos = 0;
            } else if (pos >= this.streams.size) {
                pos = this.streams.size;
            }
            boolean wasPlaying = false;
            boolean filled = false;
            if (this.sourceId != -1) {
                wasPlaying = this.isPlaying;
                this.isPlaying = false;
                AL10.alSourceStop((int)this.sourceId);
                this.unqueueBuffers();
            }
            this.reset();
            this.position = pos;
            if (this.sourceId != -1) {
                filled = this.initBuffers();
                if (!filled) {
                    this.stop();
                    if (this.onCompletionListener != null) {
                        this.onCompletionListener.onCompletion((Music)this);
                    }
                    if (this.onTransitionListener != null) {
                        this.onTransitionListener.onCompletion(this, (AudioSource)this.samples.get(this.position));
                    }
                    return;
                }
                if (wasPlaying) {
                    AL10.alSourcePlay((int)this.sourceId);
                    this.isPlaying = true;
                }
            }
        }

        @Override
        public synchronized void reset() {
            for (AudioStream stream : this.streams) {
                stream.reset();
            }
            this.position = this.streams.size > 0 ? 0 : -1;
        }

        @Override
        public synchronized void update() {
            this.update(this.sourceId);
        }

        @Override
        public synchronized void update(int sourceId) {
            if (sourceId != -1) {
                boolean end = false;
                int buffers = AL10.alGetSourcei((int)sourceId, (int)4118);
                while (buffers-- > 0) {
                    int bufferId = AL10.alSourceUnqueueBuffers((int)sourceId);
                    if (bufferId == 40963) {
                        Gdx.app.error("OpenAL", "Invalid buffer for music " + this);
                        return;
                    }
                    int offset = bufferId - this.bufferStart;
                    if (offset < 0 || offset > this.byteoffs.length) {
                        offset = bufferId < this.byteoffs.length ? bufferId : this.byteoffs.length - 1;
                    }
                    this.renderedBytes = this.byteoffs[offset];
                    this.usedBuffers.put(bufferId, 0);
                    ++this.bufferAvail;
                    if (!end) {
                        if (this.fill(bufferId)) {
                            AL10.alSourceQueueBuffers((int)sourceId, (int)bufferId);
                            if (this.onTransitionListener != null && this.arriving[offset] != null) {
                                if (this.leaving[offset] != null) {
                                    this.onTransitionListener.onTransition(this, this.leaving[offset], this.arriving[offset]);
                                } else {
                                    this.onTransitionListener.onLoopback(this, this.arriving[offset]);
                                }
                            }
                        } else {
                            end = true;
                        }
                    }
                    this.leaving[offset] = null;
                    this.arriving[offset] = null;
                }
                if (end && AL10.alGetSourcei((int)sourceId, (int)4117) == 0) {
                    this.stop();
                    if (this.onTransitionListener != null) {
                        this.onTransitionListener.onCompletion(this, (AudioSource)this.samples.get(this.samples.size - 1));
                    }
                    if (this.onCompletionListener != null) {
                        this.onCompletionListener.onCompletion((Music)this);
                    }
                } else if (this.isPlaying && AL10.alGetSourcei((int)sourceId, (int)4112) != 4114 && !GDXAudio.this.globalPause) {
                    AL10.alSourcePlay((int)sourceId);
                }
            }
        }

        @Override
        public boolean evictable() {
            return false;
        }

        public synchronized int getChannels() {
            return this.format == 4353 ? 1 : 2;
        }

        public synchronized int read(byte[] buffer) {
            int length = 0;
            if (this.position >= 0 && this.position < this.streams.size) {
                length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                int previous = this.position;
                if (length <= 0 && this.isLooping && this.loopLocal) {
                    ((AudioStream)this.streams.get(this.position)).reset();
                    length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                }
                while (length <= 0 && this.position < this.streams.size - 1) {
                    ++this.position;
                    length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                }
                if (length <= 0 && this.isLooping) {
                    this.reset();
                    this.position = -1;
                    while (length <= 0 && this.position <= previous) {
                        ++this.position;
                        length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                    }
                }
            }
            return length;
        }

        public synchronized void loop() {
            this.reset();
        }

        public synchronized int getSourceId() {
            return this.sourceId;
        }

        private boolean fill(int bufferID) {
            this.tempBuffer.clear();
            int length = 0;
            int offset = bufferID - this.bufferStart;
            if (offset < 0 || offset > this.byteoffs.length) {
                int n = offset = bufferID < this.byteoffs.length ? bufferID : this.byteoffs.length - 1;
            }
            if (this.orphaned != null) {
                this.leaving[offset] = this.orphaned;
                this.arriving[offset] = (AudioSource)this.samples.get(this.position);
                this.orphaned = null;
            }
            if (this.position >= 0 && this.position < this.streams.size) {
                length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                int previous = this.position;
                if (length <= 0 && this.isLooping && this.loopLocal) {
                    ((AudioStream)this.streams.get(this.position)).reset();
                    this.leaving[offset] = null;
                    this.arriving[offset] = (AudioSource)this.samples.get(this.position);
                    length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                }
                while (length <= 0 && this.position < this.streams.size - 1) {
                    ++this.position;
                    this.leaving[offset] = (AudioSource)this.samples.get(previous);
                    this.arriving[offset] = (AudioSource)this.samples.get(this.position);
                    length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                }
                if (length <= 0 && this.isLooping) {
                    this.reset();
                    this.position = -1;
                    while (length <= 0 && this.position <= previous) {
                        ++this.position;
                        this.leaving[offset] = null;
                        this.arriving[offset] = (AudioSource)this.samples.get(this.position);
                        length = ((AudioStream)this.streams.get(this.position)).read(this.tempBytes);
                    }
                }
            }
            if (length <= 0) {
                this.leaving[offset] = null;
                this.arriving[offset] = null;
                return false;
            }
            long totalbytes = 0L;
            for (int ii = 0; ii < this.position; ++ii) {
                totalbytes += ((AudioStream)this.streams.get(ii)).getByteSize();
            }
            this.byteoffs[offset] = totalbytes + ((AudioStream)this.streams.get(this.position)).getByteOffset();
            this.tempBuffer.put(this.tempBytes, 0, length).flip();
            AL10.alBufferData((int)bufferID, (int)this.format, (ByteBuffer)this.tempBuffer, (int)this.sampleRate);
            return true;
        }

        private int obtainBuffer() {
            int endBuffer = (this.nextBuffer + 3 - 1) % 3;
            int ii = this.nextBuffer;
            while (ii != endBuffer) {
                int bufferId = this.allBuffers.get(ii);
                if (this.usedBuffers.get(bufferId, 1) == 0) {
                    this.usedBuffers.put(bufferId, 1);
                    this.nextBuffer = (ii + 1) % 3;
                    --this.bufferAvail;
                    return bufferId;
                }
                ii = (ii + 1) % 3;
            }
            return -1;
        }

        private void unqueueBuffers() {
            int buffers = AL10.alGetSourcei((int)this.sourceId, (int)4118);
            while (buffers-- > 0) {
                int bufferId = AL10.alSourceUnqueueBuffers((int)this.sourceId);
                if (bufferId == 40963) {
                    Gdx.app.error("OpenAL", "Invalid buffer unqueued for music " + this);
                    return;
                }
                int offset = bufferId - this.bufferStart;
                if (offset < 0 || offset > this.byteoffs.length) {
                    offset = bufferId < this.byteoffs.length ? bufferId : this.byteoffs.length - 1;
                }
                this.renderedBytes = this.byteoffs[offset];
                this.usedBuffers.put(bufferId, 0);
                ++this.bufferAvail;
            }
        }
    }

    public class Device
    implements AudioDevice,
    OpenALBuffer {
        private static final int bytesPerSample = 2;
        private final int bufferSize;
        private final int bufferCount;
        private final ByteBuffer tempBuffer;
        private byte[] bytes;
        private IntBuffer allBuffers;
        private IntIntMap usedBuffers;
        private int bufferAvail;
        private int nextBuffer;
        private int sourceId = -1;
        private int format;
        private int sampleRate;
        private boolean isPlaying;
        private float volume = 1.0f;
        private long renderedBytes;
        private int bufferStart = 0;
        private long[] byteoffs;
        float secondsPerBuffer = 0.0f;

        private Device(boolean isMono, int sampleRate, int bufferSize, int bufferCount) {
            int channels = isMono ? 1 : 2;
            this.bufferSize = bufferSize;
            this.bufferCount = bufferCount;
            this.bufferAvail = bufferCount;
            this.format = channels > 1 ? 4355 : 4353;
            this.sampleRate = sampleRate;
            this.secondsPerBuffer = (float)bufferSize / 2.0f / (float)channels / (float)sampleRate;
            this.tempBuffer = BufferUtils.createByteBuffer((int)bufferSize);
            this.allocBuffers();
        }

        private void allocBuffers() {
            if (this.allBuffers == null) {
                this.usedBuffers = new IntIntMap();
                this.allBuffers = BufferUtils.createIntBuffer((int)this.bufferCount);
                AL10.alGenBuffers((IntBuffer)this.allBuffers);
                int errorCode = AL10.alGetError();
                if (errorCode != 0) {
                    throw new GdxRuntimeException("Unable to allocate audio buffers. AL Error: " + errorCode);
                }
                for (int ii = 0; ii < this.bufferCount; ++ii) {
                    this.usedBuffers.put(this.allBuffers.get(ii), 0);
                }
                this.bufferAvail = this.bufferCount;
                this.nextBuffer = 0;
                int min = this.allBuffers.get(0);
                int max = this.allBuffers.get(0);
                for (int ii = 1; ii < this.bufferCount; ++ii) {
                    int temp = this.allBuffers.get(ii);
                    if (temp < min) {
                        min = temp;
                    }
                    if (temp <= max) continue;
                    max = temp;
                }
                this.bufferStart = min;
                this.byteoffs = new long[max - min + 1];
            }
        }

        public void dispose() {
            if (this.allBuffers == null) {
                return;
            }
            if (this.sourceId != -1) {
                GDXAudio.this.freeSource(this.sourceId);
                this.sourceId = -1;
            }
            AL10.alDeleteBuffers((IntBuffer)this.allBuffers);
            this.allBuffers = null;
        }

        public void writeSamples(short[] samples, int offset, int numSamples) {
            if (this.bytes == null || this.bytes.length < numSamples * 2) {
                this.bytes = new byte[numSamples * 2];
            }
            int end = Math.min(offset + numSamples, samples.length);
            int ii = 0;
            for (int i = offset; i < end; ++i) {
                short sample = samples[i];
                this.bytes[ii++] = (byte)(sample & 0xFF);
                this.bytes[ii++] = (byte)(sample >> 8 & 0xFF);
            }
            this.writeBytes(this.bytes, 0, numSamples * 2);
        }

        public void writeSamples(float[] samples, int offset, int numSamples) {
            if (this.bytes == null || this.bytes.length < numSamples * 2) {
                this.bytes = new byte[numSamples * 2];
            }
            int end = Math.min(offset + numSamples, samples.length);
            int ii = 0;
            for (int i = offset; i < end; ++i) {
                float floatSample = samples[i];
                floatSample = MathUtils.clamp((float)floatSample, (float)-1.0f, (float)1.0f);
                int intSample = (int)(floatSample * 32767.0f);
                this.bytes[ii++] = (byte)(intSample & 0xFF);
                this.bytes[ii++] = (byte)(intSample >> 8 & 0xFF);
            }
            this.writeBytes(this.bytes, 0, numSamples * 2);
        }

        public boolean isMono() {
            return this.format == 4353;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVolume(float volume) {
            Device device = this;
            synchronized (device) {
                this.volume = volume;
                GDXAudio.this.setSourceGain(this.sourceId, volume);
            }
        }

        public int getLatency() {
            int bufferLatency = this.bufferSize / 2;
            return bufferLatency * this.bufferCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Device device = this;
            synchronized (device) {
                if (this.sourceId != -1) {
                    GDXAudio.this.freeSource(this.sourceId);
                    this.sourceId = -1;
                    this.renderedBytes = 0L;
                    this.isPlaying = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pause() {
            Device device = this;
            synchronized (device) {
                GDXAudio.this.pauseSource(this.sourceId);
                this.isPlaying = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume() {
            Device device = this;
            synchronized (device) {
                GDXAudio.this.resumeSource(this.sourceId);
                this.isPlaying = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update() {
            Device device = this;
            synchronized (device) {
                this.update(this.sourceId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(int sourceId) {
            Device device = this;
            synchronized (device) {
                if (sourceId != -1 && sourceId == this.sourceId) {
                    int buffers = AL10.alGetSourcei((int)sourceId, (int)4118);
                    while (buffers-- > 0) {
                        int bufferId = AL10.alSourceUnqueueBuffers((int)sourceId);
                        if (bufferId == 40963) {
                            Gdx.app.error("OpenAL", "Invalid buffer for music " + this);
                            return;
                        }
                        int offset = bufferId - this.bufferStart;
                        if (offset < 0 || offset > this.byteoffs.length) {
                            offset = bufferId < this.byteoffs.length ? bufferId : this.byteoffs.length - 1;
                        }
                        this.renderedBytes += this.byteoffs[offset];
                        this.usedBuffers.put(bufferId, 0);
                        ++this.bufferAvail;
                    }
                }
            }
        }

        @Override
        public boolean evictable() {
            return false;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPlaying() {
            Device device = this;
            synchronized (device) {
                return this.isPlaying && !GDXAudio.this.globalPause;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getVolume() {
            Device device = this;
            synchronized (device) {
                return this.volume;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPosition(float position) {
            Device device = this;
            synchronized (device) {
                int channels = this.getChannels();
                double pos = position;
                this.renderedBytes = (long)(pos * (double)this.sampleRate * (double)channels * 2.0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getPosition() {
            Device device = this;
            synchronized (device) {
                if (this.sourceId == -1) {
                    return 0.0f;
                }
                int channels = this.getChannels();
                long offset = this.renderedBytes + (long)AL10.alGetSourcei((int)this.sourceId, (int)4134);
                return (float)offset / 2.0f / (float)channels / (float)this.sampleRate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeBytes(byte[] data, int offset, int length) {
            if (length < 0) {
                throw new IllegalArgumentException("length cannot be < 0.");
            }
            if (GDXAudio.this.globalPause) {
                Gdx.app.log("OpenAL", "Writing samples to a paused audio sytem [potential deadlock]");
            }
            Device device = this;
            synchronized (device) {
                int written;
                if (this.sourceId == -1) {
                    this.sourceId = GDXAudio.this.obtainSource(this);
                    if (this.sourceId == -1) {
                        return;
                    }
                    AL10.alSourcei((int)this.sourceId, (int)4103, (int)0);
                    AL10.alSourcef((int)this.sourceId, (int)4106, (float)this.volume);
                    written = this.fill(data, offset, length);
                    length -= written;
                    offset += written;
                    if (GDXAudio.this.globalPause) {
                        ((GDXAudio)GDXAudio.this).paused[((GDXAudio)GDXAudio.this).sourceToIndex.get((int)this.sourceId, (int)-1)] = true;
                    } else {
                        AL10.alSourcePlay((int)this.sourceId);
                    }
                    this.isPlaying = true;
                }
                while (length > 0) {
                    this.drain();
                    written = this.fill(data, offset, length);
                    length -= written;
                    offset += written;
                    if (this.isPlaying && GDXAudio.this.getSourceState(this.sourceId) == 4114) continue;
                    if (GDXAudio.this.globalPause) {
                        ((GDXAudio)GDXAudio.this).paused[((GDXAudio)GDXAudio.this).sourceToIndex.get((int)this.sourceId, (int)-1)] = true;
                    } else {
                        AL10.alSourcePlay((int)this.sourceId);
                    }
                    this.isPlaying = true;
                }
            }
        }

        private int getChannels() {
            return this.format == 4355 ? 2 : 1;
        }

        private int obtainBuffer() {
            int endBuffer = (this.nextBuffer + this.bufferCount - 1) % this.bufferCount;
            int ii = this.nextBuffer;
            while (ii != endBuffer) {
                int bufferId = this.allBuffers.get(ii);
                if (this.usedBuffers.get(bufferId, 1) == 0) {
                    this.usedBuffers.put(bufferId, 1);
                    this.nextBuffer = (ii + 1) % this.bufferCount;
                    --this.bufferAvail;
                    return bufferId;
                }
                ii = (ii + 1) % this.bufferCount;
            }
            return -1;
        }

        private int fill(byte[] data, int offset, int length) {
            int written = 0;
            while (written < length) {
                if (this.bufferAvail == 0) {
                    return written;
                }
                int bufferId = this.obtainBuffer();
                int amount = Math.min(this.bufferSize, length - written);
                this.tempBuffer.clear();
                this.tempBuffer.put(data, offset, amount).flip();
                AL10.alBufferData((int)bufferId, (int)this.format, (ByteBuffer)this.tempBuffer, (int)this.sampleRate);
                AL10.alSourceQueueBuffers((int)this.sourceId, (int)bufferId);
                written += amount;
                offset += amount;
            }
            return written;
        }

        private void drain() {
            while (this.bufferAvail == 0) {
                this.update(this.sourceId);
                if (this.bufferAvail != 0) continue;
                try {
                    Thread.sleep((long)(1000.0f * this.secondsPerBuffer));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

